/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.logic;

import iskallia.vault.entity.LegacyEntityScaler;
import iskallia.vault.entity.entity.AggressiveCowEntity;
import iskallia.vault.entity.entity.EtchingVendorEntity;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.init.ModEntities;
import iskallia.vault.world.vault.VaultRaid;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class VaultCowOverrides {
    private static final UUID DAMAGE_NERF_MULTIPLIER = UUID.fromString("384df991-f603-344c-a090-3693adfa984a");
    public static boolean forceSpecialVault = false;
    public static final String ENTITY_TAG = "replaced_entity";

    public static void setupVault(VaultRaid vault) {
        vault.getEvents().add(VaultRaid.REPLACE_WITH_COW);
    }

    @Nullable
    public static AggressiveCowEntity replaceVaultEntity(VaultRaid vault, LivingEntity spawned, ServerLevel world) {
        if (spawned instanceof Silverfish || spawned instanceof EtchingVendorEntity || spawned instanceof EternalEntity) {
            spawned.m_20049_(ENTITY_TAG);
            return null;
        }
        LegacyEntityScaler.scaleVaultEntity(vault, (Entity)spawned);
        AggressiveCowEntity override = (AggressiveCowEntity)ModEntities.AGGRESSIVE_COW.m_20615_((Level)world);
        AttributeMap mgr = override.m_21204_();
        for (Attribute attr : ForgeRegistries.ATTRIBUTES) {
            if (!spawned.m_21204_().m_22171_(attr) || !mgr.m_22171_(attr)) continue;
            override.m_21051_(attr).m_22100_(spawned.m_21133_(attr));
        }
        mgr.m_22146_(Attributes.f_22281_).m_22125_(new AttributeModifier(DAMAGE_NERF_MULTIPLIER, "Scaling Damage Reduction", 0.4, AttributeModifier.Operation.MULTIPLY_TOTAL));
        if (spawned instanceof Mob) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack has = override.m_6844_(slot);
                if (!has.m_41619_()) {
                    spawned.m_8061_(slot, has.m_41777_());
                    continue;
                }
                spawned.m_8061_(slot, ItemStack.f_41583_);
            }
        }
        override.m_20049_(ENTITY_TAG);
        return override;
    }
}

