/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.influence;

import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.influence.VaultInfluence;
import iskallia.vault.world.vault.influence.VaultInfluenceRegistry;
import iskallia.vault.world.vault.player.VaultPlayer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.common.util.INBTSerializable;

public class VaultInfluences
implements INBTSerializable<CompoundTag>,
Iterable<VaultInfluence> {
    private final List<VaultInfluence> influences = new ArrayList<VaultInfluence>();
    protected boolean initialized = false;

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized() {
        this.initialized = true;
    }

    public void addInfluence(VaultInfluence influence, VaultRaid vault, ServerLevel world) {
        this.influences.add(influence);
        Random rand = world.m_5822_();
        vault.getPlayers().forEach(vPlayer -> influence.apply(vault, (VaultPlayer)vPlayer, world, rand));
    }

    public void tick(VaultRaid vault, VaultPlayer vPlayer, ServerLevel world) {
        this.forEach(influence -> influence.tick(vault, vPlayer, world));
    }

    public <T extends VaultInfluence> List<T> getInfluences(Class<T> influenceClass) {
        return this.influences.stream().filter(influence -> influenceClass.isAssignableFrom(influence.getClass())).map(influence -> influence).collect(Collectors.toList());
    }

    @Override
    public Iterator<VaultInfluence> iterator() {
        return this.influences.iterator();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("initialized", this.initialized);
        ListTag influenceList = new ListTag();
        for (VaultInfluence influence : this.influences) {
            CompoundTag ct = new CompoundTag();
            ct.m_128359_("id", influence.getKey().toString());
            ct.m_128365_("data", (Tag)influence.serializeNBT());
        }
        tag.m_128365_("influences", (Tag)influenceList);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.initialized = tag.m_128471_("initialized");
        ListTag influenceList = tag.m_128437_("influences", 10);
        for (int i = 0; i < influenceList.size(); ++i) {
            CompoundTag ct = influenceList.m_128728_(i);
            VaultInfluenceRegistry.getInfluence(new ResourceLocation(ct.m_128461_("id"))).ifPresent(influence -> {
                influence.deserializeNBT(ct.m_128469_("data"));
                this.influences.add((VaultInfluence)influence);
            });
        }
    }
}

