/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.influence;

import iskallia.vault.world.vault.influence.DamageInfluence;
import iskallia.vault.world.vault.influence.DamageTakenInfluence;
import iskallia.vault.world.vault.influence.EffectInfluence;
import iskallia.vault.world.vault.influence.MobAttributeInfluence;
import iskallia.vault.world.vault.influence.MobsInfluence;
import iskallia.vault.world.vault.influence.TimeInfluence;
import iskallia.vault.world.vault.influence.VaultAttributeInfluence;
import iskallia.vault.world.vault.influence.VaultInfluence;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class VaultInfluenceRegistry {
    private static final Map<ResourceLocation, Supplier<VaultInfluence>> influences = new HashMap<ResourceLocation, Supplier<VaultInfluence>>();

    public static void init() {
        influences.clear();
        VaultInfluenceRegistry.register(TimeInfluence.ID, TimeInfluence::new);
        VaultInfluenceRegistry.register(EffectInfluence.ID, EffectInfluence::new);
        VaultInfluenceRegistry.register(MobAttributeInfluence.ID, MobAttributeInfluence::new);
        VaultInfluenceRegistry.register(MobsInfluence.ID, MobsInfluence::new);
        VaultInfluenceRegistry.register(DamageInfluence.ID, DamageInfluence::new);
        VaultInfluenceRegistry.register(DamageTakenInfluence.ID, DamageTakenInfluence::new);
        Arrays.stream(VaultAttributeInfluence.Type.values()).forEach(type -> VaultInfluenceRegistry.register(VaultAttributeInfluence.newInstance(type)));
    }

    public static Optional<VaultInfluence> getInfluence(ResourceLocation key) {
        return Optional.ofNullable(influences.get(key)).map(Supplier::get);
    }

    private static void register(Supplier<VaultInfluence> defaultSupplier) {
        influences.put(defaultSupplier.get().getKey(), defaultSupplier);
    }

    private static void register(ResourceLocation key, Supplier<VaultInfluence> defaultSupplier) {
        influences.put(key, defaultSupplier);
    }
}

