/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.influence;

import iskallia.vault.VaultMod;
import iskallia.vault.world.vault.influence.VaultInfluence;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class MobAttributeInfluence
extends VaultInfluence {
    public static final ResourceLocation ID = VaultMod.id("mob_attribute");
    private Attribute targetAttribute;
    private AttributeModifier modifier;

    MobAttributeInfluence() {
        super(ID);
    }

    public MobAttributeInfluence(Attribute targetAttribute, AttributeModifier modifier) {
        this();
        this.targetAttribute = targetAttribute;
        this.modifier = modifier;
    }

    public void applyTo(LivingEntity le) {
        AttributeInstance instance = le.m_21051_(this.targetAttribute);
        AttributeModifier existing = instance.m_22111_(this.modifier.m_22209_());
        if (existing == null) {
            instance.m_22125_(this.modifier);
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128359_("attribute", this.targetAttribute.getRegistryName().toString());
        tag.m_128365_("modifier", (Tag)this.modifier.m_22219_());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.targetAttribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(tag.m_128461_("attribute")));
        this.modifier = AttributeModifier.m_22212_((CompoundTag)tag.m_128469_("modifier"));
    }
}

