/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen.piece;

import iskallia.vault.VaultMod;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class VaultRoom
extends VaultPiece {
    public static final ResourceLocation ID = VaultMod.id("room");
    private boolean cakeEaten = false;
    private BlockPos cakePos = null;
    private VListNBT<UUID, StringTag> sandIds = VListNBT.ofUUID();

    protected VaultRoom(ResourceLocation id) {
        super(id);
    }

    public VaultRoom() {
        this(ID);
    }

    protected VaultRoom(ResourceLocation id, ResourceLocation template, BoundingBox boundingBox, Rotation rotation) {
        super(id, template, boundingBox, rotation);
    }

    public VaultRoom(ResourceLocation template, BoundingBox boundingBox, Rotation rotation) {
        this(ID, template, boundingBox, rotation);
    }

    @Override
    public void tick(ServerLevel world, VaultRaid vault) {
    }

    public void setCakeEaten(boolean cakeEaten) {
        this.cakeEaten = cakeEaten;
    }

    public boolean isCakeEaten() {
        return this.cakeEaten;
    }

    public void setCakePos(BlockPos cakePos) {
        this.cakePos = cakePos;
    }

    public List<UUID> getSandId() {
        return this.sandIds;
    }

    public void addSandId(UUID sandId) {
        this.sandIds.add(sandId);
    }

    @Nullable
    public BlockPos getCakePos() {
        return this.cakePos;
    }

    public Vec3i getCenter() {
        return this.getBoundingBox().m_162394_();
    }

    public BlockPos getTunnelConnectorPos(Direction dir) {
        Vec3i center = this.getCenter();
        BlockPos size = new BlockPos(this.getBoundingBox().m_71053_()).m_142082_(2, 2, 2);
        return new BlockPos(center).m_142082_(dir.m_122429_() * size.m_123341_(), 0, dir.m_122431_() * size.m_123343_());
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128379_("cakeEaten", this.cakeEaten);
        if (this.cakePos != null) {
            tag.m_128365_("cakePos", (Tag)NBTHelper.serializeBlockPos(this.cakePos));
        }
        tag.m_128365_("sandIds", (Tag)this.sandIds.serializeNBT());
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.cakeEaten = tag.m_128471_("cakeEaten");
        if (tag.m_128425_("cakePos", 10)) {
            this.cakePos = NBTHelper.deserializeBlockPos(tag.m_128469_("cakePos"));
        }
        this.sandIds.deserializeNBT(tag.m_128437_("sandIds", 8));
    }
}

