/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen.piece;

import iskallia.vault.VaultMod;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.gen.structure.pool.PalettedListPoolElement;
import iskallia.vault.world.gen.structure.pool.PalettedSinglePoolElement;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.piece.FinalVaultLobby;
import iskallia.vault.world.vault.gen.piece.VaultObelisk;
import iskallia.vault.world.vault.gen.piece.VaultPortal;
import iskallia.vault.world.vault.gen.piece.VaultRaidRoom;
import iskallia.vault.world.vault.gen.piece.VaultRoom;
import iskallia.vault.world.vault.gen.piece.VaultStart;
import iskallia.vault.world.vault.gen.piece.VaultTreasure;
import iskallia.vault.world.vault.gen.piece.VaultTunnel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class VaultPiece
implements INBTSerializable<CompoundTag> {
    public static final Map<ResourceLocation, Supplier<VaultPiece>> REGISTRY = new HashMap<ResourceLocation, Supplier<VaultPiece>>();
    protected ResourceLocation id;
    protected ResourceLocation template;
    protected BoundingBox boundingBox;
    protected Rotation rotation;
    protected UUID uuid = UUID.randomUUID();

    protected VaultPiece(ResourceLocation id) {
        this.id = id;
    }

    protected VaultPiece(ResourceLocation id, ResourceLocation template, BoundingBox boundingBox, Rotation rotation) {
        this.id = id;
        this.template = template;
        this.boundingBox = boundingBox;
        this.rotation = rotation;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation getTemplate() {
        return this.template;
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public abstract void tick(ServerLevel var1, VaultRaid var2);

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Id", this.id.toString());
        nbt.m_128359_("Template", this.template.toString());
        nbt.m_128365_("BoundingBox", (Tag)NBTHelper.serializeBoundingBox(this.boundingBox));
        nbt.m_128405_("Rotation", this.rotation.ordinal());
        nbt.m_128359_("UUID", this.uuid.toString());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.id = new ResourceLocation(nbt.m_128461_("Id"));
        this.template = new ResourceLocation(nbt.m_128461_("Template"));
        this.boundingBox = NBTHelper.deserializeBoundingBox(nbt.m_128465_("BoundingBox"));
        this.rotation = Rotation.values()[nbt.m_128451_("Rotation")];
        if (nbt.m_128425_("UUID", 8)) {
            this.uuid = UUID.fromString(nbt.m_128461_("UUID"));
        }
    }

    public boolean isInside(AABB box) {
        return AABB.m_82321_((BoundingBox)this.boundingBox).m_82381_(box);
    }

    public boolean contains(BlockPos pos) {
        return this.boundingBox.m_71051_((Vec3i)pos);
    }

    public static VaultPiece fromNBT(CompoundTag nbt) {
        ResourceLocation id = new ResourceLocation(nbt.m_128461_("Id"));
        VaultPiece piece = REGISTRY.getOrDefault(id, () -> null).get();
        if (piece == null) {
            VaultMod.LOGGER.error("Piece <" + id + "> is not defined.");
            return null;
        }
        try {
            piece.deserializeNBT(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return piece;
    }

    public static boolean shouldIgnoreCollision(StructurePoolElement jigsaw) {
        for (VaultPiece piece : VaultPiece.of(jigsaw, BoundingBox.m_71044_(), Rotation.NONE)) {
            if (!(piece instanceof VaultObelisk)) continue;
            return true;
        }
        return false;
    }

    public static List<VaultPiece> of(StructurePiece raw) {
        if (!(raw instanceof PoolElementStructurePiece)) {
            return new ArrayList<VaultPiece>();
        }
        return VaultPiece.of(((PoolElementStructurePiece)raw).m_209918_(), raw.m_73547_(), raw.m_6830_());
    }

    public static List<VaultPiece> of(StructurePoolElement jigsaw, BoundingBox box, Rotation rotation) {
        ArrayList<PalettedSinglePoolElement> elements = new ArrayList<PalettedSinglePoolElement>();
        if (jigsaw instanceof PalettedSinglePoolElement) {
            elements.add((PalettedSinglePoolElement)jigsaw);
        } else if (jigsaw instanceof PalettedListPoolElement) {
            ((PalettedListPoolElement)jigsaw).getElements().forEach(jigsawPiece -> {
                if (jigsawPiece instanceof PalettedSinglePoolElement) {
                    elements.add((PalettedSinglePoolElement)((Object)jigsawPiece));
                }
            });
        }
        return elements.stream().map(element -> {
            ResourceLocation template = (ResourceLocation)element.getTemplate().left().get();
            String path = template.m_135815_();
            if (path.startsWith("vault/prefab/decor/generic/obelisk")) {
                return new VaultObelisk(template, box, rotation);
            }
            if (path.startsWith("vault/enigma/rooms")) {
                if (path.contains("layer0")) {
                    return new VaultRoom(template, box, rotation);
                }
            } else {
                if (path.startsWith("architect_event/enigma/rooms")) {
                    return new VaultRoom(template, box, rotation);
                }
                if (path.startsWith("raid/enigma/rooms")) {
                    return new VaultRaidRoom(template, box, rotation);
                }
                if (path.startsWith("vault/enigma/tunnels")) {
                    return new VaultTunnel(template, box, rotation);
                }
                if (path.startsWith("vault/enigma/starts") || path.startsWith("architect_event/enigma/starts") || path.startsWith("raid/enigma/starts") || path.startsWith("trove/enigma/starts")) {
                    return new VaultStart(template, box, rotation);
                }
                if (path.startsWith("vault/enigma/treasure")) {
                    return new VaultTreasure(template, box, rotation);
                }
                if (path.startsWith("final_vault/starts")) {
                    return new FinalVaultLobby(template, box, rotation);
                }
                if (path.startsWith("final_vault/portals")) {
                    return new VaultPortal(template, box, rotation);
                }
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

