/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen.layout;

import iskallia.vault.world.vault.gen.layout.CircleRoomLayout;
import iskallia.vault.world.vault.gen.layout.DebugVaultLayout;
import iskallia.vault.world.vault.gen.layout.DenseDiamondRoomLayout;
import iskallia.vault.world.vault.gen.layout.DenseSquareRoomLayout;
import iskallia.vault.world.vault.gen.layout.DiamondRoomLayout;
import iskallia.vault.world.vault.gen.layout.LineRoomLayout;
import iskallia.vault.world.vault.gen.layout.SingularVaultRoomLayout;
import iskallia.vault.world.vault.gen.layout.SpiralRoomLayout;
import iskallia.vault.world.vault.gen.layout.SquareRoomLayout;
import iskallia.vault.world.vault.gen.layout.TriangleRoomLayout;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class VaultRoomLayoutRegistry {
    private static final Map<ResourceLocation, Supplier<VaultRoomLayoutGenerator>> layoutRegistry = new HashMap<ResourceLocation, Supplier<VaultRoomLayoutGenerator>>();

    public static void init() {
        layoutRegistry.put(SingularVaultRoomLayout.ID, SingularVaultRoomLayout::new);
        layoutRegistry.put(LineRoomLayout.ID, LineRoomLayout::new);
        layoutRegistry.put(DiamondRoomLayout.ID, DiamondRoomLayout::new);
        layoutRegistry.put(SquareRoomLayout.ID, SquareRoomLayout::new);
        layoutRegistry.put(CircleRoomLayout.ID, CircleRoomLayout::new);
        layoutRegistry.put(TriangleRoomLayout.ID, TriangleRoomLayout::new);
        layoutRegistry.put(SpiralRoomLayout.ID, SpiralRoomLayout::new);
        layoutRegistry.put(DebugVaultLayout.ID, DebugVaultLayout::new);
        layoutRegistry.put(DenseDiamondRoomLayout.ID, DenseDiamondRoomLayout::new);
        layoutRegistry.put(DenseSquareRoomLayout.ID, DenseSquareRoomLayout::new);
    }

    @Nullable
    public static VaultRoomLayoutGenerator getLayoutGenerator(ResourceLocation id) {
        return layoutRegistry.containsKey(id) ? layoutRegistry.get(id).get() : null;
    }

    @Nullable
    public static VaultRoomLayoutGenerator deserialize(CompoundTag tag) {
        if (!tag.m_128425_("Id", 8)) {
            return null;
        }
        VaultRoomLayoutGenerator layout = VaultRoomLayoutRegistry.getLayoutGenerator(new ResourceLocation(tag.m_128461_("Id")));
        if (layout == null) {
            return null;
        }
        layout.deserialize(tag.m_128469_("Data"));
        layout.generateLayout();
        return layout;
    }

    public static CompoundTag serialize(VaultRoomLayoutGenerator roomLayout) {
        CompoundTag layoutTag = new CompoundTag();
        layoutTag.m_128359_("Id", roomLayout.getId().toString());
        layoutTag.m_128365_("Data", (Tag)roomLayout.serialize());
        return layoutTag;
    }
}

