/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen.layout;

import iskallia.vault.world.gen.structure.JigsawPatternFilter;
import iskallia.vault.world.vault.gen.layout.JigsawPoolProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public abstract class VaultRoomLayoutGenerator
implements JigsawPoolProvider {
    private final ResourceLocation id;

    protected VaultRoomLayoutGenerator(ResourceLocation id) {
        this.id = id;
    }

    public final ResourceLocation getId() {
        return this.id;
    }

    public abstract void setSize(int var1);

    public abstract Layout generateLayout();

    protected CompoundTag serialize() {
        return new CompoundTag();
    }

    protected void deserialize(CompoundTag tag) {
    }

    public static class Tunnel {
        private final Room from;
        private final Room to;
        private final JigsawPatternFilter jigsawFilter = new JigsawPatternFilter();

        public Tunnel(Room from, Room to) {
            this.from = from;
            this.to = to;
        }

        public Tunnel(Room from, Room to, Predicate<ResourceLocation> tunnelPieceFilter) {
            this(from, to);
            this.jigsawFilter.andMatches(tunnelPieceFilter);
        }

        public Room getFrom() {
            return this.from;
        }

        public Room getTo() {
            return this.to;
        }

        public Rotation getRandomConnectingRotation(Random random) {
            if (this.getFrom().getRoomPosition().m_123341_() - this.getTo().getRoomPosition().m_123341_() == 0) {
                return Rotation.CLOCKWISE_180;
            }
            return Rotation.CLOCKWISE_90;
        }

        public BlockPos getAbsoluteOffset(Rotation vaultRotation, Rotation tunnelRotation) {
            Vec3i from = this.getFrom().getRoomPosition();
            Vec3i to = this.getTo().getRoomPosition();
            Vec3i dir = new Vec3i(to.m_123341_() - from.m_123341_(), 0, to.m_123343_() - from.m_123343_());
            BlockPos relativeOffset = this.getFrom().getRoomOffset().m_142082_(dir.m_123341_() * 47, 0, dir.m_123343_() * 47);
            if (dir.m_123341_() < 0) {
                relativeOffset = relativeOffset.m_142082_(-1, 0, 0);
            }
            if (dir.m_123343_() < 0) {
                relativeOffset = relativeOffset.m_142082_(0, 0, -1);
            }
            return relativeOffset.m_7954_(vaultRotation).m_141952_((Vec3i)new BlockPos(-5, 6, -24).m_7954_(tunnelRotation));
        }

        public StructurePoolElement getRandomPiece(StructureTemplatePool pattern, Random random) {
            return this.jigsawFilter.getRandomPiece(pattern, random);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tunnel tunnel = (Tunnel)o;
            return Objects.equals(this.from, tunnel.from) && Objects.equals(this.to, tunnel.to) || Objects.equals(this.from, tunnel.to) && Objects.equals(this.to, tunnel.from);
        }

        public int hashCode() {
            return this.from.hashCode() ^ this.to.hashCode();
        }
    }

    public static class Room {
        protected final Vec3i roomPosition;
        private final JigsawPatternFilter jigsawFilter = new JigsawPatternFilter();

        public Room(Vec3i roomPosition) {
            this.roomPosition = roomPosition;
        }

        public Room andFilter(Predicate<ResourceLocation> roomPieceFilter) {
            this.jigsawFilter.andMatches(roomPieceFilter);
            return this;
        }

        public Vec3i getRoomPosition() {
            return this.roomPosition;
        }

        public boolean canGenerateTreasureRooms() {
            return true;
        }

        public BlockPos getRoomOffset() {
            return new BlockPos(this.getRoomPosition().m_123341_() * 47 + this.getRoomPosition().m_123341_() * 48, 0, this.getRoomPosition().m_123343_() * 47 + this.getRoomPosition().m_123343_() * 48);
        }

        public BlockPos getAbsoluteOffset(Rotation vaultRotation, Rotation roomRotation) {
            return this.getRoomOffset().m_7954_(vaultRotation).m_141952_((Vec3i)new BlockPos(-23, -13, -23).m_7954_(roomRotation));
        }

        public StructurePoolElement getRandomPiece(StructureTemplatePool pattern, Random random) {
            return this.jigsawFilter.getRandomPiece(pattern, random);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Room room = (Room)o;
            return Objects.equals(this.roomPosition, room.roomPosition);
        }

        public int hashCode() {
            return Objects.hash(this.roomPosition);
        }
    }

    public static class Layout {
        private final Map<Vec3i, Room> rooms = new HashMap<Vec3i, Room>();
        private final Set<Tunnel> tunnels = new HashSet<Tunnel>();

        protected void putRoom(Vec3i roomPosition) {
            this.putRoom(new Room(roomPosition));
        }

        protected void putRoom(Room room) {
            this.rooms.put(room.getRoomPosition(), room);
        }

        @Nullable
        public Room getRoom(Vec3i v) {
            return this.rooms.get(v);
        }

        public Collection<Room> getRooms() {
            return this.rooms.values();
        }

        protected void addTunnel(Room from, Room to) {
            this.addTunnel(new Tunnel(from, to));
        }

        protected void addTunnel(Tunnel tunnel) {
            this.tunnels.add(tunnel);
        }

        public Collection<Tunnel> getTunnels() {
            return this.tunnels;
        }
    }
}

