/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen.layout;

import iskallia.vault.VaultMod;
import iskallia.vault.world.vault.gen.layout.ConnectedRoomGenerator;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class TriangleRoomLayout
extends ConnectedRoomGenerator {
    public static final ResourceLocation ID = VaultMod.id("triangle");
    private int size;

    public TriangleRoomLayout() {
        this(11);
    }

    public TriangleRoomLayout(int size) {
        super(ID);
        this.size = size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public VaultRoomLayoutGenerator.Layout generateLayout() {
        VaultRoomLayoutGenerator.Layout layout = new VaultRoomLayoutGenerator.Layout();
        if (this.size % 2 == 0) {
            throw new IllegalArgumentException("Cannot generate vault square shape with even size!");
        }
        this.calculateRooms(layout, this.size);
        this.connectRooms(layout, this.size + 2);
        return layout;
    }

    private void calculateRooms(VaultRoomLayoutGenerator.Layout layout, int size) {
        int halfSize = size / 2;
        Direction facing = Direction.m_122407_((int)rand.nextInt(4));
        Vec3i directionVec = facing.m_122436_();
        Vec3i offset = directionVec.m_5484_(facing, -halfSize);
        Direction edgeFacing = facing.m_122427_();
        Vec3i corner = offset.m_5484_(edgeFacing, -halfSize);
        for (int hItr = 0; hItr <= size; ++hItr) {
            float allowedDst = (float)(size - hItr) / (float)size;
            for (int wItr = 0; wItr <= size; ++wItr) {
                float dst = (float)Math.abs(wItr - halfSize) / (float)halfSize;
                if (dst > allowedDst) continue;
                Vec3i roomPos = corner.m_5484_(edgeFacing, wItr).m_5484_(facing, hItr);
                layout.putRoom(roomPos);
            }
        }
    }

    @Override
    protected void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        if (tag.m_128425_("size", 3)) {
            this.size = tag.m_128451_("size");
        }
    }

    @Override
    protected CompoundTag serialize() {
        CompoundTag tag = super.serialize();
        tag.m_128405_("size", this.size);
        return tag;
    }
}

