/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen.layout;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Rotation;

public class SpiralHelper {
    public static Vec3i getSpiralPosition(int index, Direction facing, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> SpiralHelper.getSpiralPosition(index, facing, facing.m_122427_());
            case Rotation.COUNTERCLOCKWISE_90 -> SpiralHelper.getSpiralPosition(index, facing, facing.m_122428_());
            default -> throw new UnsupportedOperationException("Spiral does not support " + rotation + " rotation");
        };
    }

    public static Vec3i getSpiralPosition(int index, Direction facing, Direction rotation) {
        int x;
        int y;
        int k = (int)Math.ceil((Math.sqrt(index + 1) - 1.0) / 2.0);
        int a = 2 * k;
        int b = (a + 1) * (a + 1);
        if (index + 1 >= b - a) {
            y = -k;
            x = -y - (b - index - 1);
        } else if (index + 1 >= (b -= a) - a) {
            x = -k;
            y = x + (b - index - 1);
        } else if (index + 1 >= (b -= a) - a) {
            y = k;
            x = -y + (b - index - 1);
        } else {
            x = k;
            y = x - (b - index - a - 1);
        }
        switch (facing) {
            case EAST: {
                if (rotation != Direction.NORTH) break;
                y *= -1;
                break;
            }
            case WEST: {
                x *= -1;
                if (rotation != Direction.NORTH) break;
                y *= -1;
                break;
            }
            case NORTH: {
                int temp = x;
                x = y;
                y = temp;
                if (rotation != Direction.EAST) break;
                x *= -1;
                break;
            }
            case SOUTH: {
                int temp = x;
                x = y;
                y = -temp;
                if (rotation != Direction.EAST) break;
                x *= -1;
                break;
            }
            default: {
                return Vec3i.f_123288_;
            }
        }
        return new Vec3i(x, 0, y);
    }
}

