/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen.layout;

import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public abstract class DenseVaultLayout
extends VaultRoomLayoutGenerator {
    private int size;

    protected DenseVaultLayout(ResourceLocation key, int size) {
        super(key);
        this.size = size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public VaultRoomLayoutGenerator.Layout generateLayout() {
        VaultRoomLayoutGenerator.Layout layout = new VaultRoomLayoutGenerator.Layout();
        if (this.size % 2 == 0) {
            throw new IllegalArgumentException("Cannot generate vault diamond shape with even size!");
        }
        this.generateLayoutRooms(layout, this.size);
        return layout;
    }

    protected abstract void generateLayoutRooms(VaultRoomLayoutGenerator.Layout var1, int var2);

    @Override
    protected void deserialize(CompoundTag tag) {
        super.deserialize(tag);
        if (tag.m_128425_("size", 3)) {
            this.size = tag.m_128451_("size");
        }
    }

    @Override
    protected CompoundTag serialize() {
        CompoundTag tag = super.serialize();
        tag.m_128405_("size", this.size);
        return tag;
    }

    public static class DensePackedRoom
    extends VaultRoomLayoutGenerator.Room {
        public DensePackedRoom(Vec3i roomPosition) {
            super(roomPosition);
        }

        @Override
        public boolean canGenerateTreasureRooms() {
            return false;
        }

        @Override
        public BlockPos getRoomOffset() {
            return new BlockPos(this.getRoomPosition().m_123341_() * 47, 0, this.getRoomPosition().m_123343_() * 47);
        }
    }
}

