/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen.layout;

import iskallia.vault.VaultMod;
import iskallia.vault.world.vault.gen.layout.ConnectedRoomGenerator;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import java.awt.geom.Point2D;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;

public class CircleRoomLayout
extends ConnectedRoomGenerator {
    public static final ResourceLocation ID = VaultMod.id("circle");
    private int size;

    public CircleRoomLayout() {
        this(11);
    }

    public CircleRoomLayout(int size) {
        super(ID);
        this.size = size;
    }

    @Override
    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public VaultRoomLayoutGenerator.Layout generateLayout() {
        VaultRoomLayoutGenerator.Layout layout = new VaultRoomLayoutGenerator.Layout();
        if (this.size % 2 == 0) {
            throw new IllegalArgumentException("Cannot generate vault circle shape with even size!");
        }
        this.calculateRooms(layout, this.size);
        this.connectRooms(layout, this.size);
        return layout;
    }

    private void calculateRooms(VaultRoomLayoutGenerator.Layout layout, int size) {
        Point2D.Float center = new Point2D.Float(0.5f, 0.5f);
        int halfSize = size / 2;
        for (int x = -halfSize; x <= halfSize; ++x) {
            for (int z = -halfSize; z <= halfSize; ++z) {
                Point2D.Float roomPos = new Point2D.Float((float)x + 0.5f, (float)z + 0.5f);
                if (!(center.distance(roomPos) <= (double)halfSize)) continue;
                layout.putRoom(new Vec3i(x, 0, z));
            }
        }
    }
}

