/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen;

import iskallia.vault.VaultMod;
import iskallia.vault.world.gen.structure.pool.PalettedListPoolElement;
import iskallia.vault.world.gen.structure.pool.PalettedSinglePoolElement;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;

public class VaultRoomLevelRestrictions {
    public static void addGenerationPreventions(VaultRoomLayoutGenerator.Layout layout, int vaultLevel) {
        if (vaultLevel < 250) {
            layout.getRooms().forEach(room -> room.andFilter(key -> !key.toString().startsWith(VaultRoomLevelRestrictions.getVaultRoomPrefix("vendor"))));
        }
        if (vaultLevel < 100) {
            layout.getRooms().forEach(room -> room.andFilter(key -> !key.toString().startsWith(VaultRoomLevelRestrictions.getVaultRoomPrefix("contest_pixel"))));
        }
    }

    public static boolean canGenerate(StructurePoolElement vaultPiece, int vaultLevel) {
        if (vaultLevel < 250 && VaultRoomLevelRestrictions.isJigsawPieceOfName(vaultPiece, VaultRoomLevelRestrictions.getVaultRoomPrefix("vendor"))) {
            return false;
        }
        return vaultLevel >= 100 || !VaultRoomLevelRestrictions.isJigsawPieceOfName(vaultPiece, VaultRoomLevelRestrictions.getVaultRoomPrefix("contest_pixel"));
    }

    private static String getVaultRoomPrefix(String roomName) {
        return VaultMod.sId("vault/enigma/rooms/" + roomName);
    }

    private static boolean isJigsawPieceOfName(StructurePoolElement piece, String name) {
        ResourceLocation key;
        if (piece instanceof PalettedListPoolElement) {
            List<StructurePoolElement> elements = ((PalettedListPoolElement)piece).getElements();
            for (StructurePoolElement elementPiece : elements) {
                if (VaultRoomLevelRestrictions.isJigsawPieceOfName(elementPiece, name)) continue;
                return false;
            }
            return !elements.isEmpty();
        }
        if (piece instanceof PalettedSinglePoolElement && (key = (ResourceLocation)((PalettedSinglePoolElement)piece).getTemplate().left().orElse(null)) != null) {
            return key.toString().startsWith(name);
        }
        return false;
    }
}

