/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen;

import iskallia.vault.nbt.VListNBT;
import iskallia.vault.world.gen.PortalPlacer;
import iskallia.vault.world.gen.structure.pool.PalettedSinglePoolElement;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class VaultGenerator
implements INBTSerializable<CompoundTag> {
    public static Map<ResourceLocation, Supplier<? extends VaultGenerator>> REGISTRY = new HashMap<ResourceLocation, Supplier<? extends VaultGenerator>>();
    protected static final Random rand = new Random();
    protected VListNBT<VaultPiece, CompoundTag> pieces = VListNBT.of(VaultPiece::fromNBT);
    private ResourceLocation id;
    protected ChunkPos startChunk;

    public VaultGenerator(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ChunkPos getStartChunk() {
        return this.startChunk;
    }

    public abstract boolean generate(ServerLevel var1, VaultRaid var2, BlockPos.MutableBlockPos var3);

    public void tick(ServerLevel world, VaultRaid vault) {
        world.m_7726_().m_8387_(TicketType.f_9447_, this.startChunk, 3, (Object)this.startChunk.m_45615_());
        this.pieces.forEach(piece -> piece.tick(world, vault));
    }

    public void addPieces(VaultPiece ... pieces) {
        this.addPieces(Arrays.asList(pieces));
    }

    public void addPieces(Collection<VaultPiece> pieces) {
        this.pieces.addAll(pieces);
    }

    public Collection<VaultPiece> getPiecesAt(BlockPos pos) {
        return this.pieces.stream().filter(piece -> piece.contains(pos)).collect(Collectors.toSet());
    }

    public <T extends VaultPiece> Collection<T> getPiecesAt(BlockPos pos, Class<T> pieceClass) {
        return this.pieces.stream().filter(piece -> pieceClass.isAssignableFrom(piece.getClass())).filter(piece -> piece.contains(pos)).map(piece -> piece).collect(Collectors.toSet());
    }

    public <T extends VaultPiece> Collection<T> getPieces(Class<T> pieceClass) {
        return this.pieces.stream().filter(piece -> pieceClass.isAssignableFrom(piece.getClass())).map(piece -> piece).collect(Collectors.toSet());
    }

    public boolean intersectsWithAnyPiece(BoundingBox box) {
        return this.pieces.stream().map(VaultPiece::getBoundingBox).anyMatch(pieceBox -> pieceBox.m_71049_(box));
    }

    public boolean isObjectivePiece(StructurePiece piece) {
        if (!(piece instanceof PoolElementStructurePiece)) {
            return false;
        }
        StructurePoolElement jigsaw = ((PoolElementStructurePiece)piece).m_209918_();
        if (!(jigsaw instanceof PalettedSinglePoolElement)) {
            return false;
        }
        PalettedSinglePoolElement element = (PalettedSinglePoolElement)jigsaw;
        return ((ResourceLocation)element.getTemplate().left().get()).toString().startsWith("the_vault:vault/prefab/decor/generic/obelisk");
    }

    protected boolean findStartPosition(ServerLevel world, VaultRaid vault, ChunkPos startChunk, Supplier<PortalPlacer> portalPlacer) {
        block0: for (int x = -96; x < 96; ++x) {
            for (int z = -96; z < 96; ++z) {
                for (int y = 0; y < 48; ++y) {
                    BlockPos pos = startChunk.m_45615_().m_142082_(x, 19 + y, z);
                    if (world.m_8055_(pos).m_60734_() != Blocks.f_50659_) continue;
                    world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    vault.getProperties().create(VaultRaid.START_POS, pos);
                    for (Direction direction : Direction.Plane.HORIZONTAL) {
                        int count = 1;
                        while (world.m_8055_(pos.m_5484_(direction, count)).m_60734_() == Blocks.f_50660_) {
                            world.m_46597_(pos.m_5484_(direction, count), Blocks.f_50016_.m_49966_());
                            ++count;
                        }
                        if (count <= 1) continue;
                        PortalPlacer placer = portalPlacer.get();
                        if (placer == null) break block0;
                        vault.getProperties().create(VaultRaid.START_FACING, direction);
                        placer.place((LevelAccessor)world, pos, direction, count, count + 1);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("Id", this.getId().toString());
        if (this.startChunk != null) {
            nbt.m_128405_("StartChunkX", this.startChunk.f_45578_);
            nbt.m_128405_("StartChunkZ", this.startChunk.f_45579_);
        }
        nbt.m_128365_("Pieces", (Tag)this.pieces.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.id = new ResourceLocation(nbt.m_128461_("Id"));
        this.startChunk = new ChunkPos(nbt.m_128451_("StartChunkX"), nbt.m_128451_("StartChunkZ"));
        this.pieces.deserializeNBT(nbt.m_128437_("Pieces", 10));
    }

    public static VaultGenerator fromNBT(CompoundTag nbt) {
        VaultGenerator generator = REGISTRY.get(new ResourceLocation(nbt.m_128461_("Id"))).get();
        generator.deserializeNBT(nbt);
        return generator;
    }

    public static <T extends VaultGenerator> Supplier<T> register(Supplier<T> generator) {
        REGISTRY.put(((VaultGenerator)generator.get()).getId(), generator);
        return generator;
    }
}

