/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen;

import iskallia.vault.block.VaultPortalBlock;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModFeatures;
import iskallia.vault.world.gen.PortalPlacer;
import iskallia.vault.world.gen.structure.JigsawGenerator;
import iskallia.vault.world.gen.structure.RaidChallengeStructure;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.VaultGenerator;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class RaidChallengeGenerator
extends VaultGenerator {
    public static final int REGION_SIZE = 8192;

    public RaidChallengeGenerator(ResourceLocation id) {
        super(id);
    }

    public PortalPlacer getPortalPlacer() {
        return new PortalPlacer((pos, random, facing) -> (BlockState)ModBlocks.VAULT_PORTAL.m_49966_().m_61124_((Property)VaultPortalBlock.f_54904_, (Comparable)facing.m_122434_()), (pos, random, facing) -> Blocks.f_50735_.m_49966_());
    }

    @Override
    public boolean generate(ServerLevel world, VaultRaid vault, BlockPos.MutableBlockPos pos) {
        BoundingBox box = vault.getProperties().getBase(VaultRaid.BOUNDING_BOX).orElseGet(() -> {
            BlockPos min = pos.m_122184_(2000, 0, 0).m_7949_();
            BlockPos max = pos.m_122184_(8192, 0, 0).m_7949_();
            return new BoundingBox(min.m_123341_(), 0, min.m_123343_(), max.m_123341_(), 256, max.m_123343_() + 8192);
        });
        vault.getProperties().create(VaultRaid.BOUNDING_BOX, box);
        try {
            ChunkPos chunkPos = new ChunkPos(box.m_162395_() + box.m_71056_() / 2 >> 4, box.m_162398_() + box.m_71058_() / 2 >> 4);
            JigsawGenerator jigsaw = JigsawGenerator.builder(box, chunkPos.m_45615_().m_142082_(0, 19, 0)).setDepth(1).build();
            this.startChunk = new ChunkPos(jigsaw.getStartPos().m_123341_() >> 4, jigsaw.getStartPos().m_123343_() >> 4);
            StructureStart start = ((RaidChallengeStructure.Feature)ModFeatures.RAID_CHALLENGE_FEATURE.m_203334_()).generate(jigsaw, world.m_5962_(), world.m_7726_().m_8481_(), world.m_8875_(), 0, world.m_7328_(), (LevelHeightAccessor)world);
            jigsaw.getGeneratedPieces().stream().flatMap(piece -> VaultPiece.of(piece).stream()).forEach(this.pieces::add);
            world.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62314_, true).m_207296_((ConfiguredStructureFeature)ModFeatures.RAID_CHALLENGE_FEATURE.m_203334_(), start);
            this.tick(world, vault);
            if (!vault.getProperties().exists(VaultRaid.START_POS) || !vault.getProperties().exists(VaultRaid.START_FACING)) {
                return this.findStartPosition(world, vault, chunkPos, this::getPortalPlacer);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        return false;
    }
}

