/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.gen;

import iskallia.vault.block.VaultPortalBlock;
import iskallia.vault.config.VaultSizeConfig;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModFeatures;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.world.gen.FragmentedJigsawGenerator;
import iskallia.vault.world.gen.PortalPlacer;
import iskallia.vault.world.gen.structure.VaultStructure;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.VaultGenerator;
import iskallia.vault.world.vault.gen.VaultRoomLevelRestrictions;
import iskallia.vault.world.vault.gen.VaultRoomNames;
import iskallia.vault.world.vault.gen.layout.DiamondRoomLayout;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutRegistry;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class FragmentedVaultGenerator
extends VaultGenerator {
    public static final int REGION_SIZE = 8192;
    private VaultRoomLayoutGenerator layoutGenerator;
    private VaultSizeConfig.SizeLayout layout;

    public FragmentedVaultGenerator(ResourceLocation id) {
        super(id);
    }

    public FragmentedVaultGenerator setLayout(VaultSizeConfig.SizeLayout layout) {
        this.layout = layout;
        return this;
    }

    @Nonnull
    protected VaultRoomLayoutGenerator provideLayoutGenerator(VaultSizeConfig.SizeLayout layout) {
        VaultRoomLayoutGenerator generator = VaultRoomLayoutRegistry.getLayoutGenerator(layout.getLayout());
        if (generator == null) {
            generator = new DiamondRoomLayout();
        }
        generator.setSize(layout.getSize());
        return generator;
    }

    @Override
    public boolean generate(ServerLevel world, VaultRaid vault, BlockPos.MutableBlockPos pos) {
        VaultSizeConfig.SizeLayout layout;
        BoundingBox vaultBox = this.generateBoundingBox(vault, pos.m_7949_());
        pos.m_122175_(Direction.EAST, 8192);
        boolean raffle = vault.getProperties().getBase(VaultRaid.IS_RAFFLE).orElse(false);
        int level = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        boolean generatesTreasureRooms = vault.getProperties().getBase(VaultRaid.CRYSTAL_DATA).map(CrystalData::canGenerateTreasureRooms).orElse(true);
        VaultSizeConfig.SizeLayout sizeLayout = layout = this.layout != null ? this.layout : ModConfigs.VAULT_SIZE.getLayout(level, raffle);
        if (this.layoutGenerator == null) {
            this.layoutGenerator = vault.getAllObjectives().stream().findFirst().map(VaultObjective::getCustomLayout).orElse(this.provideLayoutGenerator(layout));
        }
        VaultRoomLayoutGenerator.Layout vaultLayout = this.layoutGenerator.generateLayout();
        this.setGuaranteedRooms(vaultLayout, vault);
        VaultRoomLevelRestrictions.addGenerationPreventions(vaultLayout, level);
        this.startChunk = new ChunkPos(new BlockPos((Vec3i)vaultBox.m_162394_()));
        FragmentedJigsawGenerator gen = new FragmentedJigsawGenerator(vaultBox, this.startChunk.m_45615_().m_142082_(0, 19, 0), generatesTreasureRooms, this.layoutGenerator, vaultLayout);
        StructureStart start = ((VaultStructure.Feature)ModFeatures.VAULT_FEATURE.m_203334_()).generate(gen, world.m_5962_(), world.m_7726_().m_8481_(), world.m_8875_(), 0, world.m_7328_(), (LevelHeightAccessor)world);
        gen.getGeneratedPieces().stream().flatMap(piece -> VaultPiece.of(piece).stream()).forEach(this.pieces::add);
        this.removeRandomObjectivePieces(vault, gen, layout.getObjectiveRoomRatio());
        world.m_6522_(this.startChunk.f_45578_, this.startChunk.f_45579_, ChunkStatus.f_62314_, true).m_207296_((ConfiguredStructureFeature)ModFeatures.VAULT_FEATURE.m_203334_(), start);
        this.tick(world, vault);
        if (!vault.getProperties().exists(VaultRaid.START_POS) || !vault.getProperties().exists(VaultRaid.START_FACING)) {
            return this.findStartPosition(world, vault, this.startChunk, () -> new PortalPlacer((pos1, random, facing) -> (BlockState)ModBlocks.VAULT_PORTAL.m_49966_().m_61124_((Property)VaultPortalBlock.f_54904_, (Comparable)facing.m_122434_()), (pos1, random, facing) -> Blocks.f_50730_.m_49966_()));
        }
        return false;
    }

    private void setGuaranteedRooms(VaultRoomLayoutGenerator.Layout vaultLayout, VaultRaid vault) {
        CrystalData data = vault.getProperties().getBaseOrDefault(VaultRaid.CRYSTAL_DATA, CrystalData.EMPTY);
        Collection<VaultRoomLayoutGenerator.Room> rooms = vaultLayout.getRooms();
        List<String> roomKeys = data.getGuaranteedRoomFilters();
        if (roomKeys.size() > rooms.size()) {
            roomKeys = roomKeys.subList(0, rooms.size());
        }
        HashSet usedRooms = new HashSet();
        roomKeys.forEach(roomKey -> {
            VaultRoomLayoutGenerator.Room room;
            if (VaultRoomNames.getName(roomKey) == null) {
                return;
            }
            while ((room = MiscUtils.getRandomEntry(vaultLayout.getRooms(), rand)) == null || usedRooms.contains(room.getRoomPosition())) {
            }
            usedRooms.add(room.getRoomPosition());
            room.andFilter(key -> key.m_135815_().contains((CharSequence)roomKey));
        });
    }

    private void removeRandomObjectivePieces(VaultRaid vault, FragmentedJigsawGenerator generator, float objectiveRatio) {
        int objectiveCount;
        List obeliskPieces = generator.getGeneratedPieces().stream().filter(this::isObjectivePiece).collect(Collectors.toList());
        Collections.shuffle(obeliskPieces);
        int maxObjectives = Mth.m_14143_((float)((float)obeliskPieces.size() / objectiveRatio));
        for (int i = objectiveCount = vault.getAllObjectives().stream().findFirst().map(objective -> objective.modifyObjectiveCount(maxObjectives)).orElse(maxObjectives).intValue(); i < obeliskPieces.size(); ++i) {
            generator.removePiece((StructurePiece)obeliskPieces.get(i));
        }
    }

    private BoundingBox generateBoundingBox(VaultRaid vault, BlockPos pos) {
        BoundingBox box = vault.getProperties().getBase(VaultRaid.BOUNDING_BOX).orElseGet(() -> {
            BlockPos max = pos.m_142082_(8192, 0, 8192);
            return new BoundingBox(pos.m_123341_(), 0, pos.m_123343_(), max.m_123341_(), 256, max.m_123343_());
        });
        vault.getProperties().create(VaultRaid.BOUNDING_BOX, box);
        return box;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        if (this.layoutGenerator != null) {
            tag.m_128365_("Layout", (Tag)VaultRoomLayoutRegistry.serialize(this.layoutGenerator));
        }
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        VaultRoomLayoutGenerator layout;
        super.deserializeNBT(nbt);
        if (nbt.m_128425_("Layout", 10) && (layout = VaultRoomLayoutRegistry.deserialize(nbt.m_128469_("Layout"))) != null) {
            this.layoutGenerator = layout;
        }
    }
}

