/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault.builder;

import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.world.data.VaultPartyData;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.builder.VaultRaidBuilder;
import iskallia.vault.world.vault.player.VaultPlayerType;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class FinalLobbyBuilder
extends VaultRaidBuilder {
    private static final FinalLobbyBuilder INSTANCE = new FinalLobbyBuilder();

    private FinalLobbyBuilder() {
    }

    public static FinalLobbyBuilder getInstance() {
        return INSTANCE;
    }

    @Override
    public VaultRaid.Builder initializeBuilder(ServerLevel world, ServerPlayer player, CrystalData crystal) {
        VaultRaid.Builder builder = this.getDefaultBuilder(crystal, world, player);
        Set players = crystal.getFrameData().tiles.stream().filter(tile -> tile.block == ModBlocks.FINAL_VAULT_FRAME).filter(tile -> tile.data.m_128425_("OwnerUUID", 8)).map(tile -> UUID.fromString(tile.data.m_128461_("OwnerUUID"))).collect(Collectors.toSet());
        if (!players.contains(player.m_142081_())) {
            return null;
        }
        for (Object uuid : players) {
            ServerPlayer vaultPlayer = world.m_142572_().m_6846_().m_11259_((UUID)uuid);
            if (vaultPlayer != null) continue;
            return null;
        }
        if (world.m_46469_().m_46207_(ModGameRules.FINAL_VAULT_ALLOW_PARTY)) {
            VaultPartyData data = VaultPartyData.get(world);
            for (UUID uuid : new ArrayList(players)) {
                data.getParty(uuid).ifPresent(party -> players.addAll(party.getMembers()));
            }
        }
        for (Object uuid : players) {
            ServerPlayer partyPlayer = world.m_142572_().m_6846_().m_11259_((UUID)uuid);
            if (partyPlayer == null) continue;
            builder.addPlayer(VaultPlayerType.RUNNER, partyPlayer);
        }
        builder.set(VaultRaid.HOST, player.m_142081_());
        builder.setGenerator(VaultRaid.FINAL_LOBBY);
        return builder;
    }
}

