/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault;

import iskallia.vault.world.vault.VaultRaid;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;

public class VaultUtils {
    public static void exitSafely(final ServerLevel world, final ServerPlayer player) {
        ResourceKey sourceDim;
        BlockPos rawSpawnPoint = player.m_8961_();
        final Optional spawnPoint = rawSpawnPoint != null ? Player.m_36130_((ServerLevel)world, (BlockPos)rawSpawnPoint, (float)player.m_8962_(), (boolean)player.m_8964_(), (boolean)true) : Optional.empty();
        ResourceKey targetDim = world.m_46472_();
        if (!targetDim.equals((Object)(sourceDim = player.m_20193_().m_46472_()))) {
            player.changeDimension(world, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    Entity repositionedEntity = repositionEntity.apply(false);
                    if (spawnPoint.isPresent()) {
                        Vec3 spawnPos = (Vec3)spawnPoint.get();
                        repositionedEntity.m_6021_(spawnPos.m_7096_(), spawnPos.m_7098_(), spawnPos.m_7094_());
                    } else {
                        VaultUtils.moveToWorldSpawn(world, player);
                    }
                    if (repositionedEntity instanceof ServerPlayer) {
                        ((ServerPlayer)repositionedEntity).m_183503_().m_142572_().m_6937_((Runnable)new TickTask(20, () -> ((ServerPlayer)repositionedEntity).m_6756_(0)));
                    }
                    return repositionedEntity;
                }

                public boolean playTeleportSound(ServerPlayer player2, ServerLevel sourceWorld, ServerLevel destWorld) {
                    return false;
                }
            });
        } else if (spawnPoint.isPresent()) {
            BlockState blockstate = world.m_8055_(rawSpawnPoint);
            Vec3 spawnPos = (Vec3)spawnPoint.get();
            if (!blockstate.m_204336_(BlockTags.f_13038_) && !blockstate.m_60713_(Blocks.f_50724_)) {
                player.m_8999_(world, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, player.m_8962_(), 0.0f);
            } else {
                Vec3 vector3d1 = Vec3.m_82539_((Vec3i)rawSpawnPoint).m_82546_(spawnPos).m_82541_();
                player.m_8999_(world, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, (float)Mth.m_14175_((double)(Mth.m_14136_((double)vector3d1.f_82481_, (double)vector3d1.f_82479_) * 57.29577951308232 - 90.0)), 0.0f);
            }
            player.m_6021_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
        } else {
            VaultUtils.moveToWorldSpawn(world, player);
        }
    }

    public static <T extends Entity> void changeDimension(ServerLevel world, T entity, final Vec3 position, final Vec3 velocity, final float yaw, final float pitch, final Consumer<T> runnable) {
        final MinecraftServer server = world.m_142572_();
        entity.changeDimension(world, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw2, Function<Boolean, Entity> repositionEntity) {
                Entity repositionedEntity = repositionEntity.apply(false);
                if (repositionedEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)repositionedEntity;
                    server.m_6937_((Runnable)new TickTask(server.m_129921_() + 20, () -> player.m_6756_(0)));
                }
                runnable.accept(repositionedEntity);
                return repositionedEntity;
            }

            public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
                return destWorld.m_46472_() == Level.f_46428_;
            }

            @Nullable
            public PortalInfo getPortalInfo(Entity entity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
                return new PortalInfo(position, velocity, yaw, pitch);
            }
        });
    }

    public static void moveTo(ServerLevel world, Entity entity, final Vec3 pos, Vec2 rotation) {
        entity.changeDimension(world, new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                Entity repositionedEntity = repositionEntity.apply(false);
                repositionedEntity.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                if (repositionedEntity instanceof ServerPlayer) {
                    ((ServerPlayer)repositionedEntity).m_183503_().m_142572_().m_6937_((Runnable)new TickTask(20, () -> ((ServerPlayer)repositionedEntity).m_6756_(0)));
                }
                return repositionedEntity;
            }
        });
    }

    public static void moveToWorldSpawn(ServerLevel world, ServerPlayer player) {
        long k;
        long l;
        BlockPos blockpos = world.m_8900_();
        if (!world.m_6042_().m_63935_() || world.m_142572_().m_129910_().m_5464_() == GameType.ADVENTURE) {
            player.m_8999_(world, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), 0.0f, 0.0f);
            player.m_6021_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
            while (!world.m_45786_((Entity)player) && player.m_20186_() < 255.0) {
                player.m_8999_(world, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 0.0f, 0.0f);
                player.m_6021_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            }
            return;
        }
        int i = Math.max(0, world.m_142572_().m_129803_(world));
        int j = Mth.m_14107_((double)world.m_6857_().m_61941_((double)blockpos.m_123341_(), (double)blockpos.m_123343_()));
        if (j < i) {
            i = j;
        }
        if (j <= 1) {
            i = 1;
        }
        int i1 = (l = (k = (long)(i * 2 + 1)) * k) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        int j1 = i1 <= 16 ? i1 - 1 : 17;
        int k1 = new Random().nextInt(i1);
        for (int l1 = 0; l1 < i1; ++l1) {
            int i2 = (k1 + j1 * l1) % i1;
            int j2 = i2 % (i * 2 + 1);
            int k2 = i2 / (i * 2 + 1);
            BlockPos pos = new BlockPos(blockpos.m_123341_() + j2 - i, 0, blockpos.m_123343_() + k2 - i);
            OptionalInt height = VaultUtils.getSpawnHeight(world, pos.m_123341_(), pos.m_123343_());
            if (!height.isPresent()) continue;
            player.m_8999_(world, (double)pos.m_123341_(), (double)height.getAsInt(), (double)pos.m_123343_(), 0.0f, 0.0f);
            player.m_6021_((double)pos.m_123341_(), (double)height.getAsInt(), (double)pos.m_123343_());
            if (world.m_45786_((Entity)player)) break;
        }
    }

    public static OptionalInt getSpawnHeight(ServerLevel world, int posX, int posZ) {
        int j;
        int top;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(posX, 0, posZ);
        LevelChunk chunk = world.m_6325_(posX >> 4, posZ >> 4);
        int n = top = world.m_6042_().m_63946_() ? world.m_7726_().m_8481_().m_142051_((LevelHeightAccessor)world) : chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING, posX & 0xF, posZ & 0xF);
        if (top >= 0 && ((j = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, posX & 0xF, posZ & 0xF)) > top || j <= chunk.m_5885_(Heightmap.Types.OCEAN_FLOOR, posX & 0xF, posZ & 0xF))) {
            for (int k = top + 1; k >= 0; --k) {
                pos.m_122178_(posX, k, posZ);
                BlockState state = world.m_8055_((BlockPos)pos);
                if (!state.m_60819_().m_76178_()) break;
            }
        }
        return OptionalInt.empty();
    }

    public static boolean matchesDimension(VaultRaid vault, Level world) {
        return vault.getProperties().getBase(VaultRaid.DIMENSION).filter(key -> key == world.m_46472_()).isPresent();
    }

    public static boolean inVault(VaultRaid vault, Entity entity) {
        return VaultUtils.inVault(vault, entity.m_20193_(), entity.m_142538_());
    }

    public static boolean inVault(VaultRaid vault, Level world, BlockPos pos) {
        if (vault == null) {
            return false;
        }
        Optional<ResourceKey<Level>> dimension = vault.getProperties().getBase(VaultRaid.DIMENSION);
        if (!dimension.isPresent() || world.m_46472_() != dimension.get()) {
            return false;
        }
        return vault.getProperties().getBase(VaultRaid.BOUNDING_BOX).map(box -> box.m_71051_((Vec3i)pos)).orElse(false);
    }

    public static boolean inVault(ServerPlayer player) {
        return true;
    }
}

