/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.vault;

import iskallia.vault.VaultMod;
import iskallia.vault.attribute.BlockPosAttribute;
import iskallia.vault.attribute.BooleanAttribute;
import iskallia.vault.attribute.BoundingBoxAttribute;
import iskallia.vault.attribute.CompoundAttribute;
import iskallia.vault.attribute.EnumAttribute;
import iskallia.vault.attribute.IntegerAttribute;
import iskallia.vault.attribute.RegistryKeyAttribute;
import iskallia.vault.attribute.StringAttribute;
import iskallia.vault.attribute.UUIDAttribute;
import iskallia.vault.attribute.VAttribute;
import iskallia.vault.entity.LegacyEntityScaler;
import iskallia.vault.entity.entity.AggressiveCowEntity;
import iskallia.vault.entity.entity.EternalEntity;
import iskallia.vault.init.ModAttributes;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModSounds;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.nbt.NonNullVListNBT;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.network.message.VaultModifierMessage;
import iskallia.vault.network.message.VaultOverlayMessage;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.util.ServerScheduler;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.DiscoveredRelicsData;
import iskallia.vault.world.data.PhoenixModifierSnapshotData;
import iskallia.vault.world.data.PhoenixSetSnapshotData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.SoulboundSnapshotData;
import iskallia.vault.world.data.VaultRaidData;
import iskallia.vault.world.raid.RaidProperties;
import iskallia.vault.world.vault.VaultUtils;
import iskallia.vault.world.vault.event.VaultEvent;
import iskallia.vault.world.vault.event.VaultListener;
import iskallia.vault.world.vault.gen.ArchitectEventGenerator;
import iskallia.vault.world.vault.gen.FinalLobbyGenerator;
import iskallia.vault.world.vault.gen.FragmentedVaultGenerator;
import iskallia.vault.world.vault.gen.RaidChallengeGenerator;
import iskallia.vault.world.vault.gen.VaultGenerator;
import iskallia.vault.world.vault.gen.VaultTroveGenerator;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutRegistry;
import iskallia.vault.world.vault.gen.piece.FinalVaultLobby;
import iskallia.vault.world.vault.gen.piece.VaultObelisk;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import iskallia.vault.world.vault.gen.piece.VaultPortal;
import iskallia.vault.world.vault.gen.piece.VaultRaidRoom;
import iskallia.vault.world.vault.gen.piece.VaultRoom;
import iskallia.vault.world.vault.gen.piece.VaultStart;
import iskallia.vault.world.vault.gen.piece.VaultTreasure;
import iskallia.vault.world.vault.gen.piece.VaultTunnel;
import iskallia.vault.world.vault.influence.MobAttributeInfluence;
import iskallia.vault.world.vault.influence.VaultInfluenceRegistry;
import iskallia.vault.world.vault.influence.VaultInfluences;
import iskallia.vault.world.vault.logic.VaultChestPity;
import iskallia.vault.world.vault.logic.VaultCowOverrides;
import iskallia.vault.world.vault.logic.VaultInfluenceHandler;
import iskallia.vault.world.vault.logic.VaultLobby;
import iskallia.vault.world.vault.logic.VaultLogic;
import iskallia.vault.world.vault.logic.VaultSandEvent;
import iskallia.vault.world.vault.logic.VaultSpawner;
import iskallia.vault.world.vault.logic.behaviour.VaultBehaviour;
import iskallia.vault.world.vault.logic.condition.VaultCondition;
import iskallia.vault.world.vault.logic.objective.CakeHuntObjective;
import iskallia.vault.world.vault.logic.objective.LegacyScavengerHuntObjective;
import iskallia.vault.world.vault.logic.objective.SummonAndKillAllBossesObjective;
import iskallia.vault.world.vault.logic.objective.SummonAndKillBossObjective;
import iskallia.vault.world.vault.logic.objective.TreasureHuntObjective;
import iskallia.vault.world.vault.logic.objective.TroveObjective;
import iskallia.vault.world.vault.logic.objective.VaultObjective;
import iskallia.vault.world.vault.logic.objective.ancient.AncientObjective;
import iskallia.vault.world.vault.logic.objective.architect.ArchitectObjective;
import iskallia.vault.world.vault.logic.objective.raid.ActiveRaid;
import iskallia.vault.world.vault.logic.objective.raid.RaidChallengeObjective;
import iskallia.vault.world.vault.logic.task.VaultTask;
import iskallia.vault.world.vault.modifier.VaultModifiers;
import iskallia.vault.world.vault.modifier.VaultModifiersGenerator;
import iskallia.vault.world.vault.modifier.modifier.MobAttributeModifier;
import iskallia.vault.world.vault.modifier.modifier.MobFrenzyModifier;
import iskallia.vault.world.vault.modifier.modifier.PlayerNoExitModifier;
import iskallia.vault.world.vault.modifier.modifier.deprecated.ScaleModifier;
import iskallia.vault.world.vault.modifier.spi.IVaultModifierStack;
import iskallia.vault.world.vault.modifier.spi.VaultModifier;
import iskallia.vault.world.vault.player.VaultMember;
import iskallia.vault.world.vault.player.VaultPlayer;
import iskallia.vault.world.vault.player.VaultPlayerType;
import iskallia.vault.world.vault.player.VaultRunner;
import iskallia.vault.world.vault.player.VaultSpectator;
import iskallia.vault.world.vault.time.VaultTimer;
import iskallia.vault.world.vault.time.extension.AccelerationExtension;
import iskallia.vault.world.vault.time.extension.FallbackExtension;
import iskallia.vault.world.vault.time.extension.FavourExtension;
import iskallia.vault.world.vault.time.extension.FruitExtension;
import iskallia.vault.world.vault.time.extension.ModifierExtension;
import iskallia.vault.world.vault.time.extension.RelicExtension;
import iskallia.vault.world.vault.time.extension.RoomGenerationExtension;
import iskallia.vault.world.vault.time.extension.SandExtension;
import iskallia.vault.world.vault.time.extension.TimeAltarExtension;
import iskallia.vault.world.vault.time.extension.TimeExtension;
import iskallia.vault.world.vault.time.extension.WinExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class VaultRaid
implements INBTSerializable<CompoundTag> {
    protected VaultTimer timer = new VaultTimer().start(Integer.MAX_VALUE);
    protected VaultGenerator generator;
    protected VaultTask initializer;
    protected VaultModifiers modifiers = new VaultModifiers();
    protected RaidProperties properties = new RaidProperties();
    protected VaultInfluences influence = new VaultInfluences();
    protected ActiveRaid activeRaid = null;
    protected final VListNBT<VaultObjective, CompoundTag> objectives = VListNBT.of(VaultObjective::fromNBT);
    protected final VListNBT<VaultEvent<?>, CompoundTag> events = NonNullVListNBT.of(VaultEvent::fromNBT);
    protected final VListNBT<VaultPlayer, CompoundTag> players = VListNBT.of(VaultPlayer::fromNBT);
    protected long creationTime = System.currentTimeMillis();
    public static final Supplier<FragmentedVaultGenerator> SINGLE_STAR;
    public static final Supplier<ArchitectEventGenerator> ARCHITECT_GENERATOR;
    public static final Supplier<VaultTroveGenerator> TROVE_GENERATOR;
    public static final Supplier<RaidChallengeGenerator> RAID_CHALLENGE_GENERATOR;
    public static final Supplier<FinalLobbyGenerator> FINAL_LOBBY;
    public static final VAttribute<ResourceKey<Level>, RegistryKeyAttribute<Level>> DIMENSION;
    public static final VAttribute<BoundingBox, BoundingBoxAttribute> BOUNDING_BOX;
    public static final VAttribute<BlockPos, BlockPosAttribute> START_POS;
    public static final VAttribute<Direction, EnumAttribute<Direction>> START_FACING;
    public static final VAttribute<CrystalData, CompoundAttribute<CrystalData>> CRYSTAL_DATA;
    public static final VAttribute<Boolean, BooleanAttribute> IS_RAFFLE;
    public static final VAttribute<Boolean, BooleanAttribute> COW_VAULT;
    public static final VAttribute<UUID, UUIDAttribute> HOST;
    public static final VAttribute<UUID, UUIDAttribute> IDENTIFIER;
    public static final VAttribute<UUID, UUIDAttribute> PARENT;
    public static final VAttribute<VaultLobby, CompoundAttribute<VaultLobby>> LOBBY;
    public static final VAttribute<Boolean, BooleanAttribute> FORCE_ACTIVE;
    public static final VAttribute<String, StringAttribute> PLAYER_BOSS_NAME;
    @Deprecated
    public static final VAttribute<Boolean, BooleanAttribute> CAN_EXIT;
    public static final VAttribute<VaultSpawner, CompoundAttribute<VaultSpawner>> SPAWNER;
    public static final VAttribute<VaultChestPity, CompoundAttribute<VaultChestPity>> CHEST_PITY;
    public static final VAttribute<VaultSandEvent, CompoundAttribute<VaultSandEvent>> SAND_EVENT;
    public static final VAttribute<Boolean, BooleanAttribute> SHOW_TIMER;
    public static final VAttribute<Boolean, BooleanAttribute> CAN_HEAL;
    public static final VAttribute<Integer, IntegerAttribute> LEVEL;
    public static final VaultCondition IS_FINISHED;
    public static final VaultCondition IS_RUNNER;
    public static final VaultCondition IS_SPECTATOR;
    public static final VaultCondition IS_OUTSIDE;
    public static final VaultCondition AFTER_GRACE_PERIOD;
    public static final VaultCondition IS_DEAD;
    public static final VaultCondition HAS_EXITED;
    public static final VaultCondition TIME_LEFT;
    public static final VaultCondition NO_TIME_LEFT;
    public static final VaultCondition OBJECTIVES_LEFT;
    public static final VaultCondition NO_OBJECTIVES_LEFT;
    public static final VaultCondition OBJECTIVES_LEFT_GLOBALLY;
    public static final VaultCondition NO_OBJECTIVES_LEFT_GLOBALLY;
    public static final VaultCondition RUNNERS_LEFT;
    public static final VaultCondition NO_RUNNERS_LEFT;
    public static final VaultCondition ACTIVE_RUNNERS_LEFT;
    public static final VaultCondition NO_ACTIVE_RUNNERS_LEFT;
    public static final VaultTask CHECK_BAIL;
    public static final VaultTask CHECK_BAIL_COOP;
    public static final VaultTask CHECK_BAIL_FINAL;
    public static final VaultTask TICK_SAND_EVENT;
    public static final VaultTask TICK_CHEST_PITY;
    public static final VaultTask TICK_SPAWNER;
    public static final VaultTask TICK_LOBBY;
    public static final VaultTask TICK_INFLUENCES;
    public static final VaultTask TP_TO_START;
    public static final VaultTask INIT_LEVEL;
    public static final VaultTask INIT_LEVEL_COOP;
    public static final VaultTask INIT_LEVEL_FINAL;
    public static final VaultTask INIT_RELIC_TIME;
    @Deprecated
    public static final VaultTask INIT_FAVOUR_TIME;
    public static final VaultTask INIT_SANDS_EVENT;
    public static final VaultTask INIT_COW_VAULT;
    public static final VaultTask INIT_GLOBAL_MODIFIERS;
    public static final VaultTask RUNNER_TO_SPECTATOR;
    public static final VaultTask HIDE_OVERLAY;
    public static final VaultTask PAUSE_IN_ARENA;
    public static final VaultTask LEVEL_UP_GEAR;
    public static final VaultTask REMOVE_SCAVENGER_ITEMS;
    public static final VaultTask SAVE_SOULBOUND_GEAR;
    public static final VaultTask REMOVE_INVENTORY_RESTORE_SNAPSHOTS;
    public static final VaultTask FINAL_VICTORY_SCENE;
    public static final VaultTask EXIT_SAFELY;
    public static final VaultTask EXIT_DEATH;
    public static final VaultTask EXIT_DEATH_ALL;
    public static final VaultTask EXIT_DEATH_ALL_NO_SAVE;
    public static final VaultTask VICTORY_SCENE;
    public static final VaultTask ENTER_DISPLAY;
    public static final Supplier<SummonAndKillBossObjective> SUMMON_AND_KILL_BOSS;
    public static final Supplier<LegacyScavengerHuntObjective> SCAVENGER_HUNT;
    public static final Supplier<ArchitectObjective> ARCHITECT_EVENT;
    public static final Supplier<TroveObjective> VAULT_TROVE;
    public static final Supplier<AncientObjective> ANCIENTS;
    public static final Supplier<RaidChallengeObjective> RAID_CHALLENGE;
    public static final Supplier<CakeHuntObjective> CAKE_HUNT;
    public static final Supplier<SummonAndKillAllBossesObjective> SUMMON_AND_KILL_ALL_BOSSES;
    public static final Supplier<TreasureHuntObjective> TREASURE_HUNT;
    @Deprecated
    public static final VaultEvent<Event> TRIGGER_BOSS_SUMMON;
    public static final VaultEvent<LivingEvent.LivingUpdateEvent> SCALE_MOB;
    public static final VaultEvent<EntityJoinWorldEvent> SCALE_MOB_JOIN;
    public static final VaultEvent<LivingSpawnEvent.CheckSpawn> BLOCK_NATURAL_SPAWNING;
    public static final VaultEvent<EntityJoinWorldEvent> PREVENT_ITEM_PICKUP;
    public static final VaultEvent<EntityJoinWorldEvent> REPLACE_WITH_COW;
    public static final VaultEvent<EntityJoinWorldEvent> APPLY_SCALE_MODIFIER;
    public static final VaultEvent<EntityJoinWorldEvent> APPLY_FRENZY_MODIFIERS;
    public static final VaultEvent<EntityJoinWorldEvent> APPLY_MOB_ATTRIBUTE_MODIFIERS;
    public static final VaultEvent<EntityJoinWorldEvent> APPLY_INFLUENCE_MODIFIERS;

    public VaultRaid() {
        VaultListener.listen(this);
    }

    public VaultRaid(VaultGenerator generator, VaultTask initializer, RaidProperties properties, List<VaultEvent<?>> events, Iterable<VaultPlayer> players) {
        this.generator = generator;
        this.initializer = initializer;
        this.properties = properties;
        events.forEach(this.events::add);
        players.forEach(this.players::add);
        VaultListener.listen(this);
    }

    public VaultTimer getTimer() {
        return this.timer;
    }

    public VaultGenerator getGenerator() {
        return this.generator;
    }

    public VaultTask getInitializer() {
        return this.initializer;
    }

    public VaultInfluences getInfluences() {
        return this.influence;
    }

    public VaultModifiers getModifiers() {
        return this.modifiers;
    }

    public <T extends VaultModifier<?>> List<VaultModifiers.ActiveModifierStack<T>> getActiveModifiersFor(PlayerFilter filter, Class<T> modifierClass) {
        List<VaultModifiers.ActiveModifierStack<T>> modifierStacks = this.getModifiers().stream(modifierClass).toList();
        for (VaultPlayer player : this.getPlayers()) {
            if (player instanceof VaultRunner || !filter.test(player.getPlayerId())) continue;
            player.getModifiers().stream(modifierClass).forEach(modifierStacks::add);
        }
        return modifierStacks;
    }

    public <T extends VaultModifier<?>> boolean hasActiveModifierFor(PlayerFilter filter, Class<T> modifierClass) {
        return !this.getActiveModifiersFor(filter, modifierClass).isEmpty();
    }

    public <T extends VaultModifier<?>> boolean hasActiveModifierFor(PlayerFilter playerFilter, Class<T> modifierClass, Predicate<T> modifierFilter) {
        return this.getActiveModifiersFor(playerFilter, modifierClass).stream().anyMatch(vaultModifierStack -> modifierFilter.test(vaultModifierStack.getModifier()));
    }

    public <T extends VaultModifier<?>> void withActiveModifiersFor(PlayerFilter filter, Class<T> modifierClass, BiConsumer<T, Integer> consumer) {
        for (IVaultModifierStack iVaultModifierStack : this.getActiveModifiersFor(filter, modifierClass)) {
            consumer.accept(iVaultModifierStack.getModifier(), iVaultModifierStack.getSize());
        }
    }

    public boolean canExit(VaultPlayer player) {
        return !this.hasActiveModifierFor(PlayerFilter.of(player), PlayerNoExitModifier.class);
    }

    public boolean triggerRaid(ServerLevel world, BlockPos controller) {
        if (this.activeRaid != null) {
            return false;
        }
        this.activeRaid = ActiveRaid.create(this, world, controller);
        return true;
    }

    @Nullable
    public ActiveRaid getActiveRaid() {
        return this.activeRaid;
    }

    public RaidProperties getProperties() {
        return this.properties;
    }

    public List<VaultObjective> getActiveObjectives() {
        return this.getAllObjectives().stream().filter(objective -> !objective.isCompleted()).collect(Collectors.toList());
    }

    public List<VaultObjective> getAllObjectives() {
        return this.objectives;
    }

    public <T extends VaultObjective> Optional<T> getActiveObjective(Class<T> objectiveClass) {
        return this.getAllObjectives().stream().filter(objective -> !objective.isCompleted()).filter(objective -> objectiveClass.isAssignableFrom(objective.getClass())).findFirst().map(vaultObjective -> vaultObjective);
    }

    public boolean hasActiveObjective(VaultPlayer player, Class<? extends VaultObjective> objectiveClass) {
        return this.getActiveObjective(objectiveClass).isPresent() || player.getActiveObjective(objectiveClass).isPresent();
    }

    public List<VaultEvent<?>> getEvents() {
        return this.events;
    }

    public List<VaultPlayer> getPlayers() {
        return this.players;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public Optional<VaultPlayer> getPlayer(Player player) {
        return this.getPlayer(player.m_142081_());
    }

    public Optional<VaultPlayer> getPlayer(UUID playerId) {
        return this.players.stream().filter(player -> player.getPlayerId().equals(playerId)).findFirst();
    }

    public void tick(ServerLevel world) {
        this.getGenerator().tick(world, this);
        if (this.isFinished()) {
            return;
        }
        MinecraftServer srv = world.m_142572_();
        if (this.getActiveObjectives().stream().noneMatch(objective -> objective.shouldPauseTimer(srv, this))) {
            this.getTimer().tick();
        }
        this.getModifiers().tick(this, world, PlayerFilter.any());
        new ArrayList<VaultPlayer>(this.players).forEach(player -> {
            player.tick(this, world);
            player.sendIfPresent(world.m_142572_(), new VaultModifierMessage(this, (VaultPlayer)player));
        });
        this.getAllObjectives().stream().filter(objective -> objective.isCompleted() && objective.getCompletionTime() < 0).peek(objective -> objective.setCompletionTime(this.getTimer().getRunTime())).forEach(objective -> objective.complete(this, world));
        this.getActiveObjectives().forEach(objective -> objective.tick(this, PlayerFilter.any(), world));
        if (this.activeRaid != null) {
            this.activeRaid.tick(this, world);
            if (this.activeRaid.isFinished()) {
                this.activeRaid.finish(this, world);
                this.activeRaid = null;
            }
        }
    }

    public boolean isFinished() {
        return this.getProperties().getBaseOrDefault(FORCE_ACTIVE, false) == false && (this.players.isEmpty() || this.players.stream().allMatch(VaultPlayer::hasExited));
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Timer", (Tag)this.timer.serializeNBT());
        nbt.m_128365_("Generator", (Tag)this.generator.serializeNBT());
        nbt.m_128365_("Modifiers", (Tag)this.modifiers.serializeNBT());
        nbt.m_128365_("influence", (Tag)this.influence.serializeNBT());
        nbt.m_128365_("Properties", (Tag)this.properties.serializeNBT());
        nbt.m_128365_("Objectives", (Tag)this.objectives.serializeNBT());
        nbt.m_128365_("Events", (Tag)this.events.serializeNBT());
        nbt.m_128365_("Players", (Tag)this.players.serializeNBT());
        nbt.m_128356_("CreationTime", this.getCreationTime());
        NBTHelper.writeOptional(nbt, "activeRaid", this.activeRaid, (tag, raid) -> raid.serialize((CompoundTag)tag));
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.timer.deserializeNBT(nbt.m_128469_("Timer"));
        this.generator = VaultGenerator.fromNBT(nbt.m_128469_("Generator"));
        this.modifiers.deserializeNBT(nbt.m_128469_("Modifiers"));
        this.influence.deserializeNBT(nbt.m_128469_("influence"));
        this.properties.deserializeNBT(nbt.m_128469_("Properties"));
        this.objectives.deserializeNBT(nbt.m_128437_("Objectives", 10));
        this.events.deserializeNBT(nbt.m_128437_("Events", 10));
        this.players.deserializeNBT(nbt.m_128437_("Players", 10));
        this.creationTime = nbt.m_128454_("CreationTime");
        this.activeRaid = NBTHelper.readOptional(nbt, "activeRaid", ActiveRaid::deserializeNBT);
    }

    public static VaultRaid classic(VaultGenerator generator, VaultTask initializer, RaidProperties properties, VaultObjective objective, List<VaultEvent<?>> events, Map<VaultPlayerType, Set<ServerPlayer>> playersMap) {
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        VaultRaid vault = new VaultRaid(generator, initializer, properties, events, playersMap.entrySet().stream().flatMap(entry -> {
            VaultPlayerType type = (VaultPlayerType)((Object)((Object)entry.getKey()));
            Set players = (Set)entry.getValue();
            if (type == VaultPlayerType.RUNNER) {
                return players.stream().map(player -> {
                    VaultRunner runner = new VaultRunner(player.m_142081_());
                    runner.getBehaviours().add(new VaultBehaviour(IS_RUNNER.and(IS_DEAD.or(NO_TIME_LEFT.and(OBJECTIVES_LEFT))), RUNNER_TO_SPECTATOR));
                    runner.getBehaviours().add(new VaultBehaviour(NO_OBJECTIVES_LEFT_GLOBALLY.and(NO_TIME_LEFT.or(NO_RUNNERS_LEFT)), REMOVE_SCAVENGER_ITEMS.then(REMOVE_INVENTORY_RESTORE_SNAPSHOTS).then(EXIT_SAFELY)));
                    runner.getBehaviours().add(new VaultBehaviour(OBJECTIVES_LEFT_GLOBALLY.and(NO_RUNNERS_LEFT), REMOVE_SCAVENGER_ITEMS.then(SAVE_SOULBOUND_GEAR.then(EXIT_DEATH))));
                    runner.getBehaviours().add(new VaultBehaviour(IS_FINISHED.negate(), TICK_SPAWNER.then(TICK_CHEST_PITY)));
                    runner.getBehaviours().add(new VaultBehaviour(AFTER_GRACE_PERIOD.and(IS_FINISHED.negate()), TICK_INFLUENCES));
                    runner.getBehaviours().add(new VaultBehaviour(IS_RUNNER, PAUSE_IN_ARENA.then(CHECK_BAIL)));
                    runner.getProperties().create(SPAWNER, new VaultSpawner());
                    runner.getProperties().create(CHEST_PITY, new VaultChestPity());
                    runner.getTimer().start(objective.getVaultTimerStart(ModConfigs.VAULT_GENERAL.getTickCounter()));
                    return runner;
                });
            }
            if (type == VaultPlayerType.SPECTATOR) {
                // empty if block
            }
            return Stream.empty();
        }).collect(Collectors.toList()));
        vault.getAllObjectives().add(objective.thenComplete(LEVEL_UP_GEAR).thenComplete(VICTORY_SCENE));
        vault.getAllObjectives().forEach(obj -> obj.initialize(srv, vault));
        return vault;
    }

    public static VaultRaid coop(VaultGenerator generator, VaultTask initializer, RaidProperties properties, VaultObjective objective, List<VaultEvent<?>> events, Map<VaultPlayerType, Set<ServerPlayer>> playersMap) {
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        VaultRaid vault = new VaultRaid(generator, initializer, properties, events, playersMap.entrySet().stream().flatMap(entry -> {
            VaultPlayerType type = (VaultPlayerType)((Object)((Object)entry.getKey()));
            Set players = (Set)entry.getValue();
            if (type == VaultPlayerType.RUNNER) {
                return players.stream().map(player -> {
                    VaultRunner runner = new VaultRunner(player.m_142081_());
                    runner.getBehaviours().add(new VaultBehaviour(NO_OBJECTIVES_LEFT_GLOBALLY.and(NO_TIME_LEFT), REMOVE_SCAVENGER_ITEMS.then(REMOVE_INVENTORY_RESTORE_SNAPSHOTS).then(EXIT_SAFELY)));
                    runner.getBehaviours().add(new VaultBehaviour(IS_RUNNER.and(IS_DEAD.or(NO_TIME_LEFT)), EXIT_DEATH_ALL));
                    runner.getBehaviours().add(new VaultBehaviour(IS_FINISHED.negate(), TICK_SPAWNER.then(TICK_CHEST_PITY)));
                    runner.getBehaviours().add(new VaultBehaviour(AFTER_GRACE_PERIOD.and(IS_FINISHED.negate()), TICK_INFLUENCES));
                    runner.getBehaviours().add(new VaultBehaviour(IS_RUNNER, PAUSE_IN_ARENA.then(CHECK_BAIL_COOP)));
                    runner.getBehaviours().add(new VaultBehaviour(NO_ACTIVE_RUNNERS_LEFT, REMOVE_SCAVENGER_ITEMS.then(REMOVE_INVENTORY_RESTORE_SNAPSHOTS).then(EXIT_SAFELY)));
                    runner.getProperties().create(SPAWNER, new VaultSpawner());
                    runner.getProperties().create(CHEST_PITY, new VaultChestPity());
                    runner.getTimer().start(objective.getVaultTimerStart(ModConfigs.VAULT_GENERAL.getTickCounter()));
                    return runner;
                });
            }
            if (type == VaultPlayerType.SPECTATOR) {
                // empty if block
            }
            return Stream.empty();
        }).collect(Collectors.toList()));
        vault.getAllObjectives().add(objective.thenComplete(LEVEL_UP_GEAR).thenComplete(VICTORY_SCENE));
        vault.getAllObjectives().forEach(obj -> obj.initialize(srv, vault));
        return vault;
    }

    public static VaultRaid lobby(VaultGenerator generator, VaultTask initializer, RaidProperties properties, VaultObjective objective, List<VaultEvent<?>> events, Map<VaultPlayerType, Set<ServerPlayer>> playersMap) {
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        VaultRaid vault = new VaultRaid(generator, initializer, properties, events, playersMap.entrySet().stream().flatMap(entry -> {
            Set players = (Set)entry.getValue();
            return players.stream().map(player -> {
                VaultMember member = new VaultMember(player.m_142081_());
                member.getProperties().create(CAN_HEAL, true);
                member.getBehaviours().add(new VaultBehaviour(IS_OUTSIDE, TP_TO_START));
                member.getBehaviours().add(new VaultBehaviour(IS_DEAD.negate(), TICK_LOBBY));
                return member;
            });
        }).collect(Collectors.toList()));
        vault.getProperties().create(LOBBY, new VaultLobby());
        vault.getProperties().create(FORCE_ACTIVE, true);
        vault.getAllObjectives().forEach(obj -> obj.initialize(srv, vault));
        return vault;
    }

    public static void init() {
    }

    public static Builder builder(VaultLogic logic, int vaultLevel, @Nullable VaultObjective objective) {
        return new Builder(logic, vaultLevel, objective);
    }

    private static /* synthetic */ void lambda$static$124(EntityJoinWorldEvent event, LivingEntity replaced) {
        event.getWorld().m_7967_((Entity)replaced);
    }

    static {
        TimeExtension.REGISTRY.put(FruitExtension.ID, FruitExtension::new);
        TimeExtension.REGISTRY.put(RelicExtension.ID, RelicExtension::new);
        TimeExtension.REGISTRY.put(FallbackExtension.ID, FallbackExtension::new);
        TimeExtension.REGISTRY.put(WinExtension.ID, WinExtension::new);
        TimeExtension.REGISTRY.put(ModifierExtension.ID, ModifierExtension::new);
        TimeExtension.REGISTRY.put(TimeAltarExtension.ID, TimeAltarExtension::new);
        TimeExtension.REGISTRY.put(AccelerationExtension.ID, AccelerationExtension::new);
        TimeExtension.REGISTRY.put(RoomGenerationExtension.ID, RoomGenerationExtension::new);
        TimeExtension.REGISTRY.put(FavourExtension.ID, FavourExtension::new);
        TimeExtension.REGISTRY.put(SandExtension.ID, SandExtension::new);
        VaultPlayer.REGISTRY.put(VaultRunner.ID, VaultRunner::new);
        VaultPlayer.REGISTRY.put(VaultSpectator.ID, VaultSpectator::new);
        VaultPlayer.REGISTRY.put(VaultMember.ID, VaultMember::new);
        VaultPiece.REGISTRY.put(VaultObelisk.ID, VaultObelisk::new);
        VaultPiece.REGISTRY.put(VaultRoom.ID, VaultRoom::new);
        VaultPiece.REGISTRY.put(VaultStart.ID, VaultStart::new);
        VaultPiece.REGISTRY.put(VaultTreasure.ID, VaultTreasure::new);
        VaultPiece.REGISTRY.put(VaultTunnel.ID, VaultTunnel::new);
        VaultPiece.REGISTRY.put(VaultRaidRoom.ID, VaultRaidRoom::new);
        VaultPiece.REGISTRY.put(FinalVaultLobby.ID, FinalVaultLobby::new);
        VaultPiece.REGISTRY.put(VaultPortal.ID, VaultPortal::new);
        VaultRoomLayoutRegistry.init();
        VaultInfluenceRegistry.init();
        SINGLE_STAR = VaultGenerator.register(() -> new FragmentedVaultGenerator(VaultMod.id("single_star")));
        ARCHITECT_GENERATOR = VaultGenerator.register(() -> new ArchitectEventGenerator(VaultMod.id("architect")));
        TROVE_GENERATOR = VaultGenerator.register(() -> new VaultTroveGenerator(VaultMod.id("vault_trove")));
        RAID_CHALLENGE_GENERATOR = VaultGenerator.register(() -> new RaidChallengeGenerator(VaultMod.id("raid_challenge")));
        FINAL_LOBBY = VaultGenerator.register(() -> new FinalLobbyGenerator(VaultMod.id("final_lobby")));
        DIMENSION = new VAttribute(VaultMod.id("dimension"), RegistryKeyAttribute::new);
        BOUNDING_BOX = new VAttribute(VaultMod.id("bounding_box"), BoundingBoxAttribute::new);
        START_POS = new VAttribute(VaultMod.id("start_pos"), BlockPosAttribute::new);
        START_FACING = new VAttribute(VaultMod.id("start_facing"), () -> new EnumAttribute<Direction>(Direction.class));
        CRYSTAL_DATA = new VAttribute(VaultMod.id("crystal_data"), () -> CompoundAttribute.of(CrystalData::new));
        IS_RAFFLE = new VAttribute(VaultMod.id("is_raffle"), BooleanAttribute::new);
        COW_VAULT = new VAttribute(VaultMod.id("cow"), BooleanAttribute::new);
        HOST = new VAttribute(VaultMod.id("host"), UUIDAttribute::new);
        IDENTIFIER = new VAttribute(VaultMod.id("identifier"), UUIDAttribute::new);
        PARENT = new VAttribute(VaultMod.id("parent"), UUIDAttribute::new);
        LOBBY = new VAttribute(VaultMod.id("lobby"), () -> CompoundAttribute.of(VaultLobby::new));
        FORCE_ACTIVE = new VAttribute(VaultMod.id("force_active"), BooleanAttribute::new);
        PLAYER_BOSS_NAME = new VAttribute(VaultMod.id("player_boss_name"), StringAttribute::new);
        CAN_EXIT = new VAttribute(VaultMod.id("can_exit"), BooleanAttribute::new);
        SPAWNER = new VAttribute(VaultMod.id("spawner"), () -> CompoundAttribute.of(VaultSpawner::new));
        CHEST_PITY = new VAttribute(VaultMod.id("chest_pity"), () -> CompoundAttribute.of(VaultChestPity::new));
        SAND_EVENT = new VAttribute(VaultMod.id("sand_event"), () -> CompoundAttribute.of(VaultSandEvent::new));
        SHOW_TIMER = new VAttribute(VaultMod.id("show_timer"), BooleanAttribute::new);
        CAN_HEAL = new VAttribute(VaultMod.id("can_heal"), BooleanAttribute::new);
        LEVEL = new VAttribute(VaultMod.id("level"), IntegerAttribute::new);
        IS_FINISHED = VaultCondition.register(VaultMod.id("is_finished"), (vault, player, world) -> vault.isFinished());
        IS_RUNNER = VaultCondition.register(VaultMod.id("is_runner"), (vault, player, world) -> player instanceof VaultRunner);
        IS_SPECTATOR = VaultCondition.register(VaultMod.id("is_spectator"), (vault, player, world) -> player instanceof VaultSpectator);
        IS_OUTSIDE = VaultCondition.register(VaultMod.id("is_outside"), (vault, player, world) -> {
            boolean[] outside = new boolean[1];
            player.runIfPresent(world.m_142572_(), sPlayer -> {
                outside[0] = !VaultUtils.inVault(vault, (Entity)sPlayer);
            });
            return outside[0];
        });
        AFTER_GRACE_PERIOD = VaultCondition.register(VaultMod.id("after_grace_period"), (vault, player, world) -> vault.getTimer().getRunTime() > 300);
        IS_DEAD = VaultCondition.register(VaultMod.id("is_dead"), (vault, player, world) -> {
            MutableBoolean dead = new MutableBoolean(false);
            player.runIfPresent(world.m_142572_(), playerEntity -> dead.setValue(playerEntity.m_21224_()));
            return dead.booleanValue();
        });
        HAS_EXITED = VaultCondition.register(VaultMod.id("has_exited"), (vault, player, world) -> player.hasExited());
        TIME_LEFT = VaultCondition.register(VaultMod.id("time_left"), (vault, player, world) -> player.getTimer().getTimeLeft() > 0);
        NO_TIME_LEFT = VaultCondition.register(VaultMod.id("no_time_left"), TIME_LEFT.negate());
        OBJECTIVES_LEFT = VaultCondition.register(VaultMod.id("objectives_left"), (vault, player, world) -> player.getObjectives().size() > 0 || vault.getActiveObjectives().size() > 0);
        NO_OBJECTIVES_LEFT = VaultCondition.register(VaultMod.id("no_objectives_left"), OBJECTIVES_LEFT.negate());
        OBJECTIVES_LEFT_GLOBALLY = VaultCondition.register(VaultMod.id("objectives_left_globally"), (vault, player, world) -> vault.players.stream().anyMatch(player1 -> OBJECTIVES_LEFT.test(vault, (VaultPlayer)player1, world)));
        NO_OBJECTIVES_LEFT_GLOBALLY = VaultCondition.register(VaultMod.id("no_objectives_left_globally"), OBJECTIVES_LEFT_GLOBALLY.negate());
        RUNNERS_LEFT = VaultCondition.register(VaultMod.id("runners_left"), (vault, player, world) -> vault.players.stream().anyMatch(player1 -> player1 instanceof VaultRunner));
        NO_RUNNERS_LEFT = VaultCondition.register(VaultMod.id("no_runners_left"), RUNNERS_LEFT.negate());
        ACTIVE_RUNNERS_LEFT = VaultCondition.register(VaultMod.id("active_runners_left"), (vault, player, world) -> vault.players.stream().anyMatch(player1 -> player1 instanceof VaultRunner && !player1.hasExited()));
        NO_ACTIVE_RUNNERS_LEFT = VaultCondition.register(VaultMod.id("no_active_runners_left"), ACTIVE_RUNNERS_LEFT.negate());
        CHECK_BAIL = VaultTask.register(VaultMod.id("check_bail"), (vault, player, world) -> {
            if (vault.getTimer().getRunTime() < 200) {
                return;
            }
            player.runIfPresent(world.m_142572_(), sPlayer -> {
                if (vault.getGenerator().getPiecesAt(sPlayer.m_142538_(), VaultStart.class).isEmpty()) {
                    return;
                }
                AABB box = sPlayer.m_142469_();
                BlockPos min = new BlockPos(box.f_82288_ + 0.001, box.f_82289_ + 0.001, box.f_82290_ + 0.001);
                BlockPos max = new BlockPos(box.f_82291_ - 0.001, box.f_82292_ - 0.001, box.f_82293_ - 0.001);
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                if (!world.m_46832_(min, max) || sPlayer.m_20092_()) {
                    return;
                }
                for (int xx = min.m_123341_(); xx <= max.m_123341_(); ++xx) {
                    for (int yy = min.m_123342_(); yy <= max.m_123342_(); ++yy) {
                        for (int zz = min.m_123343_(); zz <= max.m_123343_(); ++zz) {
                            BlockState state = world.m_8055_((BlockPos)pos.m_122178_(xx, yy, zz));
                            if (state.m_60734_() != ModBlocks.VAULT_PORTAL) continue;
                            if (sPlayer.m_20092_()) {
                                sPlayer.m_20091_();
                                return;
                            }
                            if (!vault.canExit(player)) {
                                TextComponent text = new TextComponent("You cannot exit this Vault!");
                                text.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
                                sPlayer.m_5661_((Component)text, true);
                                return;
                            }
                            vault.getAllObjectives().forEach(objective -> objective.notifyBail(vault, player, world));
                            sPlayer.m_20091_();
                            REMOVE_SCAVENGER_ITEMS.then(REMOVE_INVENTORY_RESTORE_SNAPSHOTS).then(EXIT_SAFELY).execute(vault, player, world);
                            MutableComponent playerName = sPlayer.m_5446_().m_6881_();
                            playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
                            TextComponent suffix = new TextComponent(" survived.");
                            world.m_142572_().m_6846_().m_11264_((Component)new TextComponent("").m_7220_((Component)playerName).m_7220_((Component)suffix), ChatType.CHAT, player.getPlayerId());
                        }
                    }
                }
            });
        });
        CHECK_BAIL_COOP = VaultTask.register(VaultMod.id("check_bail_coop"), (vault, player, world) -> {
            if (vault.getTimer().getRunTime() < 200) {
                return;
            }
            player.runIfPresent(world.m_142572_(), sPlayer -> {
                if (vault.getGenerator().getPiecesAt(sPlayer.m_142538_(), VaultStart.class).isEmpty()) {
                    return;
                }
                AABB box = sPlayer.m_142469_();
                BlockPos min = new BlockPos(box.f_82288_ + 0.001, box.f_82289_ + 0.001, box.f_82290_ + 0.001);
                BlockPos max = new BlockPos(box.f_82291_ - 0.001, box.f_82292_ - 0.001, box.f_82293_ - 0.001);
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                if (!world.m_46832_(min, max)) {
                    return;
                }
                for (int i = min.m_123341_(); i <= max.m_123341_(); ++i) {
                    for (int j = min.m_123342_(); j <= max.m_123342_(); ++j) {
                        for (int k = min.m_123343_(); k <= max.m_123343_(); ++k) {
                            BlockState state = world.m_8055_((BlockPos)pos.m_122178_(i, j, k));
                            if (state.m_60734_() != ModBlocks.VAULT_PORTAL) continue;
                            if (sPlayer.m_20092_()) {
                                sPlayer.m_20091_();
                                return;
                            }
                            if (!vault.canExit(player)) {
                                TextComponent text = new TextComponent("You cannot exit this Vault!");
                                text.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
                                sPlayer.m_5661_((Component)text, true);
                                return;
                            }
                            vault.getAllObjectives().forEach(objective -> objective.notifyBail(vault, player, world));
                            sPlayer.m_20091_();
                            RUNNER_TO_SPECTATOR.execute(vault, player, world);
                            HIDE_OVERLAY.execute(vault, player, world);
                            MutableComponent playerName = sPlayer.m_5446_().m_6881_();
                            playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
                            TextComponent suffix = new TextComponent(" survived.");
                            world.m_142572_().m_6846_().m_11264_((Component)new TextComponent("").m_7220_((Component)playerName).m_7220_((Component)suffix), ChatType.CHAT, player.getPlayerId());
                        }
                    }
                }
            });
        });
        CHECK_BAIL_FINAL = VaultTask.register(VaultMod.id("check_bail_final"), (vault, player, world) -> player.runIfPresent(world.m_142572_(), sPlayer -> {
            if (vault.getGenerator().getPiecesAt(sPlayer.m_142538_(), VaultStart.class).isEmpty()) {
                return;
            }
            AABB box = sPlayer.m_142469_();
            BlockPos min = new BlockPos(box.f_82288_ + 0.001, box.f_82289_ + 0.001, box.f_82290_ + 0.001);
            BlockPos max = new BlockPos(box.f_82291_ - 0.001, box.f_82292_ - 0.001, box.f_82293_ - 0.001);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            if (!world.m_46832_(min, max)) {
                return;
            }
            for (int i = min.m_123341_(); i <= max.m_123341_(); ++i) {
                for (int j = min.m_123342_(); j <= max.m_123342_(); ++j) {
                    for (int k = min.m_123343_(); k <= max.m_123343_(); ++k) {
                        BlockState state = world.m_8055_((BlockPos)pos.m_122178_(i, j, k));
                        if (state.m_60734_() != ModBlocks.VAULT_PORTAL) continue;
                        if (sPlayer.m_20092_()) {
                            sPlayer.m_20091_();
                            return;
                        }
                        if (!vault.canExit(player)) {
                            TextComponent text = new TextComponent("You cannot exit this Vault!");
                            text.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
                            sPlayer.m_5661_((Component)text, true);
                            return;
                        }
                        vault.getAllObjectives().forEach(objective -> objective.notifyBail(vault, player, world));
                        sPlayer.m_20091_();
                        new ArrayList<VaultPlayer>(vault.getPlayers()).forEach(vaultPlayer -> {
                            if (vaultPlayer instanceof VaultRunner) {
                                RUNNER_TO_SPECTATOR.execute(vault, (VaultPlayer)vaultPlayer, world);
                            }
                        });
                        vault.getProperties().create(FORCE_ACTIVE, false);
                        HIDE_OVERLAY.execute(vault, player, world);
                        MutableComponent playerName = sPlayer.m_5446_().m_6881_();
                        playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
                        TextComponent suffix = new TextComponent(" survived.");
                        world.m_142572_().m_6846_().m_11264_((Component)new TextComponent("").m_7220_((Component)playerName).m_7220_((Component)suffix), ChatType.CHAT, player.getPlayerId());
                    }
                }
            }
        }));
        TICK_SAND_EVENT = VaultTask.register(VaultMod.id("tick_sand_event"), (vault, player, world) -> vault.getProperties().getBase(SAND_EVENT).ifPresent(event -> event.execute(vault, player, world)));
        TICK_CHEST_PITY = VaultTask.register(VaultMod.id("tick_chest_pity"), (vault, player, world) -> player.getProperties().getBase(CHEST_PITY).ifPresent(event -> event.execute(vault, player, world)));
        TICK_SPAWNER = VaultTask.register(VaultMod.id("tick_spawner"), (vault, player, world) -> {
            if (vault.getActiveObjectives().isEmpty()) {
                return;
            }
            player.getProperties().get(SPAWNER).ifPresent(attribute -> {
                VaultSpawner spawner = (VaultSpawner)attribute.getBaseValue();
                if (player.getTimer().getRunTime() >= 300) {
                    int level = player.getProperties().getValue(LEVEL);
                    VaultSpawner.Config c = null;
                    spawner.configure(config -> config.withStartMaxMobs(c.getStartMaxMobs()).withMinDistance(c.getMinDistance()).withMaxDistance(c.getMaxDistance()).withDespawnDistance(c.getDespawnDistance()));
                }
                spawner.execute(vault, player, world);
                attribute.updateNBT();
            });
        });
        TICK_LOBBY = VaultTask.register(VaultMod.id("tick_lobby"), (vault, player, world) -> vault.getProperties().get(LOBBY).ifPresent(attribute -> {
            VaultLobby lobby = (VaultLobby)attribute.getBaseValue();
            lobby.execute(vault, player, world);
            attribute.updateNBT();
        }));
        TICK_INFLUENCES = VaultTask.register(VaultMod.id("tick_influences"), (vault, player, world) -> {
            if (!vault.getInfluences().isInitialized()) {
                VaultInfluenceHandler.initializeInfluences(vault, world);
                vault.getInfluences().setInitialized();
            }
            vault.getInfluences().tick(vault, player, world);
        });
        TP_TO_START = VaultTask.register(VaultMod.id("tp_to_start"), (vault, player, world) -> player.runIfPresent(world.m_142572_(), playerEntity -> {
            BlockPos start = vault.getProperties().getBaseOrDefault(START_POS, (BlockPos)null);
            Direction facing = vault.getProperties().getBaseOrDefault(START_FACING, (Direction)null);
            BoundingBox box = vault.getProperties().getValue(BOUNDING_BOX);
            if (start == null) {
                VaultMod.LOGGER.warn("No vault start was found.");
                playerEntity.m_8999_(world, (double)((float)box.m_162395_() + (float)box.m_71056_() / 2.0f), 256.0, (double)((float)box.m_162398_() + (float)box.m_71058_() / 2.0f), playerEntity.m_146908_(), playerEntity.m_146909_());
            } else {
                playerEntity.m_8999_(world, (double)start.m_123341_() + 0.5, (double)start.m_123342_() + 0.2, (double)start.m_123343_() + 0.5, facing == null ? world.m_5822_().nextFloat() * 360.0f : facing.m_122427_().m_122435_(), 0.0f);
            }
            playerEntity.m_20091_();
            playerEntity.m_6853_(true);
        }));
        INIT_LEVEL = VaultTask.register(VaultMod.id("init_level"), (vault, player, world) -> {
            int currentLevel = vault.getProperties().getBaseOrDefault(LEVEL, 0);
            int playerLevel = PlayerVaultStatsData.get(world).getVaultStats(player.getPlayerId()).getVaultLevel();
            vault.getProperties().create(LEVEL, Math.max(currentLevel, playerLevel));
            player.getProperties().create(LEVEL, playerLevel);
        });
        INIT_LEVEL_COOP = VaultTask.register(VaultMod.id("init_level_coop"), (vault, player, world) -> vault.getProperties().getBase(HOST).ifPresent(hostId -> {
            int vaultLevel = PlayerVaultStatsData.get(world).getVaultStats((UUID)hostId).getVaultLevel();
            vault.getProperties().create(LEVEL, vaultLevel += Math.max(vault.getPlayers().size() - 1, 0) * 2);
            player.getProperties().create(LEVEL, vaultLevel);
        }));
        INIT_LEVEL_FINAL = VaultTask.register(VaultMod.id("init_level_final"), (vault, player, world) -> {
            vault.getProperties().create(LEVEL, 1000);
            player.getProperties().create(LEVEL, 1000);
        });
        INIT_RELIC_TIME = VaultTask.register(VaultMod.id("init_relic_extension"), (vault, player, world) -> {
            Set<Object> sets = new HashSet();
            for (VaultPlayer player2 : vault.getPlayers()) {
                Set newSets = DiscoveredRelicsData.get(world).getDiscoveredRelics(player2.getPlayerId()).stream().map(ResourceLocation::toString).collect(Collectors.toSet());
                if (newSets.size() <= sets.size()) continue;
                sets = newSets;
            }
            sets.stream().map(ResourceLocation::new).forEach(set -> {});
        });
        INIT_FAVOUR_TIME = VaultTask.register(VaultMod.id("init_favour_extension"), (vault, player, world) -> {});
        INIT_SANDS_EVENT = VaultTask.register(VaultMod.id("init_sand_event"), (vault, player, world) -> {
            if (ModConfigs.SAND_EVENT.isEnabled()) {
                vault.getProperties().create(SAND_EVENT, new VaultSandEvent());
                player.getBehaviours().add(new VaultBehaviour(IS_FINISHED.negate(), TICK_SAND_EVENT));
            }
        });
        INIT_COW_VAULT = VaultTask.register(VaultMod.id("init_cow_vault"), (vault, player, world) -> {
            if (!vault.getProperties().exists(COW_VAULT)) {
                CrystalData crystalData = vault.getProperties().getBase(CRYSTAL_DATA).orElse(CrystalData.EMPTY);
                if (!crystalData.getType().canBeCowVault() || !crystalData.getModifiers().isEmpty() || vault.getProperties().getBaseOrDefault(IS_RAFFLE, false).booleanValue()) {
                    vault.getProperties().create(COW_VAULT, false);
                } else {
                    boolean isCowVault = VaultCowOverrides.forceSpecialVault;
                    vault.getProperties().create(COW_VAULT, isCowVault);
                    if (isCowVault) {
                        VaultCowOverrides.setupVault(vault);
                        vault.getModifiers().setInitialized();
                        vault.getAllObjectives().clear();
                        SummonAndKillBossObjective objective = new SummonAndKillBossObjective(VaultMod.id("summon_and_kill_boss"));
                        vault.getAllObjectives().add(objective.thenComplete(LEVEL_UP_GEAR).thenComplete(VICTORY_SCENE));
                    }
                }
            }
            VaultCowOverrides.forceSpecialVault = false;
        });
        INIT_GLOBAL_MODIFIERS = VaultTask.register(VaultMod.id("init_global_modifiers"), (vault, player, world) -> {
            Random rand = world.m_5822_();
            if (!vault.getModifiers().isInitialized()) {
                CrystalData crystalData = vault.getProperties().getBase(CRYSTAL_DATA).orElse(CrystalData.EMPTY);
                crystalData.apply(vault);
                if (!crystalData.preventsRandomModifiers()) {
                    VaultModifiers vaultModifiers = vault.getModifiers();
                    VaultModifiersGenerator.generateGlobal(vault, rand).forEach(vaultModifiers::addPermanentModifier);
                }
                vault.getModifiers().setInitialized();
            }
            vault.getModifiers().apply(vault, player, world, rand);
            if (!player.getModifiers().isInitialized()) {
                player.getModifiers().setInitialized();
            }
            player.getModifiers().apply(vault, player, world, rand);
        });
        RUNNER_TO_SPECTATOR = VaultTask.register(VaultMod.id("runner_to_spectator"), (vault, player, world) -> {
            vault.players.remove(player);
            vault.players.add(new VaultSpectator((VaultRunner)player));
        });
        HIDE_OVERLAY = VaultTask.register(VaultMod.id("hide_overlay"), (vault, player, world) -> player.sendIfPresent(world.m_142572_(), VaultOverlayMessage.hide()));
        PAUSE_IN_ARENA = VaultTask.register(VaultMod.id("pause_in_arena"), (vault, player, world) -> player.runIfPresent(world.m_142572_(), playerEntity -> {
            if (playerEntity.m_183503_().m_46472_() != VaultMod.ARENA_KEY) {
                return;
            }
            if (player instanceof VaultRunner) {
                --player.getTimer().runTime;
            }
        }));
        LEVEL_UP_GEAR = VaultTask.register(VaultMod.id("level_up_gear"), (vault, player, world) -> {
            if (player instanceof VaultRunner) {
                player.runIfPresent(world.m_142572_(), playerEntity -> {});
            }
        });
        REMOVE_SCAVENGER_ITEMS = VaultTask.register(VaultMod.id("remove_scavenger_items"), (vault, player, world) -> {});
        SAVE_SOULBOUND_GEAR = VaultTask.register(VaultMod.id("save_soulbound_gear"), (vault, player, world) -> player.runIfPresent(world.m_142572_(), sPlayer -> {
            SoulboundSnapshotData data = SoulboundSnapshotData.get(world);
            if (!data.hasSnapshot((Player)sPlayer)) {
                data.createSnapshot((Player)sPlayer);
            }
        }));
        REMOVE_INVENTORY_RESTORE_SNAPSHOTS = VaultTask.register(VaultMod.id("remove_inventory_snapshots"), (vault, player, world) -> {
            PhoenixSetSnapshotData setSnapshotData;
            PhoenixModifierSnapshotData modifierData = PhoenixModifierSnapshotData.get(world);
            if (modifierData.hasSnapshot(player.getPlayerId())) {
                modifierData.removeSnapshot(player.getPlayerId());
            }
            if ((setSnapshotData = PhoenixSetSnapshotData.get(world)).hasSnapshot(player.getPlayerId())) {
                setSnapshotData.removeSnapshot(player.getPlayerId());
            }
        });
        FINAL_VICTORY_SCENE = VaultTask.register(VaultMod.id("final_victory_scene"), (vault, player, world) -> {
            if (player instanceof VaultRunner) {
                player.getTimer().addTime(new WinExtension(player.getTimer(), 400), 0);
                player.runIfPresent(world.m_142572_(), playerEntity -> {
                    FireworkRocketEntity fireworks = new FireworkRocketEntity((Level)world, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), new ItemStack((ItemLike)Items.f_42688_));
                    world.m_7967_((Entity)fireworks);
                    world.m_6263_(null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), SoundEvents.f_12496_, SoundSource.MASTER, 1.0f, 1.0f);
                    TextComponent title = new TextComponent("Branch Cleared!");
                    title.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
                    TextComponent subtitle = new TextComponent("Place your keystone in the frame.");
                    subtitle.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
                    ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket((Component)title);
                    ClientboundSetSubtitleTextPacket subtitlePacket = new ClientboundSetSubtitleTextPacket((Component)subtitle);
                    playerEntity.f_8906_.m_141995_((Packet)titlePacket);
                    playerEntity.f_8906_.m_141995_((Packet)subtitlePacket);
                });
            }
        });
        EXIT_SAFELY = VaultTask.register(VaultMod.id("exit_safely"), (vault, player, world) -> player.runIfPresent(world.m_142572_(), playerEntity -> {
            VaultRaid parentVault;
            if (player instanceof VaultSpectator) {
                playerEntity.f_8941_.m_143473_(((VaultSpectator)player).oldGameType);
            }
            world.m_6263_(null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), ModSounds.VAULT_PORTAL_LEAVE, SoundSource.PLAYERS, 1.0f, 1.0f);
            world.m_6269_(null, (Entity)playerEntity, ModSounds.VAULT_PORTAL_LEAVE, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.exit();
            HIDE_OVERLAY.execute(vault, player, world);
            UUID parent = vault.getProperties().getBase(PARENT).orElse(null);
            VaultRaid vaultRaid = parentVault = parent == null ? null : VaultRaidData.get(world).get(parent);
            if (parentVault != null) {
                parentVault.getProperties().getBase(LOBBY).ifPresent(lobby -> {
                    VaultMember member = new VaultMember(player.getPlayerId());
                    member.getProperties().create(CAN_HEAL, true);
                    member.getBehaviours().add(new VaultBehaviour(IS_OUTSIDE, TP_TO_START));
                    member.getBehaviours().add(new VaultBehaviour(IS_DEAD.negate(), TICK_LOBBY));
                    parentVault.getPlayers().add(member);
                    TP_TO_START.execute(parentVault, member, world.m_142572_().m_129880_(parentVault.getProperties().getValue(DIMENSION)));
                    if (vault.getActiveObjectives().stream().allMatch(VaultObjective::isCompleted)) {
                        FINAL_VICTORY_SCENE.execute(vault, player, world);
                    } else {
                        player.runIfPresent(world.m_142572_(), sPlayer -> {
                            lobby.snapshots.restoreSnapshot((Player)sPlayer);
                            lobby.snapshots.removeSnapshot((Player)sPlayer);
                        });
                    }
                    vault.getPlayers().remove(player);
                });
                vault.getProperties().create(FORCE_ACTIVE, false);
            } else {
                VaultUtils.exitSafely(world.m_142572_().m_129880_(Level.f_46428_), playerEntity);
            }
        }));
        EXIT_DEATH = VaultTask.register(VaultMod.id("exit_death"), (vault, player, world) -> player.runIfPresent(world.m_142572_(), playerEntity -> {
            VaultRaid parentVault;
            if (player instanceof VaultSpectator) {
                playerEntity.f_8941_.m_143473_(((VaultSpectator)player).oldGameType);
            }
            world.m_6263_(null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), ModSounds.TIMER_KILL_SFX, SoundSource.PLAYERS, 1.0f, 1.0f);
            world.m_6269_(null, (Entity)playerEntity, ModSounds.TIMER_KILL_SFX, SoundSource.PLAYERS, 1.0f, 1.0f);
            playerEntity.m_150109_().m_36022_(stack -> true, -1, (Container)playerEntity.f_36095_.m_39730_());
            playerEntity.f_36096_.m_38946_();
            playerEntity.f_36095_.m_6199_((Container)playerEntity.m_150109_());
            playerEntity.m_6469_(new DamageSource("vaultFailed").m_19380_().m_19381_(), 1.0E8f);
            player.exit();
            HIDE_OVERLAY.execute(vault, player, world);
            UUID parent = vault.getProperties().getBase(PARENT).orElse(null);
            VaultRaid vaultRaid = parentVault = parent == null ? null : VaultRaidData.get(world).get(parent);
            if (parentVault != null) {
                parentVault.getProperties().getBase(LOBBY).ifPresent(lobby -> {
                    VaultMember member = new VaultMember(player.getPlayerId());
                    member.getProperties().create(CAN_HEAL, true);
                    member.getBehaviours().add(new VaultBehaviour(IS_OUTSIDE, TP_TO_START));
                    member.getBehaviours().add(new VaultBehaviour(IS_DEAD.negate(), TICK_LOBBY));
                    parentVault.getPlayers().add(member);
                    player.runIfPresent(world.m_142572_(), sPlayer -> lobby.snapshots.restoreSnapshot((Player)sPlayer));
                    vault.getPlayers().remove(player);
                });
                vault.getProperties().create(FORCE_ACTIVE, false);
            }
        }));
        EXIT_DEATH_ALL = VaultTask.register(VaultMod.id("exit_death_all"), (vault, player, world) -> new ArrayList<VaultPlayer>(vault.players).forEach(vPlayer -> REMOVE_SCAVENGER_ITEMS.then(SAVE_SOULBOUND_GEAR.then(EXIT_DEATH)).execute(vault, (VaultPlayer)vPlayer, world)));
        EXIT_DEATH_ALL_NO_SAVE = VaultTask.register(VaultMod.id("exit_death_all_no_save"), (vault, player, world) -> new ArrayList<VaultPlayer>(vault.players).forEach(vPlayer -> REMOVE_SCAVENGER_ITEMS.then(EXIT_DEATH).execute(vault, (VaultPlayer)vPlayer, world)));
        VICTORY_SCENE = VaultTask.register(VaultMod.id("victory_scene"), (vault, player, world) -> {
            if (player instanceof VaultRunner) {
                player.getTimer().addTime(new WinExtension(player.getTimer(), 400), 0);
                player.runIfPresent(world.m_142572_(), playerEntity -> {
                    FireworkRocketEntity fireworks = new FireworkRocketEntity((Level)world, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), new ItemStack((ItemLike)Items.f_42688_));
                    world.m_7967_((Entity)fireworks);
                    world.m_6263_(null, playerEntity.m_20185_(), playerEntity.m_20186_(), playerEntity.m_20189_(), SoundEvents.f_12496_, SoundSource.MASTER, 1.0f, 1.0f);
                    TextComponent title = new TextComponent("Vault Cleared!");
                    title.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
                    TextComponent subtitle = new TextComponent("You'll be teleported back soon...");
                    subtitle.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
                    ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket((Component)title);
                    ClientboundSetSubtitleTextPacket subtitlePacket = new ClientboundSetSubtitleTextPacket((Component)subtitle);
                    playerEntity.f_8906_.m_141995_((Packet)titlePacket);
                    playerEntity.f_8906_.m_141995_((Packet)subtitlePacket);
                });
            }
        });
        ENTER_DISPLAY = VaultTask.register(VaultMod.id("enter_display"), (vault, player, world) -> player.runIfPresent(world.m_142572_(), playerEntity -> {
            TextComponent title = new TextComponent("The Vault");
            title.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
            MutableComponent subtitle = vault.canExit(player) ? new TextComponent("Good luck, ").m_7220_(playerEntity.m_7755_()).m_7220_((Component)new TextComponent("!")) : new TextComponent("No exit this time, ").m_7220_(playerEntity.m_7755_()).m_7220_((Component)new TextComponent("!"));
            subtitle.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)14536734)));
            ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket((Component)title);
            ClientboundSetSubtitleTextPacket subtitlePacket = new ClientboundSetSubtitleTextPacket((Component)subtitle);
            playerEntity.f_8906_.m_141995_((Packet)titlePacket);
            playerEntity.f_8906_.m_141995_((Packet)subtitlePacket);
            TextComponent text = new TextComponent("");
            AtomicBoolean startsWithVowel = new AtomicBoolean(false);
            vault.getModifiers().forEach((i, modifierStack) -> {
                text.m_130946_(modifierStack.getSize() + "x ");
                text.m_7220_(modifierStack.getModifier().getNameComponentFormatted(modifierStack.getSize()));
                if (i == 0) {
                    char c = modifierStack.getModifier().getDisplayName().toLowerCase().charAt(0);
                    startsWithVowel.set(c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u');
                }
                if (i != vault.getModifiers().size() - 1) {
                    text.m_7220_((Component)new TextComponent(", "));
                }
            });
            Component vaultName = vault.getActiveObjectives().stream().findFirst().map(VaultObjective::getVaultName).orElse((Component)new TextComponent("Vault"));
            if (vault.getModifiers().isEmpty()) {
                char c = vaultName.getString().toLowerCase().charAt(0);
                startsWithVowel.set(c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u');
            }
            TextComponent prefix = new TextComponent(startsWithVowel.get() ? " entered an " : " entered a ");
            if (!vault.getModifiers().isEmpty()) {
                text.m_7220_((Component)new TextComponent(" "));
            }
            if (vault.getProperties().getBaseOrDefault(COW_VAULT, false).booleanValue()) {
                TextComponent txt = new TextComponent("Vault that doesn't exist!");
                TextComponent hoverText = new TextComponent("A vault that doesn't exist.\nThe Vault gods are not responsible for events that transpire here.\n\nThis realm may also harbor additional riches.");
                txt.m_6270_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText)).m_131148_(TextColor.m_131266_((int)9974168)));
                text.m_7220_((Component)txt);
            } else {
                text.m_7220_(vaultName).m_130946_("!");
            }
            prefix.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
            text.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFFFFFF)));
            MutableComponent playerName = playerEntity.m_5446_().m_6881_();
            playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
            world.m_142572_().m_6846_().m_11264_((Component)playerName.m_7220_((Component)prefix).m_7220_((Component)text), ChatType.CHAT, player.getPlayerId());
        }));
        SUMMON_AND_KILL_BOSS = VaultObjective.register(() -> new SummonAndKillBossObjective(VaultMod.id("summon_and_kill_boss")));
        SCAVENGER_HUNT = VaultObjective.register(() -> new LegacyScavengerHuntObjective(VaultMod.id("scavenger_hunt")));
        ARCHITECT_EVENT = VaultObjective.register(() -> new ArchitectObjective(VaultMod.id("architect")));
        VAULT_TROVE = VaultObjective.register(() -> new TroveObjective(VaultMod.id("trove")));
        ANCIENTS = VaultObjective.register(() -> new AncientObjective(VaultMod.id("ancients")));
        RAID_CHALLENGE = VaultObjective.register(() -> new RaidChallengeObjective(VaultMod.id("raid_challenge")));
        CAKE_HUNT = VaultObjective.register(() -> new CakeHuntObjective(VaultMod.id("cake_hunt")));
        SUMMON_AND_KILL_ALL_BOSSES = VaultObjective.register(() -> new SummonAndKillAllBossesObjective(VaultMod.id("summon_and_kill_all_bosses")));
        TREASURE_HUNT = VaultObjective.register(() -> new TreasureHuntObjective(VaultMod.id("treasure_hunt")));
        TRIGGER_BOSS_SUMMON = VaultEvent.register(VaultMod.id("trigger_boss_summon"), Event.class, (vault, event) -> {});
        SCALE_MOB = VaultEvent.register(VaultMod.id("scale_mob"), LivingEvent.LivingUpdateEvent.class, LegacyEntityScaler::scaleVaultEntity);
        SCALE_MOB_JOIN = VaultEvent.register(VaultMod.id("scale_mob_join"), EntityJoinWorldEvent.class, LegacyEntityScaler::scaleVaultEntity);
        BLOCK_NATURAL_SPAWNING = VaultEvent.register(VaultMod.id("block_natural_spawning"), LivingSpawnEvent.CheckSpawn.class, (vault, event) -> {
            if (!VaultUtils.inVault(vault, event.getEntity())) {
                return;
            }
            event.setResult(Event.Result.DENY);
        });
        PREVENT_ITEM_PICKUP = VaultEvent.register(VaultMod.id("prevent_item_pickup"), EntityJoinWorldEvent.class, (vault, event) -> {
            if (event.getEntity() instanceof Mob) {
                Mob me = (Mob)event.getEntity();
                if (VaultUtils.inVault(vault, event.getEntity())) {
                    me.m_21553_(false);
                }
            }
        });
        REPLACE_WITH_COW = VaultEvent.register(VaultMod.id("replace_with_cow"), EntityJoinWorldEvent.class, (vault, event) -> {
            AggressiveCowEntity replaced;
            if (!(event.getWorld() instanceof ServerLevel)) {
                return;
            }
            Entity entity = event.getEntity();
            if (entity.m_19880_().contains("replaced_entity")) {
                return;
            }
            if (!VaultUtils.inVault(vault, event.getEntity())) {
                return;
            }
            if (entity instanceof LivingEntity && !(entity instanceof Player) && (replaced = VaultCowOverrides.replaceVaultEntity(vault, (LivingEntity)entity, (ServerLevel)event.getWorld())) != null) {
                Vec3 pos = entity.m_20182_();
                replaced.m_19890_(pos.f_82479_, pos.f_82480_, pos.f_82481_, entity.m_146908_(), entity.m_146909_());
                ServerScheduler.INSTANCE.schedule(1, () -> VaultRaid.lambda$static$124(event, (LivingEntity)replaced));
                event.setCanceled(true);
            }
        });
        APPLY_SCALE_MODIFIER = VaultEvent.register(VaultMod.id("apply_scale_modifier"), EntityJoinWorldEvent.class, (vault, event) -> {
            if (!(event.getWorld() instanceof ServerLevel)) {
                return;
            }
            if (!VaultUtils.inVault(vault, event.getEntity())) {
                return;
            }
            if (!(event.getEntity() instanceof LivingEntity)) {
                return;
            }
            if (event.getEntity() instanceof Player) {
                return;
            }
            if (event.getEntity() instanceof EternalEntity) {
                return;
            }
            LivingEntity entity = (LivingEntity)event.getEntity();
            vault.withActiveModifiersFor(PlayerFilter.any(), ScaleModifier.class, (scaleModifier, stackSize) -> entity.m_21051_(ModAttributes.SIZE_SCALE).m_22100_((double)((ScaleModifier.Properties)scaleModifier.properties()).getScale()));
        });
        APPLY_FRENZY_MODIFIERS = VaultEvent.register(VaultMod.id("frenzy_modifiers"), EntityJoinWorldEvent.class, (vault, event) -> {
            if (!(event.getWorld() instanceof ServerLevel)) {
                return;
            }
            if (!VaultUtils.inVault(vault, event.getEntity())) {
                return;
            }
            if (!(event.getEntity() instanceof LivingEntity)) {
                return;
            }
            if (event.getEntity() instanceof Player) {
                return;
            }
            if (event.getEntity() instanceof EternalEntity) {
                return;
            }
            if (event.getEntity().m_19880_().contains("vault_boss")) {
                return;
            }
            LivingEntity entity = (LivingEntity)event.getEntity();
            if (entity.m_19880_().contains("frenzy_scaled")) {
                return;
            }
            vault.withActiveModifiersFor(PlayerFilter.any(), MobFrenzyModifier.class, (mobFrenzyModifier, stackSize) -> {});
            entity.m_19880_().add("frenzy_scaled");
        });
        APPLY_MOB_ATTRIBUTE_MODIFIERS = VaultEvent.register(VaultMod.id("mob_attribute_modifiers"), EntityJoinWorldEvent.class, (vault, event) -> {
            if (!(event.getWorld() instanceof ServerLevel)) {
                return;
            }
            if (!VaultUtils.inVault(vault, event.getEntity())) {
                return;
            }
            Entity patt62046$temp = event.getEntity();
            if (!(patt62046$temp instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)patt62046$temp;
            if (event.getEntity() instanceof Player) {
                return;
            }
            if (event.getEntity() instanceof EternalEntity) {
                return;
            }
            vault.withActiveModifiersFor(PlayerFilter.any(), MobAttributeModifier.class, (mobAttributeModifier, stackSize) -> {});
        });
        APPLY_INFLUENCE_MODIFIERS = VaultEvent.register(VaultMod.id("influence_modifiers"), EntityJoinWorldEvent.class, (vault, event) -> {
            if (!(event.getWorld() instanceof ServerLevel)) {
                return;
            }
            if (!VaultUtils.inVault(vault, event.getEntity())) {
                return;
            }
            if (!(event.getEntity() instanceof LivingEntity)) {
                return;
            }
            if (event.getEntity() instanceof Player) {
                return;
            }
            if (event.getEntity() instanceof EternalEntity) {
                return;
            }
            LivingEntity entity = (LivingEntity)event.getEntity();
            if (entity.m_19880_().contains("influenced")) {
                return;
            }
            vault.getInfluences().getInfluences(MobAttributeInfluence.class).forEach(influence -> influence.applyTo(entity));
            entity.m_19880_().add("influenced");
        });
    }

    public static class Builder {
        private final VaultLogic logic;
        private final VaultObjective objective;
        private VaultTask initializer;
        private VaultTask levelInitializer = INIT_LEVEL;
        private Supplier<? extends VaultGenerator> generator;
        private final RaidProperties attributes = new RaidProperties();
        private final List<VaultEvent<?>> events = new ArrayList();
        private final Map<VaultPlayerType, Set<ServerPlayer>> players = new HashMap<VaultPlayerType, Set<ServerPlayer>>();

        protected Builder(VaultLogic logic, int vaultLevel, @Nullable VaultObjective objective) {
            this.objective = objective == null ? logic.getRandomObjective(vaultLevel) : objective;
            this.generator = this.objective == null ? null : this.objective.getVaultGenerator();
            this.logic = logic;
        }

        public Builder setInitializer(VaultTask initializer) {
            this.initializer = initializer;
            return this;
        }

        public Builder setLevelInitializer(VaultTask initializer) {
            this.levelInitializer = initializer;
            return this;
        }

        public VaultTask getLevelInitializer() {
            return this.levelInitializer;
        }

        public Builder setGenerator(Supplier<? extends VaultGenerator> generator) {
            this.generator = generator;
            return this;
        }

        public Builder addPlayer(VaultPlayerType type, ServerPlayer player) {
            return this.addPlayers(type, Stream.of(player));
        }

        public Builder addPlayers(VaultPlayerType type, Collection<ServerPlayer> player) {
            return this.addPlayers(type, player.stream());
        }

        public Builder addPlayers(VaultPlayerType type, Stream<ServerPlayer> player) {
            Set players = this.players.computeIfAbsent(type, key -> new HashSet());
            player.forEach(players::add);
            return this;
        }

        public Builder addEvents(VaultEvent<?> ... events) {
            return this.addEvents(Arrays.asList(events));
        }

        public Builder addEvents(Collection<VaultEvent<?>> events) {
            this.events.addAll(events);
            return this;
        }

        public <T, I extends VAttribute.Instance<T>> boolean contains(VAttribute<T, I> attribute) {
            return this.attributes.exists(attribute);
        }

        public <T, I extends VAttribute.Instance<T>> Builder set(VAttribute<T, I> attribute, T value) {
            this.attributes.create(attribute, value);
            return this;
        }

        public VaultRaid build() {
            return this.logic.getFactory().create(this.generator.get(), this.initializer, this.attributes, this.objective, this.events, this.players);
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public VaultRaid create(VaultGenerator var1, VaultTask var2, RaidProperties var3, VaultObjective var4, List<VaultEvent<?>> var5, Map<VaultPlayerType, Set<ServerPlayer>> var6);
    }
}

