/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.legacy.raid;

import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;

public class ReturnInfo
implements INBTSerializable<CompoundTag> {
    private Vec3 position;
    private float yaw;
    private float pitch;
    private GameType gamemode;
    private ResourceKey<Level> dimension;

    public ReturnInfo() {
        this(Vec3.f_82478_, 0.0f, 0.0f, GameType.f_151492_, (ResourceKey<Level>)ServerLevel.f_46428_);
    }

    public ReturnInfo(ServerPlayer player) {
        this(player.m_20182_(), player.m_146908_(), player.m_146909_(), player.f_8941_.m_9290_(), (ResourceKey<Level>)player.f_19853_.m_46472_());
    }

    public ReturnInfo(Vec3 position, float yaw, float pitch, GameType gamemode, ResourceKey<Level> dimension) {
        this.position = position;
        this.yaw = yaw;
        this.pitch = pitch;
        this.gamemode = gamemode;
        this.dimension = dimension;
    }

    public void apply(MinecraftServer server, ServerPlayer player) {
        ServerLevel world = server.m_129880_(this.dimension);
        player.m_8999_(world, this.position.f_82479_, this.position.f_82480_, this.position.f_82481_, this.yaw, this.pitch);
        player.m_143403_(this.gamemode);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_("PosX", this.position.f_82479_);
        nbt.m_128347_("PosY", this.position.f_82480_);
        nbt.m_128347_("PosZ", this.position.f_82481_);
        nbt.m_128350_("Yaw", this.yaw);
        nbt.m_128350_("Pitch", this.pitch);
        nbt.m_128405_("Gamemode", this.gamemode.ordinal());
        nbt.m_128359_("Dimension", this.dimension.m_135782_().toString());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.position = new Vec3(nbt.m_128459_("PosX"), nbt.m_128459_("PosY"), nbt.m_128459_("PosZ"));
        this.yaw = nbt.m_128457_("Yaw");
        this.pitch = nbt.m_128457_("Pitch");
        this.gamemode = GameType.m_46393_((int)nbt.m_128451_("Gamemode"));
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("Dimension")));
    }
}

