/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.legacy.raid;

import iskallia.vault.entity.entity.ArenaTrackerEntity;
import iskallia.vault.init.ModEntities;
import iskallia.vault.world.data.StreamData;
import iskallia.vault.world.legacy.raid.ArenaRaid;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.util.INBTSerializable;

public class ArenaSpawner
implements INBTSerializable<CompoundTag> {
    private static final String[] DEV_NICKS = new String[]{"KaptainWutax", "iGoodie", "jmilthedude", "Scalda", "Kumara22", "Goktwo", "Aolsen96", "Winter_Grave", "kimandjax", "Monni_21", "Starmute", "MukiTanuki", "RowanArtifex", "HellFirePvP", "Pau1_", "Douwsky", "neentarts", "Reed22"};
    private final ArenaRaid raid;
    public final List<UUID> fighters = new ArrayList<UUID>();
    public final List<UUID> bosses = new ArrayList<UUID>();
    private final int bossCount;
    public List<StreamData.Subscribers.Instance> subscribers = new ArrayList<StreamData.Subscribers.Instance>();
    private boolean started;

    public ArenaSpawner(ArenaRaid raid, int bossCount) {
        this.raid = raid;
        this.bossCount = bossCount;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public void addFighters(List<StreamData.Subscribers.Instance> fighterNames) {
        this.subscribers = new ArrayList<StreamData.Subscribers.Instance>(fighterNames);
    }

    public void start(ServerLevel world) {
        int i;
        this.fighters.clear();
        this.bosses.clear();
        boolean maxMonths = false;
        float fightersHealth = 0.0f;
        for (i = 0; i < this.subscribers.size(); ++i) {
            double radius = 40.0;
            double a = (double)i / (double)this.subscribers.size() * 2.0 * Math.PI;
            double s = Math.sin(a);
            double c = Math.cos(a);
            double r = Math.sqrt(radius * radius / (s * s + c * c));
            BlockPos blockPos = this.raid.getCenter().m_142022_(s * r, (double)(256 - this.raid.getCenter().m_123342_()), c * r);
        }
        for (i = 0; i < this.bossCount; ++i) {
        }
        ArenaTrackerEntity tracker = (ArenaTrackerEntity)ModEntities.ARENA_TRACKER.m_20615_((Level)world);
        tracker.m_21051_(Attributes.f_22276_).m_22100_((double)fightersHealth);
        tracker.m_7678_(this.raid.getCenter().m_123341_(), 128.0, this.raid.getCenter().m_123343_(), 0.0f, 0.0f);
        tracker.m_6593_((Component)new TextComponent("Subscribers"));
        world.m_7967_((Entity)tracker);
        this.started = true;
    }

    public int getFighterCount() {
        return this.subscribers.size();
    }

    public BlockPos toTop(ServerLevel world, BlockPos pos) {
        return pos.m_6630_(world.m_6522_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62326_, true).m_5885_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_(), pos.m_123343_()) + 1);
    }

    public static String getRandomDevName(Random rand) {
        return DEV_NICKS[rand.nextInt(DEV_NICKS.length)];
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag bossList = new ListTag();
        ListTag fighterList = new ListTag();
        ListTag subscriberList = new ListTag();
        this.bosses.forEach(uuid -> bossList.add((Object)StringTag.m_129297_((String)uuid.toString())));
        this.fighters.forEach(uuid -> fighterList.add((Object)StringTag.m_129297_((String)uuid.toString())));
        this.subscribers.forEach(sub -> subscriberList.add((Object)sub.serializeNBT()));
        nbt.m_128365_("BossList", (Tag)bossList);
        nbt.m_128365_("FighterList", (Tag)fighterList);
        nbt.m_128365_("SubscriberList", (Tag)subscriberList);
        nbt.m_128379_("Started", this.started);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.bosses.clear();
        this.fighters.clear();
        ListTag bossList = nbt.m_128437_("BossList", 8);
        ListTag fighterList = nbt.m_128437_("FighterList", 8);
        ListTag subscriberList = nbt.m_128437_("SubscriberList", 10);
        IntStream.range(0, bossList.size()).mapToObj(i -> UUID.fromString(bossList.m_128778_(i))).forEach(this.bosses::add);
        IntStream.range(0, fighterList.size()).mapToObj(i -> UUID.fromString(fighterList.m_128778_(i))).forEach(this.fighters::add);
        IntStream.range(0, subscriberList.size()).forEach(i -> {
            StreamData.Subscribers.Instance sub = new StreamData.Subscribers.Instance();
            sub.deserializeNBT(subscriberList.m_128728_(i));
            this.subscribers.add(sub);
        });
        this.started = nbt.m_128471_("Started");
    }
}

