/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.legacy.raid;

import com.google.common.collect.ImmutableMap;
import iskallia.vault.world.legacy.raid.ArenaRaid;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class ArenaScoreboard
implements INBTSerializable<CompoundTag> {
    private final ArenaRaid raid;
    private Map<String, Float> damageMap = new HashMap<String, Float>();

    public ArenaScoreboard(ArenaRaid raid) {
        this.raid = raid;
    }

    public Map<String, Float> get() {
        return ImmutableMap.copyOf(this.damageMap);
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag nameList = new ListTag();
        ListTag amountList = new ListTag();
        this.damageMap.forEach((name, amount) -> {
            nameList.add((Object)StringTag.m_129297_((String)name));
            amountList.add((Object)FloatTag.m_128566_((float)amount.floatValue()));
        });
        nbt.m_128365_("NameList", (Tag)nameList);
        nbt.m_128365_("AmountList", (Tag)amountList);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.damageMap.clear();
        ListTag nameList = nbt.m_128437_("NameList", 8);
        ListTag amountList = nbt.m_128437_("AmountList", 5);
        if (nameList.size() != amountList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < nameList.size(); ++i) {
            this.damageMap.put(nameList.m_128778_(i), Float.valueOf(amountList.m_128775_(i)));
        }
    }
}

