/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.legacy.raid;

import iskallia.vault.VaultMod;
import iskallia.vault.block.VaultCrateBlock;
import iskallia.vault.block.item.LootStatueBlockItem;
import iskallia.vault.entity.entity.ArenaBossEntity;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.ItemVaultCrystalSeal;
import iskallia.vault.network.message.VaultOverlayMessage;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.ArenaRaidData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import iskallia.vault.world.data.StreamData;
import iskallia.vault.world.legacy.raid.ArenaScoreboard;
import iskallia.vault.world.legacy.raid.ArenaSpawner;
import iskallia.vault.world.legacy.raid.ReturnInfo;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.NetworkDirection;

public class ArenaRaid
implements INBTSerializable<CompoundTag> {
    public static final int REGION_SIZE = 2048;
    private UUID playerId;
    public BoundingBox box;
    private boolean isComplete;
    public BlockPos start;
    public ArenaSpawner spawner;
    public ArenaScoreboard scoreboard;
    public ReturnInfo returnInfo;
    private int time;
    private int endDelay;
    private int checkCooldown;

    protected ArenaRaid() {
        this.spawner = new ArenaSpawner(this, ModConfigs.ARENA_GENERAL.BOSS_COUNT);
        this.scoreboard = new ArenaScoreboard(this);
        this.returnInfo = new ReturnInfo();
        this.time = 0;
        this.endDelay = 300;
        this.checkCooldown = 20;
    }

    public ArenaRaid(UUID playerId, BoundingBox box) {
        this.spawner = new ArenaSpawner(this, ModConfigs.ARENA_GENERAL.BOSS_COUNT);
        this.scoreboard = new ArenaScoreboard(this);
        this.returnInfo = new ReturnInfo();
        this.time = 0;
        this.endDelay = 300;
        this.checkCooldown = 20;
        this.playerId = playerId;
        this.box = box;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean isComplete() {
        return this.isComplete && this.endDelay < 0;
    }

    public BlockPos getCenter() {
        return this.start;
    }

    public void tick(ServerLevel world) {
        if (this.start == null) {
            return;
        }
        if (this.isComplete) {
            --this.endDelay;
            return;
        }
        ++this.time;
        this.runIfPresent(world, player -> ModNetwork.CHANNEL.sendTo((Object)VaultOverlayMessage.forArena(ModConfigs.ARENA_GENERAL.TICK_COUNTER - this.time), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
        if (this.checkCooldown-- > 0) {
            return;
        }
        if (this.spawner.hasStarted()) {
            if (this.time > ModConfigs.ARENA_GENERAL.TICK_COUNTER) {
                this.spawner.fighters.stream().map(arg_0 -> ((ServerLevel)world).m_8791_(arg_0)).filter(Objects::nonNull).forEach(entity -> entity.m_142467_(Entity.RemovalReason.DISCARDED));
            }
            boolean bossLeft = this.spawner.bosses.stream().map(arg_0 -> ((ServerLevel)world).m_8791_(arg_0)).anyMatch(entity -> entity instanceof ArenaBossEntity);
            boolean fighterLeft = true;
            if (!bossLeft) {
                this.onFighterWin(world);
                this.runIfPresent(world, player -> ModNetwork.CHANNEL.sendTo((Object)VaultOverlayMessage.hide(), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
                this.isComplete = true;
            } else if (!fighterLeft) {
                this.onBossWin(world);
                this.runIfPresent(world, player -> ModNetwork.CHANNEL.sendTo((Object)VaultOverlayMessage.hide(), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
                this.isComplete = true;
            }
        } else if (this.time > 100) {
            this.spawner.start(world);
        }
    }

    private void onBossWin(ServerLevel world) {
        this.runIfPresent(world, playerEntity -> {
            TextComponent title = new TextComponent("You Lost");
            title.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            TextComponent subtitle = new TextComponent("F");
            subtitle.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            TextComponent actionBar = this.time > ModConfigs.ARENA_GENERAL.TICK_COUNTER ? new TextComponent("Ran out of time.") : new TextComponent("No subscribers left standing.");
            actionBar.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xFF0000)));
            ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket((Component)title);
            ClientboundSetSubtitleTextPacket subtitlePacket = new ClientboundSetSubtitleTextPacket((Component)subtitle);
            playerEntity.f_8906_.m_141995_((Packet)titlePacket);
            playerEntity.f_8906_.m_141995_((Packet)subtitlePacket);
            playerEntity.m_5661_((Component)actionBar, true);
        });
    }

    private void onFighterWin(ServerLevel world) {
        this.runIfPresent(world, playerEntity -> {
            TextComponent title = new TextComponent("You Win");
            title.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)65280)));
            TextComponent subtitle = new TextComponent("GG");
            subtitle.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9563710)));
            TextComponent actionBar = new TextComponent("With " + this.spawner.fighters.stream().map(arg_0 -> ((ServerLevel)world).m_8791_(arg_0)).filter(Objects::nonNull).count() + " subscribers left.");
            actionBar.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9563710)));
            ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket((Component)title);
            ClientboundSetSubtitleTextPacket subtitlePacket = new ClientboundSetSubtitleTextPacket((Component)subtitle);
            playerEntity.f_8906_.m_141995_((Packet)titlePacket);
            playerEntity.f_8906_.m_141995_((Packet)subtitlePacket);
            playerEntity.m_5661_((Component)actionBar, true);
        });
        for (int i = 0; i < 64; ++i) {
            FireworkRocketEntity firework = new FireworkRocketEntity((Level)world, (double)(this.getCenter().m_123341_() + world.m_5822_().nextInt(81) - 40), (double)(this.getCenter().m_123342_() - 15), (double)(this.getCenter().m_123343_() + world.m_5822_().nextInt(81) - 40), new ItemStack((ItemLike)Items.f_42688_));
            world.m_8847_((Entity)firework);
        }
        this.scheduleLoot(world);
    }

    private void scheduleLoot(ServerLevel world) {
        this.runIfPresent(world, playerEntity -> {
            LootContext.Builder builder = new LootContext.Builder(world).m_78977_(world.f_46441_).m_78963_(playerEntity.m_36336_());
            LootContext ctx = builder.m_78975_(LootContextParamSets.f_81410_);
            NonNullList stacks = NonNullList.m_122779_();
            stacks.add((Object)LootStatueBlockItem.getStatueBlockItem(this.scoreboard.get().entrySet().stream().sorted((o1, o2) -> Float.compare(((Float)o2.getValue()).floatValue(), ((Float)o1.getValue()).floatValue())).map(Map.Entry::getKey).findFirst().orElse("")));
            int level = PlayerVaultStatsData.get(world).getVaultStats((Player)playerEntity).getVaultLevel();
            LootTable rewardLootTable = world.m_142572_().m_129898_().m_79217_(ModConfigs.LOOT_TABLES.getForLevel(level).getArenaCrate());
            stacks.addAll((Collection)rewardLootTable.m_79129_(ctx));
            if (ModConfigs.RAID_EVENT_CONFIG.isEnabled()) {
                ItemStack eventSeal = new ItemStack((ItemLike)ModItems.CRYSTAL_SEAL_RAID);
                ItemVaultCrystalSeal.setEventKey(eventSeal, "raid");
                stacks.add((Object)eventSeal);
            }
            ItemStack crateStack = VaultCrateBlock.getCrateWithLoot(VaultCrateBlock.Type.ARENA, (NonNullList<ItemStack>)stacks);
            ArenaRaidData.get(world).scheduleCrateToGive((ServerPlayer)playerEntity, crateStack);
        });
    }

    public void finish(ServerLevel world, ServerPlayer player) {
        if (player != null) {
            this.returnInfo.apply(world.m_142572_(), player);
            StreamData.get(world).onArenaLeave(world.m_142572_(), this.playerId);
        }
    }

    public boolean runIfPresent(ServerLevel world, Consumer<ServerPlayer> action) {
        if (world == null) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)world.m_46003_(this.playerId);
        if (player == null) {
            return false;
        }
        action.accept(player);
        return true;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("PlayerId", this.playerId);
        nbt.m_128365_("Box", (Tag)NBTHelper.serializeBoundingBox(this.box));
        nbt.m_128379_("Completed", this.isComplete());
        nbt.m_128405_("Time", this.time);
        nbt.m_128405_("EndDelay", this.endDelay);
        if (this.start != null) {
            CompoundTag startNBT = new CompoundTag();
            startNBT.m_128405_("x", this.start.m_123341_());
            startNBT.m_128405_("y", this.start.m_123342_());
            startNBT.m_128405_("z", this.start.m_123343_());
            nbt.m_128365_("Start", (Tag)startNBT);
        }
        nbt.m_128365_("Scoreboard", (Tag)this.scoreboard.serializeNBT());
        nbt.m_128365_("ReturnInfo", (Tag)this.returnInfo.serializeNBT());
        nbt.m_128365_("Spawner", (Tag)this.spawner.serializeNBT());
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.playerId = nbt.m_128342_("PlayerId");
        this.box = NBTHelper.deserializeBoundingBox(nbt.m_128465_("Box"));
        this.isComplete = nbt.m_128471_("Completed");
        this.time = nbt.m_128451_("Time");
        this.endDelay = nbt.m_128451_("EndDelay");
        if (nbt.m_128425_("Start", 10)) {
            CompoundTag startNBT = nbt.m_128469_("Start");
            this.start = new BlockPos(startNBT.m_128451_("x"), startNBT.m_128451_("y"), startNBT.m_128451_("z"));
        }
        if (nbt.m_128425_("Scoreboard", 10)) {
            this.scoreboard.deserializeNBT(nbt.m_128469_("Scoreboard"));
        }
        if (nbt.m_128425_("ReturnInfo", 10)) {
            this.returnInfo.deserializeNBT(nbt.m_128469_("ReturnInfo"));
        }
        if (nbt.m_128425_("Spawner", 10)) {
            this.spawner.deserializeNBT(nbt.m_128469_("Spawner"));
        }
    }

    public static ArenaRaid fromNBT(CompoundTag nbt) {
        ArenaRaid raid = new ArenaRaid();
        raid.deserializeNBT(nbt);
        return raid;
    }

    public void teleportToStart(ServerLevel world, ServerPlayer player) {
        if (this.start == null) {
            VaultMod.LOGGER.warn("No arena start was found.");
            player.m_8999_(world, (double)((float)this.box.m_162395_() + (float)this.box.m_71056_() / 2.0f), 256.0, (double)((float)this.box.m_162398_() + (float)this.box.m_71058_() / 2.0f), player.m_146908_(), player.m_146909_());
            return;
        }
        player.m_8999_(world, (double)this.start.m_123341_() + 0.5, (double)this.start.m_123342_() + 0.2, (double)this.start.m_123343_() + 0.5, world.m_5822_().nextFloat() * 360.0f, 0.0f);
        player.m_6853_(true);
    }

    public void start(ServerLevel world, ServerPlayer player, ChunkPos chunkPos) {
        int y;
        int z;
        int x;
        this.returnInfo = new ReturnInfo(player);
        block0: for (x = -48; x < 48; ++x) {
            for (z = -48; z < 48; ++z) {
                for (y = 0; y < 48; ++y) {
                    BlockPos pos = chunkPos.m_45615_().m_142082_(x, 32 + y, z);
                    if (world.m_8055_(pos).m_60734_() != Blocks.f_50659_) continue;
                    world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                    this.start = pos;
                    break block0;
                }
            }
        }
        if (this.start != null) {
            for (x = -4; x <= 4; ++x) {
                for (z = -4; z <= 4; ++z) {
                    for (y = -4; y <= 4; ++y) {
                        world.m_46597_(this.start.m_142082_(x, y, z), Blocks.f_50016_.m_49966_());
                    }
                }
            }
            for (int i = 0; i < this.start.m_123342_() && !world.m_8055_(this.start.m_6625_(i)).m_60815_(); ++i) {
                world.m_46597_(this.start.m_6625_(i), Blocks.f_50016_.m_49966_());
            }
        }
        this.teleportToStart(world, player);
        player.m_20091_();
        player.m_143403_(GameType.SPECTATOR);
        this.runIfPresent(world, playerEntity -> {
            TextComponent title = new TextComponent("The Arena");
            title.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9563710)));
            TextComponent subtitle = new TextComponent("Let the fight begin!");
            subtitle.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9563710)));
            TextComponent actionBar = new TextComponent("You have " + this.spawner.getFighterCount() + " subscribers on your side.");
            actionBar.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9563710)));
            ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket((Component)title);
            ClientboundSetSubtitleTextPacket subtitlePacket = new ClientboundSetSubtitleTextPacket((Component)subtitle);
            playerEntity.f_8906_.m_141995_((Packet)titlePacket);
            playerEntity.f_8906_.m_141995_((Packet)subtitlePacket);
            playerEntity.m_5661_((Component)actionBar, true);
        });
    }
}

