/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.gen.structure;

import iskallia.vault.VaultMod;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.gen.structure.JigsawPiecePlacer;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.VaultGenerator;
import iskallia.vault.world.vault.gen.VaultRoomLevelRestrictions;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import iskallia.vault.world.vault.gen.piece.VaultRoom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class VaultJigsawHelper {
    private static final Random rand = new Random();
    public static final int ROOM_WIDTH_HEIGHT = 47;
    public static final int TUNNEL_LENGTH = 48;
    private static final Predicate<ResourceLocation> TUNNEL_FILTER = key -> {
        String path = key.m_135815_();
        return !path.contains("treasure_rooms") && !path.contains("rooms");
    };
    private static final Predicate<ResourceLocation> ROOM_FILTER = key -> {
        String path = key.m_135815_();
        return !path.contains("treasure_rooms") && !path.contains("tunnels");
    };

    public static List<VaultPiece> expandVault(VaultRaid vault, ServerLevel sWorld, VaultRoom fromRoom, Direction targetDir) {
        return VaultJigsawHelper.expandVault(vault, sWorld, fromRoom, targetDir, null);
    }

    public static List<VaultPiece> expandVault(VaultRaid vault, ServerLevel sWorld, VaultRoom fromRoom, Direction targetDir, @Nullable StructurePoolElement roomToGenerate) {
        if (targetDir.m_122434_() == Direction.Axis.Y) {
            return Collections.emptyList();
        }
        BlockPos side = fromRoom.getTunnelConnectorPos(targetDir);
        BlockPos.MutableBlockPos mutableGenPos = side.m_122032_();
        VaultGenerator generator = vault.getGenerator();
        int vaultLevel = vault.getProperties().getBase(VaultRaid.LEVEL).orElse(0);
        StructurePoolElement roomPiece = roomToGenerate == null ? VaultJigsawHelper.getRandomVaultRoom(vaultLevel) : roomToGenerate;
        ArrayList<VaultPiece> pieces = new ArrayList<VaultPiece>();
        pieces.addAll(VaultJigsawHelper.placeRandomTunnel(sWorld, mutableGenPos, targetDir));
        pieces.addAll(VaultJigsawHelper.placeRandomRoom(sWorld, mutableGenPos, targetDir, roomPiece));
        generator.addPieces(pieces);
        return pieces;
    }

    public static boolean canExpand(VaultRaid vault, VaultRoom fromRoom, Direction targetDir) {
        BlockPos roomCenter = new BlockPos(fromRoom.getCenter());
        if (!vault.getGenerator().getPiecesAt(roomCenter.m_5484_(targetDir, 28)).isEmpty()) {
            return false;
        }
        BlockPos nextRoom = roomCenter.m_5484_(targetDir, 95);
        BlockPos nextRoomEdge = nextRoom.m_5484_(targetDir, 24);
        if (vault.getProperties().getBase(VaultRaid.BOUNDING_BOX).map(box -> !box.m_71051_((Vec3i)nextRoomEdge)).orElse(true).booleanValue()) {
            return false;
        }
        return vault.getGenerator().getPiecesAt(nextRoom).isEmpty();
    }

    private static List<VaultPiece> placeRandomRoom(ServerLevel sWorld, BlockPos.MutableBlockPos generationPos, Direction toCenter, StructurePoolElement roomToGenerate) {
        int jigsawGroundOffset = 22;
        BlockPos at = generationPos.m_7949_();
        Rotation roomRotation = Rotation.m_55956_((Random)rand);
        StructureManager tplMgr = sWorld.m_8875_();
        BoundingBox jigsawBox = roomToGenerate.m_207470_(tplMgr, at, roomRotation);
        Vec3i size = jigsawBox.m_71053_();
        BlockPos directionOffset = new BlockPos(toCenter.m_122429_() * size.m_123341_() / 2, -jigsawGroundOffset + size.m_123342_() / 2, toCenter.m_122431_() * size.m_123343_() / 2);
        BlockPos genPos = at.m_141952_((Vec3i)directionOffset);
        BlockPos center = jigsawBox.m_162394_();
        genPos = genPos.m_141952_((Vec3i)at.m_141950_((Vec3i)center));
        List<VaultPiece> vaultPieces = JigsawPiecePlacer.newPlacer(roomToGenerate, sWorld, genPos).withRotation(roomRotation).andJigsawFilter(ROOM_FILTER).placeJigsaw();
        generationPos.m_122175_(toCenter, 23);
        return vaultPieces;
    }

    private static List<VaultPiece> placeRandomTunnel(ServerLevel sWorld, BlockPos.MutableBlockPos generationPos, Direction targetDir) {
        int jigsawGroundOffset = 2;
        StructurePoolElement tunnel = VaultJigsawHelper.getRandomVaultTunnel();
        BlockPos at = generationPos.m_7949_();
        Rotation tunnelRotation = VaultJigsawHelper.getTunnelRotation(targetDir);
        Direction shift = targetDir.m_122427_();
        StructureManager tplMgr = sWorld.m_8875_();
        BoundingBox jigsawBox = tunnel.m_207470_(tplMgr, at, tunnelRotation);
        Vec3i size = jigsawBox.m_71053_();
        BlockPos directionOffset = new BlockPos(targetDir.m_122429_() * size.m_123341_() / 2, 0, targetDir.m_122431_() * size.m_123343_() / 2);
        directionOffset = directionOffset.m_142082_(-(shift.m_122429_() * size.m_123341_()) / 2, -size.m_123342_() / 2 + jigsawGroundOffset, -(shift.m_122431_() * size.m_123343_()) / 2);
        BlockPos genPos = at.m_141952_((Vec3i)directionOffset);
        List<VaultPiece> vaultPieces = JigsawPiecePlacer.newPlacer(tunnel, sWorld, genPos).withRotation(tunnelRotation).andJigsawFilter(TUNNEL_FILTER).placeJigsaw();
        generationPos.m_122184_(targetDir.m_122429_() * size.m_123341_() / 2, 0, targetDir.m_122431_() * size.m_123343_() / 2).m_122173_(targetDir);
        return vaultPieces;
    }

    private static Rotation getTunnelRotation(Direction direction) {
        switch (direction) {
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static void preloadVaultRooms(ServerStartedEvent event) {
        Random rand = new Random();
        StructureManager mgr = event.getServer().m_129909_();
    }

    @Nonnull
    public static StructurePoolElement getRandomVaultTunnel() {
        return VaultJigsawHelper.getRandomPiece(VaultMod.id("vault/tunnels"));
    }

    @Nonnull
    public static StructurePoolElement getRandomVaultRoom(int vaultLevel) {
        WeightedList<StructurePoolElement> rooms = VaultJigsawHelper.getRoomList(VaultMod.id("vault/rooms"));
        return (StructurePoolElement)rooms.copyFiltered(piece -> VaultRoomLevelRestrictions.canGenerate(piece, vaultLevel)).getOptionalRandom(rand).orElseThrow(RuntimeException::new);
    }

    @Nonnull
    public static StructurePoolElement getArchitectRoom() {
        return VaultJigsawHelper.getRandomPiece(VaultMod.id("architect_event/rooms"));
    }

    @Nonnull
    public static StructurePoolElement getRaidChallengeRoom() {
        return VaultJigsawHelper.getRandomPiece(VaultMod.id("raid/rooms"));
    }

    @Nonnull
    public static WeightedList<StructurePoolElement> getVaultRoomList(int vaultLevel) {
        WeightedList<StructurePoolElement> rooms = VaultJigsawHelper.getRoomList(VaultMod.id("vault/rooms"));
        return rooms.copyFiltered(piece -> VaultRoomLevelRestrictions.canGenerate(piece, vaultLevel));
    }

    @Nonnull
    private static WeightedList<StructurePoolElement> getRoomList(ResourceLocation key) {
        StructureTemplatePool roomPool = VaultJigsawHelper.getPool(key);
        WeightedList<StructurePoolElement> pool = new WeightedList<StructurePoolElement>();
        roomPool.f_210559_.forEach(weightedPiece -> pool.add((StructurePoolElement)weightedPiece.getFirst(), (Integer)weightedPiece.getSecond()));
        return pool;
    }

    @Nonnull
    private static StructureTemplatePool getPool(ResourceLocation key) {
        MinecraftServer srv = ServerLifecycleHooks.getCurrentServer();
        Registry jigsawRegistry = srv.m_206579_().m_175515_(Registry.f_122884_);
        return (StructureTemplatePool)jigsawRegistry.m_6612_(key).orElseThrow(RuntimeException::new);
    }

    @Nonnull
    private static StructurePoolElement getRandomPiece(ResourceLocation key) {
        return (StructurePoolElement)VaultJigsawHelper.getRoomList(key).getOptionalRandom(rand).orElseThrow(RuntimeException::new);
    }
}

