/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.gen.structure;

import iskallia.vault.VaultMod;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class JigsawPieceResolver {
    private static final Object templateLoadLock = new Object();
    private static final Random rand = new Random();
    private final StructurePoolElement piece;
    private final BlockPos pos;
    private Rotation pieceRotation = Rotation.NONE;
    private Predicate<ResourceLocation> filter = key -> true;
    private final List<AABB> additionalStructureBoxes = new ArrayList<AABB>();

    private JigsawPieceResolver(StructurePoolElement piece, BlockPos pos) {
        this.piece = piece;
        this.pos = pos;
    }

    public static JigsawPieceResolver newResolver(StructurePoolElement piece, BlockPos pos) {
        return new JigsawPieceResolver(piece, pos);
    }

    public JigsawPieceResolver withRotation(Rotation rotation) {
        this.pieceRotation = rotation;
        return this;
    }

    public JigsawPieceResolver andJigsawFilter(Predicate<ResourceLocation> filter) {
        this.filter = filter.and(filter);
        return this;
    }

    public JigsawPieceResolver addStructureBox(AABB boundingBox) {
        this.additionalStructureBoxes.add(boundingBox);
        return this;
    }

    public List<PoolElementStructurePiece> resolveJigsawPieces(StructureManager templateManager, Registry<StructureTemplatePool> jigsawPatternRegistry) {
        PoolElementStructurePiece beginningPiece = new PoolElementStructurePiece(templateManager, this.piece, this.pos, this.piece.m_210540_(), this.pieceRotation, this.piece.m_207470_(templateManager, this.pos, this.pieceRotation));
        BoundingBox pieceBox = beginningPiece.m_73547_();
        int centerY = this.pos.m_123342_();
        int offset = pieceBox.m_162396_() + this.piece.m_210540_();
        beginningPiece.m_6324_(0, centerY - offset, 0);
        VoxelShape generationShape = Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)pieceBox).m_82400_(15.0));
        for (AABB additionalBoxes : this.additionalStructureBoxes) {
            generationShape = Shapes.m_83113_((VoxelShape)generationShape, (VoxelShape)Shapes.m_83064_((AABB)additionalBoxes), (BooleanOp)BooleanOp.f_82685_);
        }
        MutableObject generationBoxRef = new MutableObject((Object)generationShape);
        ArrayList<PoolElementStructurePiece> resolvedPieces = new ArrayList<PoolElementStructurePiece>();
        resolvedPieces.add(beginningPiece);
        ArrayList<Entry> generationEntries = new ArrayList<Entry>();
        generationEntries.add(new Entry(beginningPiece, (MutableObject<VoxelShape>)generationBoxRef));
        while (!generationEntries.isEmpty()) {
            Entry generationEntry = (Entry)generationEntries.remove(0);
            this.calculatePieces(resolvedPieces, generationEntries, generationEntry.villagePiece, generationEntry.generationBox, templateManager, jigsawPatternRegistry);
        }
        return resolvedPieces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculatePieces(List<PoolElementStructurePiece> resolvedPieces, List<Entry> generationEntries, PoolElementStructurePiece piece, MutableObject<VoxelShape> generationBox, StructureManager templateMgr, Registry<StructureTemplatePool> jigsawPatternRegistry) {
        List thisPieceBlocks;
        StructurePoolElement jigsawpiece = piece.m_209918_();
        BlockPos pos = piece.m_72646_();
        Rotation rotation = piece.m_6830_();
        BoundingBox pieceBox = piece.m_73547_();
        MutableObject<VoxelShape> thisPieceGenerationBox = new MutableObject<VoxelShape>();
        int minY = pieceBox.m_162396_();
        Iterator iterator = templateLoadLock;
        synchronized (iterator) {
            thisPieceBlocks = jigsawpiece.m_207245_(templateMgr, pos, rotation, rand);
        }
        block6: for (StructureTemplate.StructureBlockInfo blockInfo : thisPieceBlocks) {
            StructurePoolElement nextPiece;
            MutableObject<VoxelShape> nextGenerationBox;
            Direction connectingDirection = JigsawBlock.m_54250_((BlockState)blockInfo.f_74676_);
            BlockPos jigsawConnectorPos = blockInfo.f_74675_;
            BlockPos expectedConnectionPos = jigsawConnectorPos.m_142300_(connectingDirection);
            int jigsawYPos = jigsawConnectorPos.m_123342_() - minY;
            ResourceLocation connectorPool = new ResourceLocation(blockInfo.f_74677_.m_128461_("pool"));
            Optional mainJigsawPattern = jigsawPatternRegistry.m_6612_(connectorPool);
            if (!mainJigsawPattern.isPresent() || ((StructureTemplatePool)mainJigsawPattern.get()).m_210590_() == 0 && !Objects.equals(connectorPool, Pools.f_127186_.m_135782_())) {
                VaultMod.LOGGER.warn("Empty or none existent pool: {}", (Object)connectorPool);
                continue;
            }
            ResourceLocation fallbackConnectorPool = ((StructureTemplatePool)mainJigsawPattern.get()).m_210573_();
            Optional fallbackJigsawPattern = jigsawPatternRegistry.m_6612_(fallbackConnectorPool);
            if (!fallbackJigsawPattern.isPresent() || ((StructureTemplatePool)fallbackJigsawPattern.get()).m_210590_() == 0 && !Objects.equals(fallbackConnectorPool, Pools.f_127186_.m_135782_())) {
                VaultMod.LOGGER.warn("Empty or none existent fallback pool: {}", (Object)fallbackConnectorPool);
                continue;
            }
            if (pieceBox.m_71051_((Vec3i)expectedConnectionPos)) {
                nextGenerationBox = thisPieceGenerationBox;
                if (thisPieceGenerationBox.getValue() == null) {
                    thisPieceGenerationBox.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)pieceBox)));
                }
            } else {
                nextGenerationBox = generationBox;
            }
            WeightedList weightedPieces = new WeightedList();
            if (this.filter.test(connectorPool)) {
                ((StructureTemplatePool)mainJigsawPattern.get()).f_210559_.forEach(weightedPiece -> weightedPieces.add((StructurePoolElement)weightedPiece.getFirst(), (Integer)weightedPiece.getSecond()));
            }
            if (this.filter.test(fallbackConnectorPool)) {
                ((StructureTemplatePool)fallbackJigsawPattern.get()).f_210559_.forEach(weightedPiece -> weightedPieces.add((StructurePoolElement)weightedPiece.getFirst(), (Integer)weightedPiece.getSecond()));
            }
            while (!weightedPieces.isEmpty() && (nextPiece = (StructurePoolElement)weightedPieces.removeRandom(rand)) != null && nextPiece != EmptyPoolElement.f_210175_) {
                for (Rotation nextPieceRotation : Rotation.m_55958_((Random)rand)) {
                    List nextPieceBlocks;
                    Iterator iterator2 = templateLoadLock;
                    synchronized (iterator2) {
                        nextPieceBlocks = nextPiece.m_207245_(templateMgr, BlockPos.f_121853_, nextPieceRotation, rand);
                    }
                    for (StructureTemplate.StructureBlockInfo nextPieceBlockInfo : nextPieceBlocks) {
                        if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)blockInfo, (StructureTemplate.StructureBlockInfo)nextPieceBlockInfo)) continue;
                        BlockPos nextPiecePos = nextPieceBlockInfo.f_74675_;
                        BlockPos pieceDiff = new BlockPos(expectedConnectionPos.m_123341_() - nextPiecePos.m_123341_(), expectedConnectionPos.m_123342_() - nextPiecePos.m_123342_(), expectedConnectionPos.m_123343_() - nextPiecePos.m_123343_());
                        BoundingBox nextPieceBox = nextPiece.m_207470_(templateMgr, pieceDiff, nextPieceRotation);
                        boolean isNextPieceRigid = nextPiece.m_210539_() == StructureTemplatePool.Projection.RIGID;
                        int nextY = nextPiecePos.m_123342_();
                        int l1 = jigsawYPos - nextY + JigsawBlock.m_54250_((BlockState)nextPieceBlockInfo.f_74676_).m_122430_();
                        if (!VaultPiece.shouldIgnoreCollision(nextPiece) && Shapes.m_83157_((VoxelShape)((VoxelShape)nextGenerationBox.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)nextPieceBox).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                        nextGenerationBox.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)nextGenerationBox.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)nextPieceBox)), (BooleanOp)BooleanOp.f_82685_));
                        int l2 = isNextPieceRigid ? piece.m_72647_() - l1 : nextPiece.m_210540_();
                        PoolElementStructurePiece nextPieceVillagePiece = new PoolElementStructurePiece(templateMgr, nextPiece, pieceDiff, l2, nextPieceRotation, nextPieceBox);
                        resolvedPieces.add(nextPieceVillagePiece);
                        generationEntries.add(new Entry(nextPieceVillagePiece, nextGenerationBox));
                        continue block6;
                    }
                }
            }
        }
    }

    static final class Entry {
        private final PoolElementStructurePiece villagePiece;
        private final MutableObject<VoxelShape> generationBox;

        private Entry(PoolElementStructurePiece piece, MutableObject<VoxelShape> generationBox) {
            this.villagePiece = piece;
            this.generationBox = generationBox;
        }
    }
}

