/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.gen.structure;

import iskallia.vault.world.gen.structure.JigsawPieceResolver;
import iskallia.vault.world.gen.structure.pool.PalettedListPoolElement;
import iskallia.vault.world.gen.structure.pool.PalettedSinglePoolElement;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class JigsawPiecePlacer {
    private static final Random rand = new Random();
    public static int generationPlacementCount = 0;
    private final ServerLevel world;
    private final JigsawPieceResolver resolver;
    private final StructureManager templateManager;
    private final StructureFeatureManager structureManager;
    private final ChunkGenerator chunkGenerator;
    private final Registry<StructureTemplatePool> jigsawPatternRegistry;

    private JigsawPiecePlacer(StructurePoolElement piece, ServerLevel world, BlockPos pos) {
        this.world = world;
        this.resolver = JigsawPieceResolver.newResolver(piece, pos);
        this.templateManager = world.m_8875_();
        this.structureManager = world.m_8595_();
        this.chunkGenerator = world.m_7726_().m_8481_();
        this.jigsawPatternRegistry = world.m_142572_().m_206579_().m_175515_(Registry.f_122884_);
    }

    public static JigsawPiecePlacer newPlacer(StructurePoolElement piece, ServerLevel world, BlockPos pos) {
        return new JigsawPiecePlacer(piece, world, pos);
    }

    public JigsawPiecePlacer withRotation(Rotation rotation) {
        this.resolver.withRotation(rotation);
        return this;
    }

    public JigsawPiecePlacer andJigsawFilter(Predicate<ResourceLocation> filter) {
        this.resolver.andJigsawFilter(filter);
        return this;
    }

    public List<VaultPiece> placeJigsaw() {
        List<PoolElementStructurePiece> resolvedPieces = this.resolver.resolveJigsawPieces(this.templateManager, this.jigsawPatternRegistry);
        resolvedPieces.forEach(this::placeStructurePiece);
        return resolvedPieces.stream().flatMap(piece -> VaultPiece.of((StructurePiece)piece).stream()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void placeStructurePiece(PoolElementStructurePiece structurePiece) {
        BoundingBox structureBox = structurePiece.m_73547_();
        BlockPos center = structureBox.m_162394_();
        BlockPos generationPos = new BlockPos(center.m_123341_(), structureBox.m_162396_(), center.m_123343_());
        StructurePoolElement toGenerate = structurePiece.m_209918_();
        try {
            ++generationPlacementCount;
            this.placeJigsawPiece(toGenerate, structurePiece.m_72646_(), generationPos, structurePiece.m_6830_(), structureBox);
        }
        finally {
            --generationPlacementCount;
        }
    }

    private void placeJigsawPiece(StructurePoolElement jigsawPiece, BlockPos seedPos, BlockPos generationPos, Rotation pieceRotation, BoundingBox pieceBox) {
        if (jigsawPiece instanceof PalettedListPoolElement) {
            ((PalettedListPoolElement)jigsawPiece).generate(this.templateManager, (WorldGenLevel)this.world, this.structureManager, this.chunkGenerator, seedPos, generationPos, pieceRotation, pieceBox, rand, false, 18);
        } else if (jigsawPiece instanceof PalettedSinglePoolElement) {
            ((PalettedSinglePoolElement)jigsawPiece).generate(null, this.templateManager, (WorldGenLevel)this.world, this.structureManager, this.chunkGenerator, seedPos, generationPos, pieceRotation, pieceBox, rand, false, 18);
        } else {
            jigsawPiece.m_207251_(this.templateManager, (WorldGenLevel)this.world, this.structureManager, this.chunkGenerator, seedPos, generationPos, pieceRotation, pieceBox, rand, false);
        }
    }

    public static boolean isPlacingRoom() {
        return generationPlacementCount > 0;
    }
}

