/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.gen.structure;

import com.google.common.collect.Queues;
import iskallia.vault.VaultMod;
import iskallia.vault.mixin.AccessorStructureTemplatePool;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.world.gen.VaultJigsawGenerator;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class JigsawGenerator
implements VaultJigsawGenerator {
    private final BoundingBox box;
    private final BlockPos startPos;
    private final int depth;
    private List<StructurePiece> pieceList = new ArrayList<StructurePiece>();

    public JigsawGenerator(BoundingBox box, BlockPos pos, int depth) {
        this.box = box;
        this.startPos = pos;
        this.depth = depth;
    }

    @Override
    public BlockPos getStartPos() {
        return this.startPos;
    }

    @Override
    public BoundingBox getStructureBox() {
        return this.box;
    }

    @Override
    public int getSize() {
        return this.depth;
    }

    @Override
    public List<StructurePiece> getGeneratedPieces() {
        return this.pieceList;
    }

    public void setPieceList(List<StructurePiece> pieceList) {
        this.pieceList = pieceList;
    }

    public static Builder builder(BoundingBox box, BlockPos pos) {
        return new Builder(box, pos);
    }

    @Override
    public void generate(RegistryAccess registries, PieceGeneratorSupplier.Context<JigsawConfiguration> config, JigsawPlacement.PieceFactory pieceFactory, ChunkGenerator gen, StructureManager manager, List<StructurePiece> pieceList, Random random, boolean flag1, boolean flag2) {
        int depth;
        StructureFeature.m_67096_();
        Registry registry = registries.m_175515_(Registry.f_122884_);
        Rotation rotation = Rotation.m_55956_((Random)random);
        StructureTemplatePool pattern = (StructureTemplatePool)((JigsawConfiguration)config.f_197356_()).m_204802_().m_203334_();
        StructurePoolElement startJigsaw = pattern.m_210585_(random);
        PoolElementStructurePiece startPiece = pieceFactory.m_210300_(manager, startJigsaw, this.getStartPos(), startJigsaw.m_210540_(), rotation, startJigsaw.m_207470_(manager, this.getStartPos(), rotation));
        BoundingBox startBox = startPiece.m_73547_();
        int centerX = (startBox.m_162399_() + startBox.m_162395_()) / 2;
        int centerZ = (startBox.m_162401_() + startBox.m_162398_()) / 2;
        LevelHeightAccessor heightAccessor = config.f_197357_();
        int centerY = flag2 ? this.getStartPos().m_123342_() + gen.m_156174_(centerX, centerZ, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor) : this.getStartPos().m_123342_();
        int offset = startBox.m_162396_() + startPiece.m_72647_();
        startPiece.m_6324_(0, centerY - offset, 0);
        pieceList.add((StructurePiece)startPiece);
        int n = depth = this.getSize() == -1 ? ((JigsawConfiguration)config.f_197356_()).m_67765_() : this.getSize();
        if (depth > 0) {
            AABB boundingBox = new AABB((double)this.getStructureBox().m_162395_(), (double)this.getStructureBox().m_162396_(), (double)this.getStructureBox().m_162398_(), (double)this.getStructureBox().m_162399_(), (double)this.getStructureBox().m_162400_(), (double)this.getStructureBox().m_162401_());
            MutableObject mutableBox = new MutableObject((Object)Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)boundingBox), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)startBox)), (BooleanOp)BooleanOp.f_82685_));
            Assembler assembler = new Assembler((Registry<StructureTemplatePool>)registry, depth, pieceFactory, gen, manager, pieceList, random);
            assembler.availablePieces.addLast(new Entry(startPiece, (MutableObject<VoxelShape>)mutableBox, this.getStructureBox().m_162400_(), 0));
            while (!assembler.availablePieces.isEmpty()) {
                Entry entry = assembler.availablePieces.removeFirst();
                assembler.generate(entry.villagePiece, entry.free, entry.boundsTop, entry.depth, flag1, heightAccessor);
            }
        }
        this.pieceList = pieceList;
    }

    public static class Builder {
        private final BoundingBox box;
        private final BlockPos startPos;
        private int depth = -1;

        protected Builder(BoundingBox box, BlockPos startPos) {
            this.box = box;
            this.startPos = startPos;
        }

        public Builder setDepth(int depth) {
            this.depth = depth;
            return this;
        }

        public JigsawGenerator build() {
            return new JigsawGenerator(this.box, this.startPos, this.depth);
        }
    }

    static final class Assembler {
        private final Registry<StructureTemplatePool> registry;
        private final int maxDepth;
        private final JigsawPlacement.PieceFactory pieceFactory;
        private final ChunkGenerator chunkGenerator;
        private final StructureManager templateManager;
        private final List<? super PoolElementStructurePiece> structurePieces;
        private final Random rand;
        private final Deque<Entry> availablePieces = Queues.newArrayDeque();

        private Assembler(Registry<StructureTemplatePool> registry, int maxDepth, JigsawPlacement.PieceFactory pieceFactory, ChunkGenerator chunkGenerator, StructureManager templateManager, List<? super PoolElementStructurePiece> structurePieces, Random rand) {
            this.registry = registry;
            this.maxDepth = maxDepth;
            this.pieceFactory = pieceFactory;
            this.chunkGenerator = chunkGenerator;
            this.templateManager = templateManager;
            this.structurePieces = structurePieces;
            this.rand = rand;
        }

        private void generate(PoolElementStructurePiece piece, MutableObject<VoxelShape> shape, int p_236831_3_, int currentDepth, boolean p_236831_5_, LevelHeightAccessor heightAccessor) {
            StructurePoolElement jigsawpiece = piece.m_209918_();
            BlockPos blockpos = piece.m_72646_();
            Rotation rotation = piece.m_6830_();
            StructureTemplatePool.Projection jigsawpattern$placementbehaviour = jigsawpiece.m_210539_();
            boolean flag = jigsawpattern$placementbehaviour == StructureTemplatePool.Projection.RIGID;
            MutableObject<VoxelShape> mutableobject = new MutableObject<VoxelShape>();
            BoundingBox mutableboundingbox = piece.m_73547_();
            int i = mutableboundingbox.m_162396_();
            block0: for (StructureTemplate.StructureBlockInfo template$blockinfo : jigsawpiece.m_207245_(this.templateManager, blockpos, rotation, this.rand)) {
                Direction direction = JigsawBlock.m_54250_((BlockState)template$blockinfo.f_74676_);
                BlockPos blockpos1 = template$blockinfo.f_74675_;
                BlockPos blockpos2 = blockpos1.m_142300_(direction);
                int j = blockpos1.m_123342_() - i;
                int k = -1;
                ResourceLocation resourcelocation = new ResourceLocation(template$blockinfo.f_74677_.m_128461_("pool"));
                Optional mainJigsawPattern = this.registry.m_6612_(resourcelocation);
                if (mainJigsawPattern.isPresent() && (((StructureTemplatePool)mainJigsawPattern.get()).m_210590_() != 0 || Objects.equals(resourcelocation, Pools.f_127186_.m_135782_()))) {
                    ResourceLocation resourcelocation1 = ((StructureTemplatePool)mainJigsawPattern.get()).m_210573_();
                    Optional fallbackJigsawPattern = this.registry.m_6612_(resourcelocation1);
                    if (fallbackJigsawPattern.isPresent() && (((StructureTemplatePool)fallbackJigsawPattern.get()).m_210590_() != 0 || Objects.equals(resourcelocation1, Pools.f_127186_.m_135782_()))) {
                        StructurePoolElement jigsawpiece1;
                        int l;
                        MutableObject<VoxelShape> mutableobject1;
                        boolean flag1 = mutableboundingbox.m_71051_((Vec3i)blockpos2);
                        if (flag1) {
                            mutableobject1 = mutableobject;
                            l = i;
                            if (mutableobject.getValue() == null) {
                                mutableobject.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)mutableboundingbox)));
                            }
                        } else {
                            mutableobject1 = shape;
                            l = p_236831_3_;
                        }
                        WeightedList weightedPieces = new WeightedList();
                        if (currentDepth != this.maxDepth) {
                            ((AccessorStructureTemplatePool)mainJigsawPattern.get()).getRawTemplates().forEach(weightedPiece -> weightedPieces.add((StructurePoolElement)weightedPiece.getFirst(), (Integer)weightedPiece.getSecond()));
                            ((AccessorStructureTemplatePool)fallbackJigsawPattern.get()).getRawTemplates().forEach(weightedPiece -> weightedPieces.add((StructurePoolElement)weightedPiece.getFirst(), (Integer)weightedPiece.getSecond()));
                        } else {
                            ((AccessorStructureTemplatePool)fallbackJigsawPattern.get()).getRawTemplates().forEach(weightedPiece -> weightedPieces.add((StructurePoolElement)weightedPiece.getFirst(), (Integer)weightedPiece.getSecond()));
                        }
                        while (!weightedPieces.isEmpty() && (jigsawpiece1 = (StructurePoolElement)weightedPieces.removeRandom(this.rand)) != null && jigsawpiece1 != EmptyPoolElement.f_210175_) {
                            for (Rotation rotation1 : Rotation.m_55958_((Random)this.rand)) {
                                List list1 = jigsawpiece1.m_207245_(this.templateManager, BlockPos.f_121853_, rotation1, this.rand);
                                BoundingBox mutableboundingbox1 = jigsawpiece1.m_207470_(this.templateManager, BlockPos.f_121853_, rotation1);
                                int i1 = p_236831_5_ && mutableboundingbox1.m_71057_() <= 16 ? list1.stream().mapToInt(p_242841_2_ -> {
                                    if (!mutableboundingbox1.m_71051_((Vec3i)p_242841_2_.f_74675_.m_142300_(JigsawBlock.m_54250_((BlockState)p_242841_2_.f_74676_)))) {
                                        return 0;
                                    }
                                    ResourceLocation resourcelocation2 = new ResourceLocation(p_242841_2_.f_74677_.m_128461_("pool"));
                                    Optional optional2 = this.registry.m_6612_(resourcelocation2);
                                    Optional<Integer> optional3 = optional2.flatMap(p_242843_1_ -> this.registry.m_6612_(p_242843_1_.m_210573_()));
                                    int k3 = optional2.map(p_242842_1_ -> p_242842_1_.m_210580_(this.templateManager)).orElse(0);
                                    int l3 = optional3.map(p_242840_1_ -> p_242840_1_.m_210580_(this.templateManager)).orElse(0);
                                    return Math.max(k3, l3);
                                }).max().orElse(0) : 0;
                                for (StructureTemplate.StructureBlockInfo template$blockinfo1 : list1) {
                                    int i3;
                                    int i2;
                                    if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)template$blockinfo, (StructureTemplate.StructureBlockInfo)template$blockinfo1)) continue;
                                    BlockPos blockpos3 = template$blockinfo1.f_74675_;
                                    BlockPos blockpos4 = new BlockPos(blockpos2.m_123341_() - blockpos3.m_123341_(), blockpos2.m_123342_() - blockpos3.m_123342_(), blockpos2.m_123343_() - blockpos3.m_123343_());
                                    BoundingBox mutableboundingbox2 = jigsawpiece1.m_207470_(this.templateManager, blockpos4, rotation1);
                                    int j1 = mutableboundingbox2.m_162396_();
                                    StructureTemplatePool.Projection jigsawpattern$placementbehaviour1 = jigsawpiece1.m_210539_();
                                    boolean flag2 = jigsawpattern$placementbehaviour1 == StructureTemplatePool.Projection.RIGID;
                                    int k1 = blockpos3.m_123342_();
                                    int l1 = j - k1 + JigsawBlock.m_54250_((BlockState)template$blockinfo.f_74676_).m_122430_();
                                    if (flag && flag2) {
                                        i2 = i + l1;
                                    } else {
                                        if (k == -1) {
                                            k = this.chunkGenerator.m_156174_(blockpos1.m_123341_(), blockpos1.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
                                        }
                                        i2 = k - k1;
                                    }
                                    int j2 = i2 - j1;
                                    BoundingBox mutableboundingbox3 = mutableboundingbox2.m_71045_(0, j2, 0);
                                    BlockPos blockpos5 = blockpos4.m_142082_(0, j2, 0);
                                    if (i1 > 0) {
                                        int k2 = Math.max(i1 + 1, mutableboundingbox3.m_162400_() - mutableboundingbox3.m_162396_());
                                        mutableboundingbox3.m_162371_(new BlockPos(mutableboundingbox3.m_162395_(), mutableboundingbox3.m_162396_() + k2, mutableboundingbox3.m_162398_()));
                                    }
                                    if (Shapes.m_83157_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)mutableboundingbox3).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                                    mutableobject1.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableobject1.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)mutableboundingbox3)), (BooleanOp)BooleanOp.f_82685_));
                                    int j3 = piece.m_72647_();
                                    int l2 = flag2 ? j3 - l1 : jigsawpiece1.m_210540_();
                                    PoolElementStructurePiece abstractvillagepiece = this.pieceFactory.m_210300_(this.templateManager, jigsawpiece1, blockpos5, l2, rotation1, mutableboundingbox3);
                                    if (flag) {
                                        i3 = i + j;
                                    } else if (flag2) {
                                        i3 = i2 + k1;
                                    } else {
                                        if (k == -1) {
                                            k = this.chunkGenerator.m_156174_(blockpos1.m_123341_(), blockpos1.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
                                        }
                                        i3 = k + l1 / 2;
                                    }
                                    piece.m_209916_(new JigsawJunction(blockpos2.m_123341_(), i3 - j + j3, blockpos2.m_123343_(), l1, jigsawpattern$placementbehaviour1));
                                    abstractvillagepiece.m_209916_(new JigsawJunction(blockpos1.m_123341_(), i3 - k1 + l2, blockpos1.m_123343_(), -l1, jigsawpattern$placementbehaviour));
                                    if (abstractvillagepiece.m_73547_().m_162396_() <= 0 || abstractvillagepiece.m_73547_().m_162400_() >= 256) continue block0;
                                    this.structurePieces.add((PoolElementStructurePiece)abstractvillagepiece);
                                    if (currentDepth + 1 > this.maxDepth) continue block0;
                                    this.availablePieces.addLast(new Entry(abstractvillagepiece, mutableobject1, l, currentDepth + 1));
                                    continue block0;
                                }
                            }
                        }
                        continue;
                    }
                    VaultMod.LOGGER.warn("Empty or none existent fallback pool: {}", (Object)resourcelocation1);
                    continue;
                }
                VaultMod.LOGGER.warn("Empty or none existent pool: {}", (Object)resourcelocation);
            }
        }
    }

    static final class Entry {
        private final PoolElementStructurePiece villagePiece;
        private final MutableObject<VoxelShape> free;
        private final int boundsTop;
        private final int depth;

        private Entry(PoolElementStructurePiece p_i232042_1_, MutableObject<VoxelShape> p_i232042_2_, int p_i232042_3_, int p_i232042_4_) {
            this.villagePiece = p_i232042_1_;
            this.free = p_i232042_2_;
            this.boundsTop = p_i232042_3_;
            this.depth = p_i232042_4_;
        }
    }
}

