/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.gen.decorator;

import com.mojang.serialization.Codec;
import iskallia.vault.VaultMod;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.PlayerFilter;
import iskallia.vault.world.gen.structure.JigsawPiecePlacer;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.gen.piece.VaultPiece;
import iskallia.vault.world.vault.logic.objective.LegacyScavengerHuntObjective;
import iskallia.vault.world.vault.logic.objective.TreasureHuntObjective;
import iskallia.vault.world.vault.modifier.modifier.DecoratorAddModifier;
import iskallia.vault.world.vault.player.VaultPlayer;
import iskallia.vault.world.vault.player.VaultRunner;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.event.RegistryEvent;

public class BreadcrumbFeature
extends Feature<NoneFeatureConfiguration> {
    public static Feature<NoneFeatureConfiguration> INSTANCE;

    public BreadcrumbFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        BlockPos pos = context.m_159777_();
        Random rand = context.m_159776_();
        return false;
    }

    public static void generateVaultBreadcrumb(VaultRaid vault, ServerLevel sWorld, List<VaultPiece> pieces) {
        BreadcrumbFeature.runGeneration(() -> {
            Predicate<BlockPos> filter = pos -> false;
            HashSet<ChunkPos> chunks = new HashSet<ChunkPos>();
            for (VaultPiece piece : pieces) {
                BoundingBox box = piece.getBoundingBox();
                filter = filter.or(arg_0 -> ((BoundingBox)box).m_71051_(arg_0));
                ChunkPos chMin = new ChunkPos(box.m_162395_() >> 4, box.m_162398_() >> 4);
                ChunkPos chMax = new ChunkPos(box.m_162399_() >> 4, box.m_162401_() >> 4);
                for (int x = chMin.f_45578_; x <= chMax.f_45578_; ++x) {
                    for (int z = chMin.f_45579_; z <= chMax.f_45579_; ++z) {
                        chunks.add(new ChunkPos(x, z));
                    }
                }
            }
            Predicate<BlockPos> featurePlacementFilter = filter;
            for (ChunkPos pos2 : chunks) {
                BlockPos featurePos = pos2.m_45615_();
                BreadcrumbFeature.placeBreadcrumbFeatures(vault, (WorldGenLevel)sWorld, (at, state) -> {
                    if (featurePlacementFilter.test((BlockPos)at)) {
                        return sWorld.m_7731_(at, state, 2);
                    }
                    return false;
                }, sWorld.m_5822_(), featurePos);
            }
        });
    }

    private static void placeBreadcrumbFeatures(VaultRaid vault, WorldGenLevel world, BiPredicate<BlockPos, BlockState> blockPlacer, Random rand, BlockPos featurePos) {
        vault.getActiveObjective(LegacyScavengerHuntObjective.class).ifPresent(objective -> BreadcrumbFeature.doTreasureSpawnPass(rand, (LevelAccessor)world, blockPlacer, featurePos));
        vault.getActiveObjective(TreasureHuntObjective.class).ifPresent(objective -> BreadcrumbFeature.doTreasureSpawnPass(rand, (LevelAccessor)world, blockPlacer, featurePos));
        BreadcrumbFeature.doChestSpawnPass(rand, (LevelAccessor)world, blockPlacer, featurePos, ModBlocks.WOODEN_CHEST.m_49966_());
        List<VaultPlayer> runners = vault.getPlayers().stream().filter(vaultPlayer -> vaultPlayer instanceof VaultRunner).toList();
        for (int i = 0; i < runners.size() - 1; ++i) {
        }
        BreadcrumbFeature.placeChestModifierFeatures(vault, world, blockPlacer, rand, featurePos);
    }

    private static void placeChestModifierFeatures(VaultRaid vault, WorldGenLevel world, BiPredicate<BlockPos, BlockState> blockPlacer, Random rand, BlockPos featurePos) {
        vault.withActiveModifiersFor(PlayerFilter.any(), DecoratorAddModifier.class, (decoratorAddModifier, stackSize) -> {
            for (int j = 0; j < stackSize; ++j) {
                int attempts = 1;
                for (int i = 0; i < ((DecoratorAddModifier.Properties)decoratorAddModifier.properties()).getAttemptsPerChunk(); ++i) {
                    BreadcrumbFeature.doChestSpawnPass(rand, (LevelAccessor)world, blockPlacer, featurePos, ModBlocks.GILDED_CHEST.m_49966_(), attempts);
                }
            }
        });
    }

    private static void doTreasureSpawnPass(Random rand, LevelAccessor world, BiPredicate<BlockPos, BlockState> blockPlacer, BlockPos pos) {
        BreadcrumbFeature.doPlacementPass(rand, world, blockPlacer, pos, ModBlocks.SCAVENGER_TREASURE.m_49966_(), 45, offset -> {});
    }

    private static void doChestSpawnPass(Random rand, LevelAccessor world, BiPredicate<BlockPos, BlockState> blockPlacer, BlockPos pos, BlockState toPlace) {
        BreadcrumbFeature.doChestSpawnPass(rand, world, blockPlacer, pos, toPlace, 12);
    }

    private static void doChestSpawnPass(Random rand, LevelAccessor world, BiPredicate<BlockPos, BlockState> blockPlacer, BlockPos pos, BlockState toPlace, int attempts) {
        BreadcrumbFeature.doPlacementPass(rand, world, blockPlacer, pos, toPlace, attempts, offset -> {});
    }

    private static void doPlacementPass(Random rand, LevelAccessor world, BiPredicate<BlockPos, BlockState> blockPlacer, BlockPos pos, BlockState toPlace, int attempts, Consumer<BlockPos> pass) {
        for (int i = 0; i < attempts; ++i) {
            int x = rand.nextInt(16);
            int z = rand.nextInt(16);
            int y = rand.nextInt(64);
            BlockPos offset = pos.m_142082_(x, y, z);
            BlockState state = world.m_8055_(offset);
            if (state.m_60734_() != Blocks.f_50016_ || !world.m_8055_(offset.m_7495_()).m_60783_((BlockGetter)world, offset, Direction.UP) || !blockPlacer.test(offset, toPlace)) continue;
            pass.accept(offset);
        }
    }

    private static void runGeneration(Runnable run) {
        ++JigsawPiecePlacer.generationPlacementCount;
        try {
            run.run();
        }
        finally {
            --JigsawPiecePlacer.generationPlacementCount;
        }
    }

    public static void register(RegistryEvent.Register<Feature<?>> event) {
        INSTANCE = new BreadcrumbFeature((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
        INSTANCE.setRegistryName(VaultMod.id("breadcrumb_chest"));
        event.getRegistry().register(INSTANCE);
    }
}

