/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.gen;

import iskallia.vault.world.gen.BlockPlacer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class PortalPlacer {
    private final BlockPlacer portalPlacer;
    private final BlockPlacer framePlacer;

    public PortalPlacer(BlockPlacer portal, BlockPlacer frame) {
        this.portalPlacer = portal;
        this.framePlacer = frame;
    }

    public List<BlockPos> place(LevelAccessor world, BlockPos pos, Direction facing, int width, int height) {
        pos = pos.m_142300_(Direction.DOWN).m_142300_(facing.m_122424_());
        ArrayList<BlockPos> portalPlacements = new ArrayList<BlockPos>();
        for (int y = 0; y < height + 2; ++y) {
            this.place(world, pos.m_6630_(y), facing, this.framePlacer);
            this.place(world, pos.m_5484_(facing, width + 1).m_6630_(y), facing, this.framePlacer);
            for (int x = 1; x < width + 1; ++x) {
                if (y == 0 || y == height + 1) {
                    this.place(world, pos.m_5484_(facing, x).m_6630_(y), facing, this.framePlacer);
                    continue;
                }
                BlockPos placePos = pos.m_5484_(facing, x).m_6630_(y);
                if (!this.place(world, placePos, facing, this.portalPlacer)) continue;
                portalPlacements.add(placePos);
            }
        }
        return portalPlacements;
    }

    protected boolean place(LevelAccessor world, BlockPos pos, Direction direction, BlockPlacer provider) {
        return this.place(world, pos, provider.getState(pos, world.m_5822_(), direction));
    }

    protected boolean place(LevelAccessor world, BlockPos pos, BlockState state) {
        if (state != null) {
            return world.m_7731_(pos, state, 3);
        }
        return false;
    }
}

