/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.gen;

import iskallia.vault.world.gen.VaultJigsawGenerator;
import iskallia.vault.world.gen.structure.JigsawPieceResolver;
import iskallia.vault.world.vault.gen.layout.JigsawPoolProvider;
import iskallia.vault.world.vault.gen.layout.VaultRoomLayoutGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.phys.AABB;

public class FragmentedJigsawGenerator
implements VaultJigsawGenerator {
    public static final int START_X_Z = 21;
    public static final int ROOM_X_Z = 47;
    public static final int ROOM_Y_OFFSET = -13;
    public static final int TUNNEL_Z = 48;
    public static final int TUNNEL_X = 11;
    public static final int TUNNEL_Y_OFFSET = 6;
    private final BoundingBox structureBoundingBox;
    private final BlockPos startPos;
    private final boolean generateTreasureRooms;
    private final JigsawPoolProvider jigsawPoolProvider;
    private final VaultRoomLayoutGenerator.Layout generatedLayout;
    private List<StructurePiece> pieces = new ArrayList<StructurePiece>();

    public FragmentedJigsawGenerator(BoundingBox structureBoundingBox, BlockPos startPos, boolean generateTreasureRooms, JigsawPoolProvider jigsawPoolProvider, VaultRoomLayoutGenerator.Layout generatedLayout) {
        this.structureBoundingBox = structureBoundingBox;
        this.startPos = startPos;
        this.generateTreasureRooms = generateTreasureRooms;
        this.jigsawPoolProvider = jigsawPoolProvider;
        this.generatedLayout = generatedLayout;
    }

    @Override
    public BoundingBox getStructureBox() {
        return this.structureBoundingBox;
    }

    @Override
    public BlockPos getStartPos() {
        return this.startPos;
    }

    public boolean generatesTreasureRooms() {
        return this.generateTreasureRooms;
    }

    @Override
    public int getSize() {
        return 0;
    }

    public JigsawPoolProvider getJigsawPoolProvider() {
        return this.jigsawPoolProvider;
    }

    @Override
    public List<StructurePiece> getGeneratedPieces() {
        return Collections.unmodifiableList(this.pieces);
    }

    public boolean removePiece(StructurePiece piece) {
        return this.pieces.remove(piece);
    }

    @Override
    public void generate(RegistryAccess registries, PieceGeneratorSupplier.Context<JigsawConfiguration> config, JigsawPlacement.PieceFactory pieceFactory, ChunkGenerator gen, StructureManager manager, List<StructurePiece> pieceList, Random random, boolean flag1, boolean generateOnSurface) {
        BlockPos startPos = this.getStartPos();
        Registry registry = registries.m_175515_(Registry.f_122884_);
        Rotation startRotation = Rotation.m_55956_((Random)random);
        Rotation vaultGenerationRotation = startRotation.m_55952_(Rotation.CLOCKWISE_90);
        StructureTemplatePool starts = this.getJigsawPoolProvider().getStartRoomPool((Registry<StructureTemplatePool>)registry);
        StructurePoolElement startPiece = starts.m_210585_(random);
        BoundingBox startBoundingBox = startPiece.m_207470_(manager, startPos, startRotation);
        PoolElementStructurePiece start = pieceFactory.m_210300_(manager, startPiece, startPos, startPiece.m_210540_(), startRotation, startBoundingBox);
        pieceList.add((StructurePiece)start);
        BlockPos centerRoomPos = startPos.m_141952_((Vec3i)new BlockPos(10, 0, 10).m_7954_(startRotation)).m_5484_(vaultGenerationRotation.m_55954_(Direction.EAST), 11).m_5484_(vaultGenerationRotation.m_55954_(Direction.EAST), 23);
        List<StructurePiece> synchronizedPieces = Collections.synchronizedList(pieceList);
        StructureTemplatePool rooms = this.getJigsawPoolProvider().getRoomPool((Registry<StructureTemplatePool>)registry);
        this.generatedLayout.getRooms().parallelStream().forEach(room -> {
            StructurePoolElement roomPiece = room.getRandomPiece(rooms, random);
            Rotation roomRotation = Rotation.m_55956_((Random)random);
            BlockPos roomPos = centerRoomPos.m_141952_((Vec3i)room.getAbsoluteOffset(vaultGenerationRotation, roomRotation));
            JigsawPieceResolver resolver = JigsawPieceResolver.newResolver(roomPiece, roomPos).withRotation(roomRotation).andJigsawFilter(key -> !key.m_135815_().contains("tunnels"));
            if (room.getRoomOffset().equals((Object)BlockPos.f_121853_)) {
                resolver.addStructureBox(AABB.m_82321_((BoundingBox)startBoundingBox).m_82377_(1.0, 3.0, 1.0));
            }
            if (!this.generatesTreasureRooms() || !room.canGenerateTreasureRooms()) {
                resolver.andJigsawFilter(key -> !key.m_135815_().contains("treasure_rooms"));
            }
            synchronizedPieces.addAll(resolver.resolveJigsawPieces(manager, (Registry<StructureTemplatePool>)registry));
        });
        StructureTemplatePool tunnels = this.getJigsawPoolProvider().getTunnelPool((Registry<StructureTemplatePool>)registry);
        for (VaultRoomLayoutGenerator.Tunnel tunnel : this.generatedLayout.getTunnels()) {
            StructurePoolElement tunnelPiece = tunnel.getRandomPiece(tunnels, random);
            Rotation tunnelRotation = tunnel.getRandomConnectingRotation(random).m_55952_(vaultGenerationRotation);
            BlockPos tunnelPos = centerRoomPos.m_141952_((Vec3i)tunnel.getAbsoluteOffset(vaultGenerationRotation, tunnelRotation));
            JigsawPieceResolver resolver = JigsawPieceResolver.newResolver(tunnelPiece, tunnelPos).withRotation(tunnelRotation).andJigsawFilter(key -> !key.m_135815_().contains("rooms"));
            pieceList.addAll(resolver.resolveJigsawPieces(manager, (Registry<StructureTemplatePool>)registry));
        }
        this.pieces = pieceList;
    }
}

