/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.stat.VaultSnapshot;
import iskallia.vault.nbt.VListNBT;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class VaultSnapshots
extends SavedData {
    protected static final String DATA_NAME = "the_vault_VaultSnapshots";
    private final VListNBT<VaultSnapshot, LongArrayTag> snapshots = new VListNBT<VaultSnapshot, LongArrayTag>(new ArrayList(), snapshot -> {
        ArrayBitBuffer buffer = ArrayBitBuffer.empty();
        snapshot.write(buffer);
        return new LongArrayTag(buffer.toLongArray());
    }, nbt -> new VaultSnapshot(ArrayBitBuffer.backing(nbt.m_128851_(), 0)));

    public static VaultSnapshot get(UUID vaultId) {
        VListNBT<VaultSnapshot, LongArrayTag> snapshots = VaultSnapshots.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).snapshots;
        for (VaultSnapshot snapshot : snapshots) {
            if (!snapshot.getStart().get(Vault.ID).equals(vaultId)) continue;
            return snapshot;
        }
        return null;
    }

    public static List<VaultSnapshot> getAll() {
        return VaultSnapshots.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).snapshots;
    }

    public static void onVaultStarted(Vault vault) {
        VaultSnapshots.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).snapshots.add(new VaultSnapshot(vault.get(Vault.VERSION)).setStart(vault));
        VaultSnapshots.get(ServerLifecycleHooks.getCurrentServer()).m_77762_();
    }

    public static void onVaultEnded(Vault vault) {
        VListNBT<VaultSnapshot, LongArrayTag> snapshots = VaultSnapshots.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).snapshots;
        for (int i = snapshots.size() - 1; i >= 0; --i) {
            VaultSnapshot snapshot = (VaultSnapshot)snapshots.get(i);
            if (!snapshot.matches(vault)) continue;
            snapshot.setEnd(vault);
            break;
        }
        VaultSnapshots.get(ServerLifecycleHooks.getCurrentServer()).m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("snapshots", (Tag)this.snapshots.serializeNBT());
        return nbt;
    }

    public void load(CompoundTag nbt) {
        this.snapshots.deserializeNBT(nbt.m_128437_("snapshots", 12));
    }

    public static VaultSnapshots get(MinecraftServer server) {
        return (VaultSnapshots)server.m_129783_().m_8895_().m_164861_(VaultSnapshots::create, VaultSnapshots::new, DATA_NAME);
    }

    private static VaultSnapshots create(CompoundTag tag) {
        VaultSnapshots data = new VaultSnapshots();
        data.load(tag);
        return data;
    }
}

