/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.backup.BackupManager;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.nbt.VMapNBT;
import iskallia.vault.world.data.PlayerStatsData;
import iskallia.vault.world.vault.VaultRaid;
import iskallia.vault.world.vault.player.VaultMember;
import iskallia.vault.world.vault.player.VaultPlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.LogicalSide;

public class VaultRaidData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_VaultRaid";
    private VListNBT<VaultRaid, CompoundTag> vaults = VListNBT.of(VaultRaid::new);
    private BlockPos.MutableBlockPos nextVaultPos = BlockPos.f_121853_.m_122032_();
    @Deprecated
    private VMapNBT<UUID, VaultRaid> activeVaults = VMapNBT.ofUUID(VaultRaid::new);

    public VaultRaid get(UUID vaultId) {
        return this.vaults.stream().filter(vault -> vaultId.equals(vault.getProperties().getBaseOrDefault(VaultRaid.IDENTIFIER, (UUID)null))).findFirst().orElse(null);
    }

    public VaultRaid getActiveFor(ServerPlayer player) {
        return this.getActiveFor(player.m_142081_());
    }

    public VaultRaid getActiveFor(UUID playerId) {
        return this.vaults.stream().filter(vault -> vault.getPlayer(playerId).isPresent()).findFirst().orElse(null);
    }

    @Nullable
    public VaultRaid getAt(ServerLevel world, BlockPos pos) {
        return this.vaults.stream().filter(vault -> world.m_46472_() == vault.getProperties().getValue(VaultRaid.DIMENSION)).filter(vault -> {
            Optional<BoundingBox> box = vault.getProperties().getBase(VaultRaid.BOUNDING_BOX);
            return box.isPresent() && box.get().m_71051_((Vec3i)pos);
        }).findFirst().orElse(null);
    }

    public void remove(UUID vaultId) {
        this.vaults.removeIf(vault -> vault.getProperties().getValue(VaultRaid.IDENTIFIER).equals(vaultId));
    }

    public void remove(MinecraftServer server, UUID playerId) {
        VaultRaid vault = this.getActiveFor(playerId);
        if (vault == null) {
            return;
        }
        ServerLevel world = server.m_129880_(vault.getProperties().getValue(VaultRaid.DIMENSION));
        vault.getPlayer(playerId).ifPresent(player -> {
            if (player.hasExited() || player instanceof VaultMember) {
                return;
            }
            VaultRaid.REMOVE_SCAVENGER_ITEMS.then(VaultRaid.REMOVE_INVENTORY_RESTORE_SNAPSHOTS).then(VaultRaid.EXIT_SAFELY).execute(vault, (VaultPlayer)player, world);
        });
        PlayerStatsData.get().onVaultFinished(playerId, vault);
    }

    public VaultRaid startVault(ServerLevel world, VaultRaid.Builder builder) {
        return this.startVault(world, builder, vault -> {});
    }

    public VaultRaid startVault(ServerLevel world, VaultRaid.Builder builder, Consumer<VaultRaid> onBuild) {
        MinecraftServer server = world.m_142572_();
        VaultRaid vault = builder.build();
        onBuild.accept(vault);
        builder.getLevelInitializer().executeForAllPlayers(vault, world);
        Optional<ResourceKey<Level>> dimension = vault.getProperties().getBase(VaultRaid.DIMENSION);
        if (dimension.isPresent()) {
            world = server.m_129880_(dimension.get());
        } else {
            vault.getProperties().create(VaultRaid.DIMENSION, world.m_46472_());
        }
        ServerLevel destination = dimension.isPresent() ? server.m_129880_(dimension.get()) : world;
        server.m_18707_(() -> {
            try {
                vault.getGenerator().generate(destination, vault, this.nextVaultPos);
                vault.getPlayers().forEach(player -> {
                    player.runIfPresent(server, sPlayer -> BackupManager.createPlayerInventorySnapshot(sPlayer));
                    this.remove(server, player.getPlayerId());
                    vault.getInitializer().execute(vault, (VaultPlayer)player, destination);
                });
                this.vaults.add(vault);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return vault;
    }

    public void tick(ServerLevel world) {
        new ArrayList(this.vaults).stream().filter(vault -> vault.getProperties().getValue(VaultRaid.DIMENSION) == world.m_46472_()).forEach(vault -> vault.tick(world));
        ArrayList completed = new ArrayList();
        this.vaults.removeIf(vault -> {
            if (vault.isFinished()) {
                vault.getPlayers().forEach(player -> completed.add(player.getPlayerId()));
            }
            return vault.isFinished();
        });
        completed.forEach(uuid -> this.remove(world.m_142572_(), (UUID)uuid));
    }

    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            VaultRaidData.get((ServerLevel)event.world).tick((ServerLevel)event.world);
        }
    }

    public boolean m_77764_() {
        return true;
    }

    private static VaultRaidData create(CompoundTag tag) {
        VaultRaidData data = new VaultRaidData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        HashMap<UUID, VaultRaid> foundVaults = new HashMap<UUID, VaultRaid>();
        ListTag vaults = nbt.m_128437_("ActiveVaults", 10);
        for (int i = 0; i < vaults.size(); ++i) {
            CompoundTag tag = vaults.m_128728_(i);
            UUID playerId = UUID.fromString(tag.m_128461_("Key"));
            VaultRaid vault = new VaultRaid();
            vault.deserializeNBT(tag.m_128469_("Value"));
            UUID vaultId = vault.getProperties().getBaseOrDefault(VaultRaid.IDENTIFIER, Util.f_137441_);
            if (foundVaults.containsKey(vaultId)) {
                vault = (VaultRaid)foundVaults.get(vaultId);
            } else {
                foundVaults.put(vaultId, vault);
            }
            this.activeVaults.put(playerId, vault);
        }
        this.vaults.deserializeNBT(nbt.m_128437_("Vaults", 10));
        this.vaults.addAll(this.activeVaults.values());
        int[] pos = nbt.m_128465_("NextVaultPos");
        this.nextVaultPos = new BlockPos.MutableBlockPos(pos[0], pos[1], pos[2]);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("Vaults", (Tag)this.vaults.serializeNBT());
        nbt.m_128385_("NextVaultPos", new int[]{this.nextVaultPos.m_123341_(), this.nextVaultPos.m_123342_(), this.nextVaultPos.m_123343_()});
        return nbt;
    }

    public static VaultRaidData get(ServerLevel world) {
        return (VaultRaidData)world.m_142572_().m_129783_().m_8895_().m_164861_(VaultRaidData::create, VaultRaidData::new, DATA_NAME);
    }
}

