/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.item.VaultCharmUpgrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;

public class VaultCharmData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_VaultCharm";
    private final HashMap<UUID, VaultCharmInventory> whitelistedItems = new HashMap();

    public void updateWhitelist(ServerPlayer player, List<ResourceLocation> ids) {
        VaultCharmInventory inventory = this.getInventory(player);
        inventory.updateWhitelist(ids);
        this.m_77762_();
    }

    public void upgradeInventorySize(ServerPlayer player, int newSize) {
        this.getInventory(player).setSize(newSize);
        this.m_77762_();
    }

    public List<ResourceLocation> getWhitelistedItems(ServerPlayer player) {
        VaultCharmInventory inventory = this.getInventory(player);
        return inventory.getWhitelist();
    }

    public VaultCharmInventory getInventory(ServerPlayer player) {
        if (this.whitelistedItems.containsKey(player.m_142081_())) {
            return this.whitelistedItems.get(player.m_142081_());
        }
        VaultCharmInventory inventory = new VaultCharmInventory();
        this.whitelistedItems.put(player.m_142081_(), inventory);
        this.m_77762_();
        return inventory;
    }

    private static VaultCharmData create(CompoundTag tag) {
        VaultCharmData data = new VaultCharmData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        for (String key : nbt.m_128431_()) {
            UUID playerId;
            try {
                playerId = UUID.fromString(key);
            }
            catch (IllegalArgumentException exception) {
                continue;
            }
            CompoundTag inventoryNbt = nbt.m_128469_(key);
            VaultCharmInventory inventory = new VaultCharmInventory();
            inventory.deserializeNBT(inventoryNbt);
            this.whitelistedItems.put(playerId, inventory);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        this.whitelistedItems.forEach((uuid, inventory) -> compound.m_128365_(uuid.toString(), (Tag)inventory.serializeNBT()));
        return compound;
    }

    public static VaultCharmData get(ServerLevel world) {
        return (VaultCharmData)world.m_142572_().m_129783_().m_8895_().m_164861_(VaultCharmData::create, VaultCharmData::new, DATA_NAME);
    }

    public static class VaultCharmInventory
    implements INBTSerializable<CompoundTag> {
        private int size;
        private List<ResourceLocation> whitelist = new ArrayList<ResourceLocation>();

        public VaultCharmInventory() {
            this(9);
        }

        public VaultCharmInventory(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public List<ResourceLocation> getWhitelist() {
            return this.whitelist;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            ListTag whitelistNbt = new ListTag();
            this.whitelist.forEach(id -> whitelistNbt.add((Object)StringTag.m_129297_((String)id.toString())));
            nbt.m_128405_("InventorySize", this.size);
            nbt.m_128365_("Whitelist", (Tag)whitelistNbt);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.size = nbt.m_128451_("InventorySize");
            ListTag itemList = nbt.m_128437_("Whitelist", 8);
            for (int i = 0; i < itemList.size(); ++i) {
                this.whitelist.add(new ResourceLocation(itemList.m_128778_(i)));
            }
        }

        private void updateWhitelist(List<ResourceLocation> whitelist) {
            this.whitelist = new ArrayList<ResourceLocation>(whitelist);
        }

        public static VaultCharmInventory fromNbt(CompoundTag nbt) {
            VaultCharmInventory inventory = new VaultCharmInventory();
            inventory.deserializeNBT(nbt);
            return inventory;
        }

        public boolean canUpgrade(int newSize) {
            VaultCharmUpgrade.Tier current = VaultCharmUpgrade.Tier.getTierBySize(this.size);
            System.out.println((Object)current);
            VaultCharmUpgrade.Tier potential = VaultCharmUpgrade.Tier.getTierBySize(newSize);
            System.out.println((Object)potential);
            if (potential == null) {
                return false;
            }
            if (current == null) {
                return potential == VaultCharmUpgrade.Tier.ONE;
            }
            VaultCharmUpgrade.Tier next = current.getNext();
            if (next == null) {
                return false;
            }
            return next == potential;
        }
    }
}

