/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.NetcodeUtils;
import iskallia.vault.util.data.WeightedList;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.ArenaRaidData;
import iskallia.vault.world.legacy.raid.ArenaRaid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;

public class StreamData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_StreamSubs";
    private Map<UUID, Subscribers> subBufferMap = new HashMap<UUID, Subscribers>();
    private Map<UUID, Subscribers> subMap = new HashMap<UUID, Subscribers>();
    private Map<UUID, Donations> donoMap = new HashMap<UUID, Donations>();

    public Subscribers getSubscribers(UUID streamer) {
        return this.subMap.computeIfAbsent(streamer, uuid -> new Subscribers());
    }

    public Donations getDonations(UUID streamer) {
        return this.donoMap.computeIfAbsent(streamer, uuid -> new Donations());
    }

    public StreamData reset(MinecraftServer server, UUID streamer) {
        this.subMap.put(streamer, new Subscribers());
        this.subBufferMap.put(streamer, new Subscribers());
        this.donoMap.put(streamer, new Donations());
        this.m_77762_();
        return this;
    }

    public StreamData resetDonos(MinecraftServer server, UUID streamer) {
        this.donoMap.put(streamer, new Donations());
        this.m_77762_();
        return this;
    }

    public StreamData onSub(MinecraftServer server, UUID streamer, String name, int months) {
        NetcodeUtils.runIfPresent(server, streamer, player -> {
            ArenaRaid activeRaid = ArenaRaidData.get(player.m_183503_()).getActiveFor((ServerPlayer)player);
            if (activeRaid != null) {
                Subscribers subscribers = this.subBufferMap.computeIfAbsent(streamer, uuid -> new Subscribers());
                subscribers.onSub(name, months);
            } else {
                Subscribers subscribers = this.subMap.computeIfAbsent(streamer, uuid -> new Subscribers());
                subscribers.onSub(name, months);
                int maxSubs = ModConfigs.STREAMER_MULTIPLIERS.ofStreamer((String)player.m_5446_().getString()).subsNeededForArena;
                int multiplier = ModConfigs.STREAMER_MULTIPLIERS.ofStreamer((String)player.m_5446_().getString()).subsMultiplier;
                if (subscribers.count() >= maxSubs) {
                    ArenaRaid raid = ArenaRaidData.get(player.m_183503_()).startNew((ServerPlayer)player);
                    for (int i = 0; i < maxSubs; ++i) {
                        Subscribers.Instance sub = subscribers.popOneSub();
                        for (int j = 0; j < multiplier; ++j) {
                            raid.spawner.subscribers.add(sub);
                        }
                    }
                }
            }
            this.m_77762_();
        });
        return this;
    }

    public StreamData onDono(MinecraftServer server, UUID streamer, String donator, int amount) {
        this.getDonations(streamer).onDono(donator, amount);
        this.m_77762_();
        return this;
    }

    public StreamData onArenaLeave(MinecraftServer server, UUID streamer) {
        NetcodeUtils.runIfPresent(server, streamer, player -> {
            Subscribers bufferedSubs = this.subBufferMap.computeIfAbsent(streamer, uuid -> new Subscribers());
            int maxSubs = ModConfigs.STREAMER_MULTIPLIERS.ofStreamer((String)player.m_5446_().getString()).subsNeededForArena;
            int subsToMove = Math.min(bufferedSubs.count(), maxSubs);
            for (int i = 0; i < subsToMove; ++i) {
                Subscribers.Instance e = bufferedSubs.popOneSub();
                this.onSub(server, streamer, e.name, e.months);
            }
            this.m_77762_();
        });
        return this;
    }

    private static StreamData create(CompoundTag tag) {
        StreamData data = new StreamData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.subMap = NBTHelper.readMap(nbt, "StreamSubs", ListTag.class, list -> {
            Subscribers subs = new Subscribers();
            subs.deserializeNBT((ListTag)list);
            return subs;
        });
        this.subBufferMap = NBTHelper.readMap(nbt, "StreamSubsBuffer", ListTag.class, list -> {
            Subscribers subs = new Subscribers();
            subs.deserializeNBT((ListTag)list);
            return subs;
        });
        this.donoMap = NBTHelper.readMap(nbt, "StreamDonos", CompoundTag.class, list -> {
            Donations donos = new Donations();
            donos.deserializeNBT((CompoundTag)list);
            return donos;
        });
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        NBTHelper.writeMap(nbt, "StreamSubsBuffer", this.subBufferMap, ListTag.class, Subscribers::serializeNBT);
        NBTHelper.writeMap(nbt, "StreamSubs", this.subMap, ListTag.class, Subscribers::serializeNBT);
        NBTHelper.writeMap(nbt, "StreamDonos", this.donoMap, CompoundTag.class, Donations::serializeNBT);
        return nbt;
    }

    public static StreamData get(ServerLevel world) {
        return (StreamData)world.m_142572_().m_129783_().m_8895_().m_164861_(StreamData::create, StreamData::new, DATA_NAME);
    }

    public static class Subscribers
    implements INBTSerializable<ListTag> {
        private final List<Instance> subs = new ArrayList<Instance>();

        public void onSub(String name, int months) {
            this.subs.add(new Instance(name, months));
        }

        public void onSub(CompoundTag nbt) {
            Instance sub = new Instance();
            sub.deserializeNBT(nbt);
            this.subs.add(sub);
        }

        public int count() {
            return this.subs.size();
        }

        public Instance popOneSub() {
            if (this.subs.isEmpty()) {
                return null;
            }
            return this.subs.remove(0);
        }

        public Instance getRandom(Random random) {
            if (this.subs.isEmpty()) {
                return null;
            }
            return this.subs.get(random.nextInt(this.subs.size()));
        }

        public Subscribers merge(Subscribers other) {
            Subscribers merged = new Subscribers();
            merged.subs.addAll(this.subs);
            merged.subs.addAll(other.subs);
            return merged;
        }

        public ListTag serializeNBT() {
            return this.subs.stream().map(Instance::serializeNBT).collect(Collectors.toCollection(ListTag::new));
        }

        public void deserializeNBT(ListTag nbt) {
            this.subs.clear();
            IntStream.range(0, nbt.size()).mapToObj(arg_0 -> ((ListTag)nbt).m_128728_(arg_0)).forEach(this::onSub);
        }

        public static class Instance
        implements INBTSerializable<CompoundTag> {
            private String name = "";
            private int months = 0;

            public Instance() {
            }

            public Instance(String name, int months) {
                this.name = name;
                this.months = months;
            }

            public String getName() {
                return this.name;
            }

            public int getMonths() {
                return this.months;
            }

            public CompoundTag serializeNBT() {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128359_("Name", this.name);
                nbt.m_128405_("Months", this.months);
                return nbt;
            }

            public void deserializeNBT(CompoundTag nbt) {
                this.name = nbt.m_128461_("Name");
                this.months = nbt.m_128451_("Months");
            }
        }
    }

    public static class Donations
    implements INBTSerializable<CompoundTag> {
        private final Map<String, Integer> donoMap = new HashMap<String, Integer>();

        public Donations onDono(String name, int amount) {
            this.donoMap.put(name, this.donoMap.getOrDefault(name, 0) + amount);
            return this;
        }

        public WeightedList<String> toWeightedList() {
            WeightedList<String> list = new WeightedList<String>();
            for (Map.Entry<String, Integer> entry : this.donoMap.entrySet()) {
                list.add(entry.getKey(), entry.getValue());
            }
            return list;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            ListTag donators = new ListTag();
            ListTag amounts = new ListTag();
            this.donoMap.forEach((donator, amount) -> {
                donators.add((Object)StringTag.m_129297_((String)donator));
                amounts.add((Object)IntTag.m_128679_((int)amount));
            });
            nbt.m_128365_("Donators", (Tag)donators);
            nbt.m_128365_("Amounts", (Tag)amounts);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            ListTag donators = nbt.m_128437_("Donators", 8);
            ListTag amounts = nbt.m_128437_("Amounts", 3);
            if (donators.size() != amounts.size()) {
                throw new IllegalStateException("Map doesn't have the same amount of keys as values");
            }
            for (int i = 0; i < donators.size(); ++i) {
                this.donoMap.put(donators.m_128778_(i), amounts.m_128763_(i));
            }
        }
    }
}

