/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.util.WeekKey;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerVaultStatsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerVaultLevels";
    private final Map<UUID, PlayerVaultStats> playerMap = new HashMap<UUID, PlayerVaultStats>();
    private final Map<WeekKey, List<PlayerRecordEntry>> weeklyVaultRecords = new HashMap<WeekKey, List<PlayerRecordEntry>>();

    public PlayerVaultStats getVaultStats(Player player) {
        return this.getVaultStats(player.m_142081_());
    }

    public PlayerVaultStats getVaultStats(UUID uuid) {
        return this.playerMap.computeIfAbsent(uuid, PlayerVaultStats::new);
    }

    public PlayerVaultStatsData setVaultLevel(ServerPlayer player, int level) {
        this.getVaultStats((Player)player).setVaultLevel(player.m_20194_(), level);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addVaultExp(ServerPlayer player, int exp) {
        this.getVaultStats((Player)player).addVaultExp(player.m_20194_(), exp);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData spendSkillPoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).spendSkillPoints(player.m_20194_(), amount);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData spendKnowledgePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).spendKnowledgePoints(player.m_20194_(), amount);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData spendArchetypePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).spendArchetypePoints(player.m_20194_(), amount);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData spendRegretPoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).spendRegretPoints(player.m_20194_(), amount);
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addSkillPoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).addSkillPoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addKnowledgePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).addKnowledgePoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addArchetypePoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).addArchetypePoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData addRegretPoints(ServerPlayer player, int amount) {
        this.getVaultStats((Player)player).addRegretPoints(amount).sync(player.m_183503_().m_142572_());
        this.m_77762_();
        return this;
    }

    public PlayerVaultStatsData reset(ServerPlayer player) {
        this.getVaultStats((Player)player).reset(player.m_20194_());
        this.m_77762_();
        return this;
    }

    @Nonnull
    public PlayerRecordEntry getFastestVaultTime() {
        return this.getFastestVaultTime(WeekKey.current());
    }

    @Nonnull
    public PlayerRecordEntry getFastestVaultTime(WeekKey week) {
        return this.weeklyVaultRecords.computeIfAbsent(week, key -> new ArrayList()).stream().min(Comparator.comparing(PlayerRecordEntry::getTickCount)).orElse(PlayerRecordEntry.DEFAULT);
    }

    public void updateFastestVaultTime(Player player, int timeTicks) {
        this.updateFastestVaultTime(new PlayerRecordEntry(player.m_142081_(), player.m_7755_().getString(), timeTicks));
    }

    private void updateFastestVaultTime(PlayerRecordEntry entry) {
        this.weeklyVaultRecords.computeIfAbsent(WeekKey.current(), key -> new ArrayList()).add(entry);
        this.m_77762_();
    }

    public static PlayerVaultStatsData get(ServerLevel world) {
        return PlayerVaultStatsData.get(world.m_142572_());
    }

    public static PlayerVaultStatsData get(MinecraftServer srv) {
        return (PlayerVaultStatsData)srv.m_129783_().m_8895_().m_164861_(PlayerVaultStatsData::create, PlayerVaultStatsData::new, DATA_NAME);
    }

    private static PlayerVaultStatsData create(CompoundTag tag) {
        PlayerVaultStatsData data = new PlayerVaultStatsData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        int i;
        ListTag playerList = nbt.m_128437_("PlayerEntries", 8);
        ListTag statEntries = nbt.m_128437_("StatEntries", 10);
        ListTag weeklyRecords = nbt.m_128437_("WeeklyRecords", 10);
        if (playerList.size() != statEntries.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.getVaultStats(playerUUID).deserializeNBT(statEntries.m_128728_(i));
        }
        for (i = 0; i < weeklyRecords.size(); ++i) {
            CompoundTag tag = weeklyRecords.m_128728_(i);
            WeekKey key = WeekKey.deserialize(tag.m_128469_("weekKey"));
            ArrayList<PlayerRecordEntry> recordEntries = new ArrayList<PlayerRecordEntry>();
            ListTag entries = tag.m_128437_("entries", 10);
            for (int j = 0; j < entries.size(); ++j) {
                recordEntries.add(PlayerRecordEntry.deserialize(entries.m_128728_(j)));
            }
            this.weeklyVaultRecords.put(key, recordEntries);
        }
        if (nbt.m_128425_("RecordEntries", 9)) {
            ListTag recordList = nbt.m_128437_("RecordEntries", 10);
            for (int i2 = 0; i2 < recordList.size(); ++i2) {
                this.updateFastestVaultTime(PlayerRecordEntry.deserialize(recordList.m_128728_(i2)));
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag statsList = new ListTag();
        ListTag recordWeekList = new ListTag();
        this.playerMap.forEach((uuid, stats) -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            statsList.add((Object)stats.serializeNBT());
        });
        nbt.m_128365_("PlayerEntries", (Tag)playerList);
        nbt.m_128365_("StatEntries", (Tag)statsList);
        this.weeklyVaultRecords.forEach((weekKey, entries) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("weekKey", (Tag)weekKey.serialize());
            ListTag recordEntries = new ListTag();
            entries.forEach(entry -> recordEntries.add((Object)entry.serialize()));
            tag.m_128365_("entries", (Tag)recordEntries);
            recordWeekList.add((Object)tag);
        });
        nbt.m_128365_("WeeklyRecords", (Tag)recordWeekList);
        return nbt;
    }

    public static class PlayerRecordEntry {
        private static final PlayerRecordEntry DEFAULT = new PlayerRecordEntry(Util.f_137441_, "", 6000);
        private final UUID playerUUID;
        private final String playerName;
        private final int tickCount;

        public PlayerRecordEntry(UUID playerUUID, String playerName, int tickCount) {
            this.playerUUID = playerUUID;
            this.playerName = playerName;
            this.tickCount = tickCount;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public int getTickCount() {
            return this.tickCount;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("playerUUID", this.playerUUID);
            tag.m_128359_("playerName", this.playerName);
            tag.m_128405_("tickCount", this.tickCount);
            return tag;
        }

        public static PlayerRecordEntry deserialize(CompoundTag tag) {
            return new PlayerRecordEntry(tag.m_128342_("playerUUID"), tag.m_128461_("playerName"), tag.m_128451_("tickCount"));
        }
    }
}

