/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.skill.talent.TalentNode;
import iskallia.vault.skill.talent.TalentTree;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerTalentsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerTalents";
    private Map<UUID, TalentTree> playerMap = new HashMap<UUID, TalentTree>();

    public TalentTree getTalents(Player player) {
        return this.getTalents(player.m_142081_());
    }

    public TalentTree getTalents(UUID uuid) {
        return this.playerMap.computeIfAbsent(uuid, TalentTree::new);
    }

    public PlayerTalentsData add(ServerPlayer player, TalentNode<?> ... nodes) {
        this.getTalents((Player)player).add(player.m_20194_(), nodes);
        this.m_77762_();
        return this;
    }

    public PlayerTalentsData remove(ServerPlayer player, TalentNode<?> ... nodes) {
        this.getTalents((Player)player).remove(player.m_20194_(), nodes);
        this.m_77762_();
        return this;
    }

    public PlayerTalentsData upgradeTalent(ServerPlayer player, TalentNode<?> talentNode) {
        TalentTree talentTree = this.getTalents((Player)player);
        talentTree.upgradeTalent(player.m_20194_(), talentNode);
        talentTree.sync(player.m_20194_());
        this.m_77762_();
        return this;
    }

    public PlayerTalentsData downgradeTalent(ServerPlayer player, TalentNode<?> talentNode) {
        TalentTree talentTree = this.getTalents((Player)player);
        talentTree.downgradeTalent(player.m_20194_(), talentNode);
        talentTree.sync(player.m_20194_());
        this.m_77762_();
        return this;
    }

    public PlayerTalentsData resetTalentTree(ServerPlayer player) {
        UUID uniqueID = player.m_142081_();
        TalentTree oldTalentTree = this.playerMap.get(uniqueID);
        if (oldTalentTree != null) {
            for (TalentNode<?> node : oldTalentTree.getNodes()) {
                if (!node.isLearned()) continue;
                node.getTalent().onRemoved((Player)player);
            }
        }
        TalentTree talentTree = new TalentTree(uniqueID);
        this.playerMap.put(uniqueID, talentTree);
        talentTree.sync(player.m_20194_());
        this.m_77762_();
        return this;
    }

    public PlayerTalentsData tick(MinecraftServer server) {
        this.playerMap.values().forEach(abilityTree -> abilityTree.tick(server));
        return this;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            PlayerTalentsData.get((ServerLevel)event.world).tick(((ServerLevel)event.world).m_142572_());
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            PlayerTalentsData.get((ServerLevel)event.player.f_19853_).getTalents(event.player);
        }
    }

    private static PlayerTalentsData create(CompoundTag tag) {
        PlayerTalentsData data = new PlayerTalentsData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        ListTag playerList = nbt.m_128437_("PlayerEntries", 8);
        ListTag talentList = nbt.m_128437_("TalentEntries", 10);
        if (playerList.size() != talentList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.getTalents(playerUUID).deserializeNBT(talentList.m_128728_(i));
        }
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag talentList = new ListTag();
        this.playerMap.forEach((uuid, talentTree) -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            talentList.add((Object)talentTree.serializeNBT());
        });
        nbt.m_128365_("PlayerEntries", (Tag)playerList);
        nbt.m_128365_("TalentEntries", (Tag)talentList);
        return nbt;
    }

    public static PlayerTalentsData get(ServerLevel world) {
        return PlayerTalentsData.get(world.m_142572_());
    }

    public static PlayerTalentsData get(MinecraftServer srv) {
        return (PlayerTalentsData)srv.m_129783_().m_8895_().m_164861_(PlayerTalentsData::create, PlayerTalentsData::new, DATA_NAME);
    }
}

