/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerSpiritRecoveryData
extends SavedData {
    private static final String DATA_NAME = "the_vault_PlayerSpiritRecovery";
    private Map<UUID, Integer> playerSpiritRecoveries = new HashMap<UUID, Integer>();

    public static PlayerSpiritRecoveryData get(ServerLevel world) {
        return (PlayerSpiritRecoveryData)world.m_142572_().m_129783_().m_8895_().m_164861_(PlayerSpiritRecoveryData::create, PlayerSpiritRecoveryData::new, DATA_NAME);
    }

    private static PlayerSpiritRecoveryData create(CompoundTag tag) {
        PlayerSpiritRecoveryData data = new PlayerSpiritRecoveryData();
        data.load(tag);
        return data;
    }

    private void load(CompoundTag tag) {
        this.playerSpiritRecoveries.clear();
        ListTag data = tag.m_128437_("PlayerData", 10);
        data.forEach(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag entry = (CompoundTag)t;
                this.playerSpiritRecoveries.put(entry.m_128342_("uuid"), entry.m_128451_("count"));
            }
        });
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag spiritRecoveries = new ListTag();
        this.playerSpiritRecoveries.forEach((uuid, count) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("uuid", uuid);
            entry.m_128405_("count", count.intValue());
            spiritRecoveries.add((Object)entry);
        });
        compoundTag.m_128365_("PlayerData", (Tag)spiritRecoveries);
        return compoundTag;
    }

    public void incrementSpiritRecovery(UUID playerUuid) {
        this.playerSpiritRecoveries.compute(playerUuid, (uuid, count) -> {
            int n;
            if (count == null) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            return n;
        });
        this.m_77762_();
    }

    public int getSpiritRecoveryCount(UUID playerUuid) {
        return this.playerSpiritRecoveries.getOrDefault(playerUuid, 0);
    }
}

