/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.research.ResearchTree;
import iskallia.vault.research.type.Research;
import iskallia.vault.util.NetcodeUtils;
import iskallia.vault.util.PlayerReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerResearchesData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerResearches";
    private final Map<UUID, ResearchTree> playerMap = new HashMap<UUID, ResearchTree>();
    private final List<List<PlayerReference>> researchTeams = new ArrayList<List<PlayerReference>>();
    private final Map<PlayerReference, Set<PlayerReference>> invites = new HashMap<PlayerReference, Set<PlayerReference>>();

    public ResearchTree getResearches(Player player) {
        return this.getResearches(player.m_142081_());
    }

    public ResearchTree getResearches(UUID uuid) {
        return this.playerMap.computeIfAbsent(uuid, id -> ResearchTree.empty());
    }

    public PlayerResearchesData research(ServerPlayer player, Research research) {
        ResearchTree researchTree = this.getResearches((Player)player);
        researchTree.research(research);
        researchTree.getResearchShares().forEach(share -> {
            ResearchTree sharedTree = this.getResearches(share.getId());
            if (!sharedTree.isResearched(research)) {
                sharedTree.research(research);
                NetcodeUtils.runIfPresent(player.m_20194_(), share.getId(), other -> {
                    MutableComponent ct = new TextComponent("").m_130940_(ChatFormatting.GRAY);
                    ct.m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.AQUA));
                    ct.m_7220_((Component)new TextComponent(" researched ").m_130940_(ChatFormatting.GRAY));
                    ct.m_7220_((Component)new TextComponent(research.getName()).m_130940_(ChatFormatting.AQUA));
                    other.m_6352_((Component)ct, Util.f_137441_);
                });
            }
        });
        this.syncAll(player.f_8924_);
        this.m_77762_();
        return this;
    }

    public PlayerResearchesData removeResearch(ServerPlayer player, Research research) {
        ResearchTree researchTree = this.getResearches((Player)player);
        researchTree.removeResearch(research);
        this.syncAll(player.f_8924_);
        this.m_77762_();
        return this;
    }

    public PlayerResearchesData resetResearchTree(ServerPlayer player) {
        ResearchTree researchTree = this.getResearches((Player)player);
        researchTree.resetResearches();
        this.leaveCurrentTeam((Player)player);
        this.propagateTeams();
        this.syncAll(player.f_8924_);
        this.m_77762_();
        return this;
    }

    public boolean isInTeam(UUID playerId) {
        return !this.getTeamMembers(playerId).isEmpty();
    }

    public List<PlayerReference> getTeamMembers(UUID playerId) {
        for (List<PlayerReference> team : this.researchTeams) {
            for (PlayerReference teamMember : team) {
                if (!teamMember.getId().equals(playerId)) continue;
                return team;
            }
        }
        return Collections.emptyList();
    }

    public boolean leaveCurrentTeam(Player player) {
        Iterator<List<PlayerReference>> teamsItr = this.researchTeams.iterator();
        while (teamsItr.hasNext()) {
            List<PlayerReference> team = teamsItr.next();
            if (!team.removeIf(teamMember -> teamMember.getId().equals(player.m_142081_()))) continue;
            if (team.size() <= 1) {
                teamsItr.remove();
            }
            this.clearInvitesAssociatedWith(player);
            this.propagateTeams();
            this.syncAll(ServerLifecycleHooks.getCurrentServer());
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean acceptInvite(Player invitee, UUID issuer) {
        UUID inviteeId = invitee.m_142081_();
        if (!this.getTeamMembers(inviteeId).isEmpty()) {
            return false;
        }
        PlayerReference inviteeRef = new PlayerReference(invitee);
        if (!this.getInvites(issuer).contains(inviteeRef)) {
            return false;
        }
        PlayerReference issuerRef = this.getInviteIssuerReference(issuer);
        List<PlayerReference> team = this.getTeamMembers(issuer);
        if (!team.isEmpty()) {
            team.add(inviteeRef);
        } else {
            ArrayList<PlayerReference> newTeam = new ArrayList<PlayerReference>();
            newTeam.add(inviteeRef);
            newTeam.add(issuerRef);
            this.researchTeams.add(newTeam);
        }
        this.clearInvitesAssociatedWith(invitee);
        this.propagateTeams();
        this.syncAll(ServerLifecycleHooks.getCurrentServer());
        this.m_77762_();
        return true;
    }

    public boolean createInvite(Player issuer, Player invitee) {
        if (issuer.m_142081_().equals(invitee.m_142081_())) {
            return false;
        }
        if (!this.getTeamMembers(invitee.m_142081_()).isEmpty()) {
            return false;
        }
        this.invites.computeIfAbsent(new PlayerReference(issuer), id -> new HashSet()).add(new PlayerReference(invitee));
        return true;
    }

    private Set<PlayerReference> getInvites(UUID issuer) {
        for (PlayerReference issuerRef : this.invites.keySet()) {
            if (!issuerRef.getId().equals(issuer)) continue;
            return this.invites.get(issuerRef);
        }
        return Collections.emptySet();
    }

    @Nullable
    private PlayerReference getInviteIssuerReference(UUID issuer) {
        for (PlayerReference issuerRef : this.invites.keySet()) {
            if (!issuerRef.getId().equals(issuer)) continue;
            return issuerRef;
        }
        return null;
    }

    private void clearInvitesAssociatedWith(Player player) {
        PlayerReference playerReference = new PlayerReference(player);
        this.invites.remove(playerReference);
        this.invites.values().forEach(invites -> invites.removeIf(playerReference::equals));
    }

    private void propagateTeams() {
        this.playerMap.forEach((playerId, researchTree) -> {
            researchTree.resetShares();
            this.getTeamMembers((UUID)playerId).forEach(ref -> {
                if (!ref.getId().equals(playerId)) {
                    researchTree.addShare((PlayerReference)ref);
                }
            });
        });
    }

    public void syncAll(MinecraftServer server) {
        server.m_6846_().m_11314_().forEach(this::sync);
    }

    public void sync(ServerPlayer player) {
        this.getResearches((Player)player).sync(player);
    }

    private static PlayerResearchesData create(CompoundTag tag) {
        PlayerResearchesData data = new PlayerResearchesData();
        data.load(tag);
        return data;
    }

    private void load(CompoundTag nbt) {
        if (nbt.m_128441_("PlayerEntries")) {
            this.loadLegacy(nbt);
            return;
        }
        this.playerMap.clear();
        for (String key : nbt.m_128431_()) {
            UUID playerId;
            try {
                playerId = UUID.fromString(key);
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            this.playerMap.put(playerId, new ResearchTree(nbt.m_128469_(key)));
        }
        this.researchTeams.clear();
        ListTag teams = nbt.m_128437_("sharedTeams", 9);
        for (int i = 0; i < teams.size(); ++i) {
            ArrayList<PlayerReference> team = new ArrayList<PlayerReference>();
            ListTag teamMembers = teams.m_128744_(i);
            for (int j = 0; j < teamMembers.size(); ++j) {
                team.add(new PlayerReference(teamMembers.m_128728_(j)));
            }
            this.researchTeams.add(team);
        }
    }

    private void loadLegacy(CompoundTag nbt) {
        ListTag playerList = nbt.m_128437_("PlayerEntries", 8);
        ListTag researchesList = nbt.m_128437_("ResearchEntries", 10);
        if (playerList.size() != researchesList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.playerMap.put(playerUUID, new ResearchTree(researchesList.m_128728_(i)));
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag teams = new ListTag();
        this.researchTeams.forEach(teamList -> {
            ListTag teamMembers = new ListTag();
            teamList.forEach(ref -> teamMembers.add((Object)ref.serialize()));
            teams.add((Object)teamMembers);
        });
        nbt.m_128365_("sharedTeams", (Tag)teams);
        this.playerMap.forEach((playerId, researchTree) -> nbt.m_128365_(playerId.toString(), (Tag)researchTree.serializeNBT()));
        return nbt;
    }

    public static PlayerResearchesData get(ServerLevel world) {
        return (PlayerResearchesData)world.m_142572_().m_129783_().m_8895_().m_164861_(PlayerResearchesData::create, PlayerResearchesData::new, DATA_NAME);
    }
}

