/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.registries.ForgeRegistryEntry;

@Deprecated(forRemoval=true)
public class PlayerImmunityData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerImmunity";
    protected Map<UUID, List<String>> effects = new HashMap<UUID, List<String>>();

    public void addEffect(Player player, MobEffectInstance effectInstance) {
        this.addEffect(player.m_142081_(), effectInstance);
    }

    private void addEffect(UUID playerUUID, MobEffectInstance effectInstance) {
        this.effects.put(playerUUID, Collections.singletonList(effectInstance.m_19544_().getRegistryName().toString()));
        this.m_77762_();
    }

    public void addEffects(Player player, List<MobEffectInstance> effects) {
        this.addEffects(player.m_142081_(), effects);
    }

    public void addEffects(UUID playerUUID, List<MobEffectInstance> effects) {
        this.effects.put(playerUUID, effects.stream().map(MobEffectInstance::m_19544_).map(ForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList()));
        this.m_77762_();
    }

    public List<MobEffect> getEffects(UUID playerUUID) {
        return Registry.f_122823_.m_123024_().filter(effect -> this.effects.get(playerUUID).contains(effect.getRegistryName().toString())).collect(Collectors.toList());
    }

    public void removeEffects(Player player) {
        this.removeEffects(player.m_142081_());
    }

    public void removeEffects(UUID playerUUID) {
        this.effects.remove(playerUUID);
        this.m_77762_();
    }

    private static PlayerImmunityData create(CompoundTag tag) {
        PlayerImmunityData data = new PlayerImmunityData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.effects.clear();
        for (String key : nbt.m_128431_()) {
            UUID uuid;
            try {
                uuid = UUID.fromString(key);
            }
            catch (IllegalArgumentException ignored) {
                continue;
            }
            ArrayList effects = new ArrayList();
            CompoundTag effectTag = nbt.m_128469_(key);
            effectTag.m_128431_().forEach(effectKey -> effects.add(effectTag.m_128461_(effectKey)));
            this.effects.put(uuid, effects);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        this.effects.forEach((uuid, effects) -> {
            CompoundTag effectTag = new CompoundTag();
            AtomicInteger index = new AtomicInteger();
            effects.forEach(effectId -> effectTag.m_128359_("Effect" + index.getAndIncrement(), effectId));
            compound.m_128365_(uuid.toString(), (Tag)effectTag);
        });
        return compound;
    }

    public static PlayerImmunityData get(ServerLevel world) {
        return (PlayerImmunityData)world.m_142572_().m_129783_().m_8895_().m_164861_(PlayerImmunityData::create, PlayerImmunityData::new, DATA_NAME);
    }
}

