/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerFavourData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerFavour";
    protected Map<UUID, Map<VaultGodType, Integer>> favourStats = new HashMap<UUID, Map<VaultGodType, Integer>>();

    public boolean addFavour(Player player, VaultGodType type, int count) {
        UUID playerUUID = player.m_142081_();
        int favour = this.favourStats.computeIfAbsent(playerUUID, key -> new HashMap()).getOrDefault((Object)type, 0);
        if (Math.abs(favour + count) > 16) {
            return false;
        }
        this.favourStats.computeIfAbsent(playerUUID, key -> new HashMap()).put(type, favour += count);
        this.m_77762_();
        return true;
    }

    public int getFavour(UUID playerUUID, VaultGodType type) {
        return this.favourStats.getOrDefault(playerUUID, Collections.emptyMap()).getOrDefault((Object)type, 0);
    }

    private static PlayerFavourData create(CompoundTag tag) {
        PlayerFavourData data = new PlayerFavourData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.favourStats.clear();
        for (String key : nbt.m_128431_()) {
            UUID playerUUID;
            try {
                playerUUID = UUID.fromString(key);
            }
            catch (IllegalArgumentException exc) {
                continue;
            }
            HashMap<VaultGodType, Integer> playerFavour = new HashMap<VaultGodType, Integer>();
            CompoundTag favourTag = nbt.m_128469_(key);
            for (String godKey : favourTag.m_128431_()) {
                try {
                    playerFavour.put(VaultGodType.valueOf(godKey), favourTag.m_128451_(godKey));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            this.favourStats.put(playerUUID, playerFavour);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        this.favourStats.forEach((uuid, playerFavour) -> {
            CompoundTag favourTag = new CompoundTag();
            playerFavour.forEach((type, count) -> favourTag.m_128405_(type.name(), count.intValue()));
            compound.m_128365_(uuid.toString(), (Tag)favourTag);
        });
        return compound;
    }

    public static PlayerFavourData get(ServerLevel world) {
        return (PlayerFavourData)world.m_142572_().m_129783_().m_8895_().m_164861_(PlayerFavourData::create, PlayerFavourData::new, DATA_NAME);
    }

    public static enum VaultGodType implements StringRepresentable
    {
        BENEVOLENT("Velara", "The Benevolent", ChatFormatting.GREEN),
        OMNISCIENT("Tenos", "The Omniscient", ChatFormatting.AQUA),
        TIMEKEEPER("Wendarr", "The Timekeeper", ChatFormatting.GOLD),
        MALEVOLENT("Idona", "The Malevolent", ChatFormatting.RED);

        private final String name;
        private final String title;
        private final ChatFormatting color;

        private VaultGodType(String name, String title, ChatFormatting color) {
            this.name = name;
            this.title = title;
            this.color = color;
        }

        public static VaultGodType fromName(String name) {
            for (VaultGodType type : VaultGodType.values()) {
                if (!name.equalsIgnoreCase(type.getName())) continue;
                return type;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public ChatFormatting getChatColor() {
            return this.color;
        }

        @Nonnull
        public String m_7912_() {
            return this.getName().toLowerCase();
        }

        public Component getHoverChatComponent() {
            return new TextComponent("[Vault God] ").m_130940_(ChatFormatting.WHITE).m_7220_((Component)new TextComponent(this.name + ", " + this.title).m_130940_(this.color));
        }

        public Component getIdolDescription() {
            String s = this.getName().endsWith("s") ? "" : "s";
            return new TextComponent(String.format("%s'%s Idol", this.getName(), s)).m_130940_(this.getChatColor());
        }

        public MutableComponent getChosenPrefix() {
            String prefix = "[" + this.getName().charAt(0) + "C] ";
            MutableComponent cmp = new TextComponent(prefix).m_130940_(this.color);
            String s = this.getName().endsWith("s") ? "" : "s";
            MutableComponent hover = new TextComponent(String.format("%s'%s Chosen", this.getName(), s)).m_130940_(this.getChatColor());
            cmp.m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hover)));
            return cmp;
        }

        public VaultGodType getOther(Random rand) {
            int i;
            while ((i = rand.nextInt(VaultGodType.values().length)) == this.ordinal()) {
            }
            return VaultGodType.values()[i];
        }
    }
}

