/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.config.SoulShardConfig;
import iskallia.vault.container.inventory.ShardTradeContainer;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.ItemVaultCrystalSeal;
import iskallia.vault.network.message.ShardTradeMessage;
import iskallia.vault.util.MathUtilities;
import iskallia.vault.util.NetcodeUtils;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerBlackMarketData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerBlackMarket";
    private final Map<UUID, BlackMarket> playerMap = new HashMap<UUID, BlackMarket>();
    private static final String TAG_PLAYER_LIST = "playerList";
    private static final String TAG_BLACK_MARKET_LIST = "blackMarketList";

    public static PlayerBlackMarketData get(ServerLevel level) {
        return PlayerBlackMarketData.get(level.m_142572_());
    }

    public static PlayerBlackMarketData get(MinecraftServer server) {
        return (PlayerBlackMarketData)server.m_129783_().m_8895_().m_164861_(PlayerBlackMarketData::create, PlayerBlackMarketData::new, DATA_NAME);
    }

    private static PlayerBlackMarketData create(CompoundTag compoundTag) {
        return new PlayerBlackMarketData(compoundTag);
    }

    private PlayerBlackMarketData() {
    }

    private PlayerBlackMarketData(CompoundTag compoundTag) {
        this();
        this.load(compoundTag);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side.isServer() && event.phase == TickEvent.Phase.START && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerBlackMarketData.get(player2.f_8924_).getBlackMarket((Player)player2).tick(player2.f_8924_, player2);
        }
    }

    public Map<UUID, BlackMarket> getPlayerMap() {
        return this.playerMap;
    }

    public BlackMarket getBlackMarket(Player player) {
        return this.getBlackMarket(player.m_142081_());
    }

    public BlackMarket getBlackMarket(UUID playerUuid) {
        return this.playerMap.computeIfAbsent(playerUuid, x$0 -> new BlackMarket((UUID)x$0));
    }

    public PlayerBlackMarketData set(ServerPlayer player, Long seed) {
        this.getBlackMarket((Player)player).seed = seed;
        this.m_77762_();
        return this;
    }

    private void load(CompoundTag compoundTag) {
        ListTag playerList = compoundTag.m_128437_(TAG_PLAYER_LIST, 8);
        ListTag blackMarketList = compoundTag.m_128437_(TAG_BLACK_MARKET_LIST, 10);
        if (playerList.size() != blackMarketList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.getBlackMarket(playerUUID).deserializeNBT(blackMarketList.m_128728_(i));
        }
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag playerList = new ListTag();
        ListTag blackMarketList = new ListTag();
        this.playerMap.forEach((key, value) -> {
            playerList.add((Object)StringTag.m_129297_((String)key.toString()));
            blackMarketList.add((Object)value.serializeNBT());
        });
        compoundTag.m_128365_(TAG_PLAYER_LIST, (Tag)playerList);
        compoundTag.m_128365_(TAG_BLACK_MARKET_LIST, (Tag)blackMarketList);
        return compoundTag;
    }

    public class BlackMarket {
        private static final Random rand = new Random();
        private LocalDateTime nextReset;
        private long seed;
        private UUID playerUuid;
        private final Map<Integer, SelectedTrade> trades = new HashMap<Integer, SelectedTrade>();

        public BlackMarket(UUID playerUuid) {
            this.playerUuid = playerUuid;
            this.seed = rand.nextLong();
            this.resetTrades();
            this.setNextReset();
        }

        public void setNextReset() {
            this.nextReset = LocalDateTime.now(ZoneId.of("UTC")).plusHours(ModConfigs.BLACK_MARKET.getResetHours()).plusMinutes(ModConfigs.BLACK_MARKET.getResetMinutes());
        }

        public void resetTrades() {
            this.trades.clear();
            for (int i = 0; i < 3; ++i) {
                this.trades.put(i, new SelectedTrade(ModConfigs.SOUL_SHARD.getRandomTrade()));
            }
            if (ModConfigs.RAID_EVENT_CONFIG.isEnabled()) {
                ItemStack eventSeal = new ItemStack((ItemLike)ModItems.CRYSTAL_SEAL_RAID);
                ItemVaultCrystalSeal.setEventKey(eventSeal, "raid");
                SelectedTrade eventTrade = new SelectedTrade(eventSeal, ModConfigs.RAID_EVENT_CONFIG.getSoulShardTradeCost());
                eventTrade.isInfinite = true;
                this.trades.put(0, eventTrade);
            }
            this.setNextReset();
            PlayerBlackMarketData.this.m_77762_();
            this.syncToClient(ServerLifecycleHooks.getCurrentServer());
        }

        public boolean useTrade(int tradeId) {
            SelectedTrade trade = this.trades.get(tradeId);
            if (trade != null && trade.isInfinite) {
                return true;
            }
            this.trades.remove(tradeId);
            PlayerBlackMarketData.this.m_77762_();
            this.resetTrades();
            return true;
        }

        public void tick(MinecraftServer server, ServerPlayer player) {
            LocalDateTime end = PlayerBlackMarketData.get((ServerLevel)server.m_129783_()).getBlackMarket((Player)player).nextReset;
            LocalDateTime now = LocalDateTime.now(ZoneId.of("UTC"));
            if (end.isBefore(now)) {
                this.resetTrades();
            }
        }

        public Map<Integer, SelectedTrade> getTrades() {
            return Collections.unmodifiableMap(this.trades);
        }

        public long getSeed() {
            return this.seed;
        }

        public void openTradeContainer(ServerPlayer player) {
            NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return new TextComponent("Black Market");
                }

                public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                    return new ShardTradeContainer(windowId, playerInventory);
                }
            });
        }

        private static PlayerBlackMarketData create(CompoundTag tag) {
            PlayerBlackMarketData data = new PlayerBlackMarketData();
            data.load(tag);
            return data;
        }

        public void deserializeNBT(CompoundTag tag) {
            this.trades.clear();
            this.seed = tag.m_128454_("seed");
            ListTag list = tag.m_128437_("trades", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tradeTag = list.m_128728_(i);
                this.trades.put(tradeTag.m_128451_("index"), new SelectedTrade(tradeTag.m_128469_("trade")));
            }
            this.nextReset = LocalDateTime.parse(tag.m_128461_("nextReset"), DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            this.playerUuid = tag.m_128342_("uuid");
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            this.trades.forEach((index, trade) -> {
                CompoundTag tradeTag = new CompoundTag();
                tradeTag.m_128405_("index", index.intValue());
                tradeTag.m_128365_("trade", (Tag)trade.serialize());
                list.add((Object)tradeTag);
            });
            tag.m_128365_("trades", (Tag)list);
            tag.m_128362_("uuid", this.playerUuid);
            tag.m_128356_("seed", this.seed);
            tag.m_128359_("nextReset", this.nextReset.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            return tag;
        }

        public void syncToClient(MinecraftServer server) {
            NetcodeUtils.runIfPresent(server, this.playerUuid, player -> ModNetwork.CHANNEL.sendTo((Object)new ShardTradeMessage(ModConfigs.SOUL_SHARD.getShardTradePrice(), this.seed, this.getTrades(), this.nextReset), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
        }

        public static PlayerBlackMarketData get(ServerLevel world) {
            return BlackMarket.get(world.m_142572_());
        }

        public static PlayerBlackMarketData get(MinecraftServer server) {
            return (PlayerBlackMarketData)server.m_129783_().m_8895_().m_164861_(PlayerBlackMarketData::create, PlayerBlackMarketData::new, PlayerBlackMarketData.DATA_NAME);
        }

        public static class SelectedTrade {
            private final ItemStack stack;
            private final int shardCost;
            private boolean isInfinite = false;

            public SelectedTrade(SoulShardConfig.ShardTrade trade) {
                this.stack = trade.getItem();
                this.shardCost = MathUtilities.getRandomInt(trade.getMinPrice(), trade.getMaxPrice() + 1);
            }

            public SelectedTrade(ItemStack stack, int shardCost) {
                this.stack = stack;
                this.shardCost = shardCost;
            }

            public SelectedTrade(CompoundTag tag) {
                this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
                this.shardCost = tag.m_128451_("cost");
                this.isInfinite = tag.m_128471_("infinite");
            }

            public int getShardCost() {
                return this.shardCost;
            }

            public ItemStack getStack() {
                return this.stack.m_41777_();
            }

            public boolean isInfinite() {
                return this.isInfinite;
            }

            public CompoundTag serialize() {
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("stack", (Tag)this.stack.serializeNBT());
                tag.m_128405_("cost", this.shardCost);
                tag.m_128379_("infinite", this.isInfinite);
                return tag;
            }
        }
    }
}

