/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.skill.ability.AbilityNode;
import iskallia.vault.skill.ability.AbilityTree;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerAbilitiesData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerAbilities";
    private final Map<UUID, AbilityTree> playerMap = new HashMap<UUID, AbilityTree>();

    public AbilityTree getAbilities(Player player) {
        return this.getAbilities(player.m_142081_());
    }

    public AbilityTree getAbilities(UUID uuid) {
        return this.playerMap.computeIfAbsent(uuid, id -> new AbilityTree((UUID)id, () -> ((PlayerAbilitiesData)this).m_77762_()));
    }

    public PlayerAbilitiesData add(ServerPlayer player, AbilityNode<?, ?> ... nodes) {
        this.getAbilities((Player)player).add(player.m_20194_(), nodes);
        this.m_77762_();
        return this;
    }

    public PlayerAbilitiesData remove(ServerPlayer player, AbilityNode<?, ?> ... nodes) {
        this.getAbilities((Player)player).remove(player.m_20194_(), nodes);
        this.m_77762_();
        return this;
    }

    public PlayerAbilitiesData upgradeAbility(ServerPlayer player, AbilityNode<?, ?> abilityNode) {
        AbilityTree abilityTree = this.getAbilities((Player)player);
        abilityTree.upgradeAbility(player.m_20194_(), abilityNode);
        abilityTree.sync(player.f_8924_);
        this.m_77762_();
        return this;
    }

    public PlayerAbilitiesData downgradeAbility(ServerPlayer player, AbilityNode<?, ?> abilityNode) {
        AbilityTree abilityTree = this.getAbilities((Player)player);
        abilityTree.downgradeAbility(player.m_20194_(), abilityNode);
        abilityTree.sync(player.f_8924_);
        this.m_77762_();
        return this;
    }

    public PlayerAbilitiesData selectSpecialization(ServerPlayer player, AbilityNode<?, ?> node, @Nullable String specialization) {
        AbilityTree abilityTree = this.getAbilities((Player)player);
        abilityTree.selectSpecialization(player, node, specialization);
        abilityTree.sync(player.f_8924_);
        this.m_77762_();
        return this;
    }

    public PlayerAbilitiesData resetAbilityTree(ServerPlayer player) {
        UUID uniqueID = player.m_142081_();
        AbilityTree oldAbilityTree = this.playerMap.get(uniqueID);
        if (oldAbilityTree != null) {
            for (AbilityNode<?, ?> node : oldAbilityTree.getNodes()) {
                if (!node.isLearned()) continue;
                node.onRemoved((Player)player);
            }
        }
        AbilityTree abilityTree = new AbilityTree(uniqueID, () -> ((PlayerAbilitiesData)this).m_77762_());
        this.playerMap.put(uniqueID, abilityTree);
        abilityTree.sync(player.f_8924_);
        this.m_77762_();
        return this;
    }

    public static void setAbilityOnCooldown(ServerPlayer player, String abilityName) {
        AbilityTree abilities = PlayerAbilitiesData.get(player.m_183503_()).getAbilities((Player)player);
        AbilityNode<?, ?> node = abilities.getNodeByName(abilityName);
        if (node == null) {
            return;
        }
        Object config = node.getAbilityConfig();
        if (config == null) {
            return;
        }
        abilities.putOnCooldown(player, node);
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer() && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PlayerAbilitiesData.get(serverPlayer.m_183503_()).getAbilities((Player)serverPlayer).tick(serverPlayer);
        }
    }

    public void load(CompoundTag nbt) {
        ListTag playerList = nbt.m_128437_("PlayerEntries", 8);
        ListTag abilitiesList = nbt.m_128437_("AbilityEntries", 10);
        if (playerList.size() != abilitiesList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.getAbilities(playerUUID).deserializeNBT(abilitiesList.m_128728_(i));
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag abilitiesList = new ListTag();
        this.playerMap.forEach((uuid, researchTree) -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            abilitiesList.add((Object)researchTree.serializeNBT());
        });
        nbt.m_128365_("PlayerEntries", (Tag)playerList);
        nbt.m_128365_("AbilityEntries", (Tag)abilitiesList);
        return nbt;
    }

    private static PlayerAbilitiesData create(CompoundTag tag) {
        PlayerAbilitiesData data = new PlayerAbilitiesData();
        data.load(tag);
        return data;
    }

    public static PlayerAbilitiesData get(ServerLevel world) {
        return PlayerAbilitiesData.get(world.m_142572_());
    }

    public static PlayerAbilitiesData get(MinecraftServer srv) {
        return (PlayerAbilitiesData)srv.m_129783_().m_8895_().m_164861_(PlayerAbilitiesData::create, PlayerAbilitiesData::new, DATA_NAME);
    }
}

