/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.integration.IntegrationCurios;
import iskallia.vault.integration.IntegrationSB;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.nbt.VMapNBT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.ModList;

public abstract class InventorySnapshotData
extends SavedData {
    public VMapNBT<UUID, InventorySnapshot> snapshotData = VMapNBT.ofUUID(InventorySnapshot::new);

    protected abstract boolean shouldSnapshotItem(Player var1, ItemStack var2);

    protected Builder makeSnapshotBuilder(Player player) {
        return new Builder(player).setStackFilter(this::shouldSnapshotItem).removeSnapshotItems();
    }

    public boolean hasSnapshot(Player player) {
        return this.hasSnapshot(player.m_142081_());
    }

    public boolean hasSnapshot(UUID playerUUID) {
        return this.snapshotData.containsKey(playerUUID);
    }

    public void createSnapshot(Player player) {
        if (this.snapshotData.containsKey(player.m_142081_())) {
            this.restoreSnapshot(player);
        }
        this.snapshotData.put(player.m_142081_(), this.makeSnapshotBuilder(player).createSnapshot());
        this.m_77762_();
    }

    public boolean removeSnapshot(Player player) {
        return this.removeSnapshot(player.m_142081_());
    }

    public boolean removeSnapshot(UUID playerUUID) {
        if (this.snapshotData.remove(playerUUID) != null) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean restoreSnapshot(Player player) {
        InventorySnapshot snapshot = this.snapshotData.remove(player.m_142081_());
        if (snapshot != null) {
            this.m_77762_();
            return snapshot.apply(player);
        }
        return false;
    }

    public void load(CompoundTag nbt) {
        this.snapshotData.deserializeNBT(nbt.m_128437_("Players", 10));
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        compound.m_128365_("Players", (Tag)this.snapshotData.serializeNBT());
        return compound;
    }

    public static class Builder {
        private final Player player;
        private boolean removeSnapshotItems = false;
        private boolean replaceExisting = false;
        private BiPredicate<Player, ItemStack> stackFilter = (player, stack) -> true;

        public Builder(Player player2) {
            this.player = player2;
        }

        public Builder removeSnapshotItems() {
            this.removeSnapshotItems = true;
            return this;
        }

        public Builder replaceExisting() {
            this.replaceExisting = true;
            return this;
        }

        public Builder setStackFilter(BiPredicate<Player, ItemStack> stackFilter) {
            this.stackFilter = stackFilter;
            return this;
        }

        public InventorySnapshot createSnapshot() {
            InventorySnapshot snapshot = new InventorySnapshot(this.removeSnapshotItems, this.replaceExisting);
            snapshot.createSnapshot(this.player, this.stackFilter);
            return snapshot;
        }
    }

    public static class InventorySnapshot
    implements INBTSerializable<CompoundTag> {
        private final VListNBT<Integer, IntTag> invIds = new VListNBT<Integer, IntTag>(IntTag::m_128679_, IntTag::m_7047_);
        private final VListNBT<ItemStack, CompoundTag> items = new VListNBT<ItemStack, CompoundTag>(IForgeItemStack::serializeNBT, ItemStack::m_41712_);
        private final Map<String, CompoundTag> customInventoryData = new HashMap<String, CompoundTag>();
        private boolean removeSnapshotItems = false;
        private boolean replaceExisting = false;

        protected InventorySnapshot() {
        }

        protected InventorySnapshot(boolean removeSnapshotItems, boolean replaceExisting) {
            this.removeSnapshotItems = removeSnapshotItems;
            this.replaceExisting = replaceExisting;
        }

        private void createSnapshot(Player player, BiPredicate<Player, ItemStack> stackFilter) {
            for (int slot = 0; slot < ((InventoryAccessor)player.m_150109_()).getSize(); ++slot) {
                ItemStack stack = player.m_150109_().m_8020_(slot);
                if (!stackFilter.test(player, stack)) continue;
                this.addItemStack(slot, stack);
                if (!this.removeSnapshotItems) continue;
                player.m_150109_().m_6836_(slot, ItemStack.f_41583_);
            }
            if (ModList.get().isLoaded("curios")) {
                CompoundTag curiosData = IntegrationCurios.getMappedSerializedCuriosItemStacks(player, stackFilter, this.removeSnapshotItems);
                this.customInventoryData.put("curios", curiosData);
            }
        }

        private void addItemStack(int slot, ItemStack stack) {
            this.invIds.add(slot);
            ItemStack stackCopy = stack.m_41777_();
            if (ModList.get().isLoaded("sophisticatedbackpacksvh")) {
                IntegrationSB.addSnapshotDataIfBackpack(stackCopy);
            }
            this.items.add(stackCopy);
        }

        protected boolean apply(Player player) {
            if (!player.m_6084_()) {
                return false;
            }
            ArrayList<ItemStack> addLater = new ArrayList<ItemStack>();
            for (int index = 0; index < this.items.size(); ++index) {
                ItemStack toAdd = this.items.get(index).m_41777_();
                if (ModList.get().isLoaded("sophisticatedbackpacksvh")) {
                    IntegrationSB.restoreSnapshotIfBackpack(toAdd);
                }
                int slot = this.invIds.get(index);
                if (this.replaceExisting || player.m_150109_().m_8020_(slot).m_41619_()) {
                    player.m_150109_().m_6836_(slot, toAdd);
                    continue;
                }
                addLater.add(toAdd);
            }
            if (ModList.get().isLoaded("curios") && this.customInventoryData.containsKey("curios")) {
                CompoundTag curiosData = this.customInventoryData.get("curios");
                addLater.addAll(IntegrationCurios.applyMappedSerializedCuriosItemStacks(player, curiosData, this.replaceExisting));
            }
            for (ItemStack stack : addLater) {
                ItemEntity itementity;
                if (player.m_36356_(stack) || (itementity = player.m_36176_(stack, false)) == null) continue;
                itementity.m_32061_();
                itementity.m_32047_(player.m_142081_());
            }
            return true;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("InvIds", (Tag)this.invIds.serializeNBT());
            nbt.m_128365_("Items", (Tag)this.items.serializeNBT());
            CompoundTag customData = new CompoundTag();
            this.customInventoryData.forEach((arg_0, arg_1) -> ((CompoundTag)customData).m_128365_(arg_0, arg_1));
            nbt.m_128365_("customData", (Tag)customData);
            nbt.m_128379_("removeSnapshotItems", this.removeSnapshotItems);
            nbt.m_128379_("replaceExisting", this.replaceExisting);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.invIds.deserializeNBT(nbt.m_128437_("InvIds", 3));
            this.items.deserializeNBT(nbt.m_128437_("Items", 10));
            this.customInventoryData.clear();
            if (nbt.m_128425_("customData", 10)) {
                CompoundTag customData = nbt.m_128469_("customData");
                for (String key : customData.m_128431_()) {
                    this.customInventoryData.put(key, customData.m_128469_(key));
                }
            }
            this.removeSnapshotItems = nbt.m_128471_("removeSnapshotItems");
            this.replaceExisting = nbt.m_128471_("replaceExisting");
        }
    }

    public static interface InventoryAccessor {
        public int getSize();
    }
}

