/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import java.time.Instant;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class GlobalTimeData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_GlobalTime";
    private long startTime = Instant.now().getEpochSecond();
    private long endTime = this.startTime + 7776000L;
    private long additionalTime;

    public long getTimeRemaining() {
        return this.endTime - this.startTime + this.additionalTime;
    }

    public long getEndTime() {
        return this.endTime + this.additionalTime;
    }

    public void reset(long dtSeconds) {
        this.startTime = Instant.now().getEpochSecond();
        this.endTime = this.startTime + dtSeconds;
        this.m_77762_();
    }

    public void addTime(long seconds) {
        this.additionalTime += seconds;
        this.m_77762_();
    }

    public static GlobalTimeData create(CompoundTag nbt) {
        GlobalTimeData data = new GlobalTimeData();
        data.load(nbt);
        return data;
    }

    public void load(CompoundTag tag) {
        this.startTime = tag.m_128454_("startTime");
        this.endTime = tag.m_128454_("endTime");
        this.additionalTime = tag.m_128454_("additionalTime");
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128356_("startTime", this.startTime);
        nbt.m_128356_("endTime", this.endTime);
        nbt.m_128356_("additionalTime", this.additionalTime);
        return nbt;
    }

    public static GlobalTimeData get(ServerLevel world) {
        return (GlobalTimeData)world.m_142572_().m_129783_().m_8895_().m_164861_(GlobalTimeData::create, GlobalTimeData::new, DATA_NAME);
    }
}

