/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class EventTeamData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_EventTeams";
    private final List<Team> teams = new ArrayList<Team>();

    private void initialize() {
        Team team1 = new Team("Team Green", ChatFormatting.GREEN);
        team1.addMember("PeteZahHutt");
        team1.addMember("Stressmonster101");
        team1.addMember("ItsFundy");
        team1.addMember("5uppps");
        this.teams.add(team1);
        Team team2 = new Team("Team Yellow", ChatFormatting.GOLD);
        team2.addMember("Iskall85");
        team2.addMember("CaptainPuffy");
        team2.addMember("X33N");
        team2.addMember("CaptainSparklez");
        this.teams.add(team2);
        Team team3 = new Team("Team Aqua", ChatFormatting.AQUA);
        team3.addMember("HBomb94");
        team3.addMember("AntonioAsh");
        team3.addMember("falsesymmetry");
        team3.addMember("Tubbo_");
        this.teams.add(team3);
        this.m_77762_();
    }

    public void modifyScore(String name, int modify) {
        Team team = this.getTeam(name);
        if (team != null) {
            team.setScore(team.getScore() + modify);
            this.m_77762_();
        }
    }

    public List<Team> getTeams() {
        if (this.teams.isEmpty()) {
            this.initialize();
        }
        return this.teams;
    }

    @Nullable
    public Team getTeam(String name) {
        return this.getTeams().stream().filter(team -> team.getName().equals(name)).findFirst().orElse(null);
    }

    private static EventTeamData create(CompoundTag tag) {
        EventTeamData data = new EventTeamData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag tag) {
        this.teams.clear();
        ListTag teams = tag.m_128437_("teams", 10);
        for (int i = 0; i < teams.size(); ++i) {
            this.teams.add(new Team(teams.m_128728_(i)));
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag teams = new ListTag();
        this.teams.forEach(team -> teams.add((Object)team.serialize()));
        tag.m_128365_("teams", (Tag)teams);
        return tag;
    }

    public static EventTeamData get(ServerLevel world) {
        return (EventTeamData)world.m_142572_().m_129783_().m_8895_().m_164861_(EventTeamData::create, EventTeamData::new, DATA_NAME);
    }

    public static class Team {
        private final String name;
        private final ChatFormatting color;
        private final List<String> members = new ArrayList<String>();
        private int score = 0;

        public Team(String name, ChatFormatting color) {
            this.name = name;
            this.color = color;
        }

        public Team(CompoundTag tag) {
            this.name = tag.m_128461_("name");
            this.color = ChatFormatting.values()[tag.m_128451_("color")];
            this.score = tag.m_128451_("score");
            ListTag players = tag.m_128437_("members", 8);
            for (int i = 0; i < players.size(); ++i) {
                this.members.add(players.m_128778_(i));
            }
        }

        public String getName() {
            return this.name;
        }

        public ChatFormatting getColor() {
            return this.color;
        }

        public int getScore() {
            return this.score;
        }

        public void setScore(int score) {
            this.score = score;
        }

        public List<String> getMembers() {
            return this.members;
        }

        public boolean addMember(String member) {
            if (this.members.contains(member)) {
                return false;
            }
            return this.members.add(member);
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("name", this.name);
            tag.m_128405_("color", this.color.ordinal());
            tag.m_128405_("score", this.score);
            ListTag players = new ListTag();
            this.members.forEach(member -> players.add((Object)StringTag.m_129297_((String)member)));
            tag.m_128365_("members", (Tag)players);
            return tag;
        }
    }
}

