/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.gear.trinket.TrinketEffect;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.gear.TrinketItem;
import iskallia.vault.network.message.transmog.DiscoveredEntriesMessage;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DiscoveredTrinketsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_DiscoveredTrinkets";
    protected Map<UUID, Set<ResourceLocation>> collectedTrinkets = new HashMap<UUID, Set<ResourceLocation>>();

    private DiscoveredTrinketsData() {
    }

    private DiscoveredTrinketsData(CompoundTag tag) {
        this.load(tag);
    }

    public void discoverTrinketAndBroadcast(ItemStack trinketStack, Player player) {
        if (trinketStack.m_41619_() || !(trinketStack.m_41720_() instanceof TrinketItem)) {
            return;
        }
        TrinketEffect<?> data = AttributeGearData.read(trinketStack);
        ((AttributeGearData)((Object)data)).getFirstValue(ModGearAttributes.TRINKET_EFFECT).ifPresent(trinket -> {
            if (this.discoverTrinket(player.m_142081_(), (TrinketEffect<?>)((Object)trinket))) {
                this.broadcastDiscovery((TrinketEffect<?>)((Object)trinket), player, trinketStack);
            }
        });
    }

    private void broadcastDiscovery(TrinketEffect<?> trinket, Player player, ItemStack trinketStack) {
        MutableComponent ct = new TextComponent("").m_130940_(ChatFormatting.WHITE);
        MutableComponent playerCt = player.m_5446_().m_6881_();
        playerCt.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
        TextComponent trinketCmp = new TextComponent(trinket.getTrinketConfig().getName());
        trinketCmp.m_6270_(Style.f_131099_.m_131148_(trinket.getTrinketConfig().getComponentColor()).m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(TrinketItem.createBaseTrinket(trinket)))));
        MiscUtils.broadcast((Component)ct.m_7220_((Component)playerCt).m_130946_(" has discovered trinket: ").m_7220_((Component)trinketCmp));
    }

    public boolean discoverTrinket(UUID playerId, TrinketEffect<?> trinket) {
        Set trinketKeys = this.collectedTrinkets.computeIfAbsent(playerId, id -> new HashSet());
        if (trinketKeys.add(trinket.getRegistryName())) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public boolean hasDiscovered(Player player, TrinketEffect<?> trinket) {
        return this.hasDiscovered(player.m_142081_(), trinket.getRegistryName());
    }

    public boolean hasDiscovered(UUID playerId, ResourceLocation trinket) {
        return this.collectedTrinkets.getOrDefault(playerId, Collections.emptySet()).contains(trinket);
    }

    public void m_77760_(boolean dirty) {
        MinecraftServer srv;
        super.m_77760_(dirty);
        if (dirty && (srv = ServerLifecycleHooks.getCurrentServer()) != null) {
            srv.m_6846_().m_11314_().forEach(this::syncTo);
        }
    }

    private DiscoveredEntriesMessage getUpdatePacket(UUID playerId) {
        return new DiscoveredEntriesMessage(DiscoveredEntriesMessage.Type.TRINKETS, this.collectedTrinkets.getOrDefault(playerId, Collections.emptySet()));
    }

    public void syncTo(ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)this.getUpdatePacket(player.m_142081_()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void load(CompoundTag tag) {
        this.collectedTrinkets.clear();
        ListTag playerTrinkets = tag.m_128437_("trinkets", 10);
        for (int i = 0; i < playerTrinkets.size(); ++i) {
            CompoundTag playerTag = playerTrinkets.m_128728_(i);
            UUID playerId = playerTag.m_128342_("player");
            Set<ResourceLocation> trinkets = NBTHelper.readSet(playerTag, "trinkets", StringTag.class, strTag -> new ResourceLocation(strTag.m_7916_()));
            this.collectedTrinkets.put(playerId, trinkets);
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tag) {
        ListTag playerTrinkets = new ListTag();
        this.collectedTrinkets.forEach((playerId, trinkets) -> {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("player", playerId);
            NBTHelper.writeCollection(playerTag, "trinkets", trinkets, StringTag.class, key -> StringTag.m_129297_((String)key.toString()));
            playerTrinkets.add((Object)playerTag);
        });
        tag.m_128365_("trinkets", (Tag)playerTrinkets);
        return tag;
    }

    public static DiscoveredTrinketsData get(ServerLevel level) {
        return DiscoveredTrinketsData.get(level.m_142572_());
    }

    public static DiscoveredTrinketsData get(MinecraftServer server) {
        return (DiscoveredTrinketsData)server.m_129783_().m_8895_().m_164861_(DiscoveredTrinketsData::new, DiscoveredTrinketsData::new, DATA_NAME);
    }
}

