/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.dynamodel.model.item.PlainItemModel;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModRelics;
import iskallia.vault.util.MiscUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DiscoveredRelicsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_DiscoveredRelics";
    private Map<UUID, Set<ResourceLocation>> discoveredRelics = new HashMap<UUID, Set<ResourceLocation>>();

    private DiscoveredRelicsData() {
    }

    private DiscoveredRelicsData(CompoundTag tag) {
        this.load(tag);
    }

    public Set<ResourceLocation> getDiscoveredRelics(UUID playerId) {
        return this.discoveredRelics.computeIfAbsent(playerId, uuid -> new HashSet());
    }

    public static Set<ResourceLocation> getRelics(UUID playerId) {
        return DiscoveredRelicsData.get((MinecraftServer)ServerLifecycleHooks.getCurrentServer()).discoveredRelics.computeIfAbsent(playerId, uuid -> new HashSet());
    }

    public boolean discoverRelicAndBroadcast(Player player, ModRelics.RelicRecipe relicRecipe) {
        if (this.getDiscoveredRelics(player.m_142081_()).add(relicRecipe.getResultingRelic())) {
            this.broadcastRelicDiscovery(player, relicRecipe);
            this.m_77762_();
            return true;
        }
        return false;
    }

    private void broadcastRelicDiscovery(Player player, ModRelics.RelicRecipe relicRecipe) {
        PlainItemModel relicModel = ModDynamicModels.Relics.RELIC_REGISTRY.get(relicRecipe.getResultingRelic()).orElse(null);
        if (relicModel == null) {
            return;
        }
        MutableComponent msgContainer = new TextComponent("").m_130940_(ChatFormatting.WHITE);
        MutableComponent playerName = player.m_5446_().m_6881_();
        playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
        TextComponent relicName = new TextComponent(relicModel.getDisplayName());
        relicName.m_6270_(Style.f_131099_.m_178520_(-2505149));
        MiscUtils.broadcast((Component)msgContainer.m_7220_((Component)playerName).m_130946_(" has assembled ").m_7220_((Component)relicName).m_130946_(" for the first time."));
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        this.discoveredRelics.forEach((uuid, modelIds) -> {
            ListTag modelIdsTag = new ListTag();
            modelIds.forEach(modelId -> modelIdsTag.add((Object)StringTag.m_129297_((String)modelId.toString())));
            compound.m_128365_(uuid.toString(), (Tag)modelIdsTag);
        });
        return compound;
    }

    public void load(CompoundTag compound) {
        this.discoveredRelics.clear();
        for (String uuidKey : compound.m_128431_()) {
            UUID uuid = UUID.fromString(uuidKey);
            HashSet modelIds = new HashSet();
            compound.m_128437_(uuidKey, 8).stream().map(Tag::m_7916_).map(ResourceLocation::new).forEach(modelIds::add);
            this.discoveredRelics.put(uuid, modelIds);
        }
    }

    public static DiscoveredRelicsData get(ServerLevel level) {
        return DiscoveredRelicsData.get(level.m_142572_());
    }

    public static DiscoveredRelicsData get(MinecraftServer server) {
        return (DiscoveredRelicsData)server.m_129783_().m_8895_().m_164861_(DiscoveredRelicsData::new, DiscoveredRelicsData::new, DATA_NAME);
    }
}

