/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.dynamodel.model.armor.ArmorModel;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.gear.VaultGearRarity;
import iskallia.vault.gear.data.VaultGearData;
import iskallia.vault.gear.item.VaultGearItem;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.gear.VaultArmorItem;
import iskallia.vault.network.message.transmog.DiscoveredEntriesMessage;
import iskallia.vault.util.MiscUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DiscoveredModelsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_DiscoveredModels";
    protected Map<UUID, Set<ResourceLocation>> discoveredModels = new HashMap<UUID, Set<ResourceLocation>>();

    private DiscoveredModelsData() {
    }

    private DiscoveredModelsData(CompoundTag tag) {
        this.load(tag);
    }

    public void discoverModelAndBroadcast(ItemStack vaultGear, Player player) {
        if (vaultGear.m_41619_() || !(vaultGear.m_41720_() instanceof VaultGearItem)) {
            return;
        }
        VaultGearData data = VaultGearData.read(vaultGear);
        data.getFirstValue(ModGearAttributes.GEAR_MODEL).ifPresent(modelId -> this.discoverModelAndBroadcast(vaultGear.m_41720_(), (ResourceLocation)modelId, player));
    }

    public void discoverModelAndBroadcast(Item gearItem, ResourceLocation modelId, Player player) {
        if (!(gearItem instanceof VaultGearItem)) {
            return;
        }
        VaultGearItem vaultGearItem = (VaultGearItem)gearItem;
        boolean collected = this.discoverModel(player.m_142081_(), modelId);
        if (collected) {
            this.broadcastModelDiscovery(modelId, player, vaultGearItem);
        }
    }

    public void discoverAllArmorPieceAndBroadcast(Player player, ArmorModel armorModel) {
        armorModel.getPieces().values().forEach(armorModelPiece -> {
            boolean collected = this.discoverModel(player.m_142081_(), armorModelPiece.getId());
            if (collected) {
                VaultArmorItem armorItem = VaultArmorItem.forSlot(armorModelPiece.getEquipmentSlot());
                this.broadcastModelDiscovery(armorModelPiece.getId(), player, armorItem);
            }
        });
    }

    public boolean discoverRandomArmorPieceAndBroadcast(Player player, ArmorModel armorModel, Random random) {
        List<ArmorPieceModel> pieces = armorModel.getPieces().values().stream().toList();
        ArmorPieceModel randomPiece = pieces.get(random.nextInt(pieces.size()));
        boolean collected = this.discoverModel(player.m_142081_(), randomPiece.getId());
        if (collected) {
            VaultArmorItem armorItem = VaultArmorItem.forSlot(randomPiece.getEquipmentSlot());
            this.broadcastModelDiscovery(randomPiece.getId(), player, armorItem);
            return true;
        }
        return false;
    }

    public void reset(UUID playerUUID) {
        if (this.discoveredModels.remove(playerUUID) != null) {
            this.m_77762_();
        }
    }

    public boolean discoverModel(UUID playerUUID, ResourceLocation modelId) {
        if (this.discoveredModels.computeIfAbsent(playerUUID, id -> new HashSet()).add(modelId)) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    private void broadcastModelDiscovery(ResourceLocation modelId, Player player, VaultGearItem vaultGearItem) {
        ModDynamicModels.REGISTRIES.getAssociatedRegistry(vaultGearItem.getItem()).flatMap(registry -> registry.get(modelId)).ifPresent(model -> {
            MutableComponent msgContainer = new TextComponent("").m_130940_(ChatFormatting.WHITE);
            MutableComponent playerName = player.m_5446_().m_6881_();
            playerName.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)9974168)));
            TextComponent pieceName = new TextComponent(model.getDisplayName());
            VaultGearRarity rollRarity = ModConfigs.GEAR_MODEL_ROLL_RARITIES.getRarityOf(vaultGearItem, modelId);
            pieceName.m_6270_(Style.f_131099_.m_131148_(rollRarity.getColor()));
            MiscUtils.broadcast((Component)msgContainer.m_7220_((Component)playerName).m_130946_(" has discovered ").m_7220_((Component)pieceName).m_130946_(" transmog."));
        });
    }

    public Set<ResourceLocation> getDiscoveredModels(UUID playerUUID) {
        return this.discoveredModels.getOrDefault(playerUUID, Collections.emptySet());
    }

    public void m_77760_(boolean dirty) {
        MinecraftServer srv;
        super.m_77760_(dirty);
        if (dirty && (srv = ServerLifecycleHooks.getCurrentServer()) != null) {
            srv.m_6846_().m_11314_().forEach(this::syncTo);
        }
    }

    private DiscoveredEntriesMessage getUpdatePacket(UUID playerId) {
        return new DiscoveredEntriesMessage(DiscoveredEntriesMessage.Type.MODELS, this.getDiscoveredModels(playerId));
    }

    public void syncTo(ServerPlayer player) {
        ModNetwork.CHANNEL.sendTo((Object)this.getUpdatePacket(player.m_142081_()), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        this.discoveredModels.forEach((uuid, modelIds) -> {
            ListTag modelIdsTag = new ListTag();
            modelIds.forEach(modelId -> modelIdsTag.add((Object)StringTag.m_129297_((String)modelId.toString())));
            compound.m_128365_(uuid.toString(), (Tag)modelIdsTag);
        });
        return compound;
    }

    public void load(CompoundTag compound) {
        this.discoveredModels.clear();
        for (String uuidKey : compound.m_128431_()) {
            UUID uuid = UUID.fromString(uuidKey);
            HashSet modelIds = new HashSet();
            compound.m_128437_(uuidKey, 8).stream().map(Tag::m_7916_).map(ResourceLocation::new).forEach(modelIds::add);
            this.discoveredModels.put(uuid, modelIds);
        }
    }

    public static DiscoveredModelsData get(ServerLevel level) {
        return DiscoveredModelsData.get(level.m_142572_());
    }

    public static DiscoveredModelsData get(MinecraftServer server) {
        return (DiscoveredModelsData)server.m_129783_().m_8895_().m_164861_(DiscoveredModelsData::new, DiscoveredModelsData::new, DATA_NAME);
    }
}

