/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.bounty.Bounty;
import iskallia.vault.bounty.BountyList;
import iskallia.vault.bounty.TaskRegistry;
import iskallia.vault.bounty.TaskReward;
import iskallia.vault.bounty.task.ItemDiscoveryTask;
import iskallia.vault.bounty.task.Task;
import iskallia.vault.config.bounty.task.TaskConfig;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.nbt.NBTHelper;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BountyData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_Bounties";
    private final HashMap<UUID, BountyList> active = new HashMap();
    private final HashMap<UUID, BountyList> available = new HashMap();
    private final HashMap<UUID, BountyList> complete = new HashMap();

    private Optional<Bounty> getActiveFor(UUID playerId, UUID bountyId) {
        if (!this.active.containsKey(playerId)) {
            return Optional.empty();
        }
        return this.active.get(playerId).findById(bountyId);
    }

    public BountyList getAllAvailableFor(UUID playerId) {
        if (this.available.containsKey(playerId)) {
            return this.available.get(playerId);
        }
        BountyList list = this.available.computeIfAbsent(playerId, id -> new BountyList());
        this.m_77762_();
        return list;
    }

    public BountyList getAllActiveFor(UUID playerId) {
        if (this.active.containsKey(playerId)) {
            return this.active.get(playerId);
        }
        BountyList list = this.active.computeIfAbsent(playerId, id -> new BountyList());
        this.m_77762_();
        return list;
    }

    public BountyList getAllCompletedFor(UUID playerId) {
        if (this.complete.containsKey(playerId)) {
            return this.complete.get(playerId);
        }
        BountyList list = this.complete.computeIfAbsent(playerId, id -> new BountyList());
        this.m_77762_();
        return list;
    }

    public BountyList getAllBountiesFor(UUID playerId) {
        BountyList list = new BountyList();
        list.addAll(this.active.computeIfAbsent(playerId, id -> new BountyList()));
        list.addAll(this.available.computeIfAbsent(playerId, id -> new BountyList()));
        list.addAll(this.complete.computeIfAbsent(playerId, id -> new BountyList()));
        return list;
    }

    public CompoundTag getAllBountiesAsTagFor(UUID playerId) {
        CompoundTag bounties = new CompoundTag();
        bounties.m_128365_("active", (Tag)this.getAllActiveFor(playerId).serializeNBT());
        bounties.m_128365_("available", (Tag)this.getAllAvailableFor(playerId).serializeNBT());
        bounties.m_128365_("abandoned", (Tag)this.getAllCompletedFor(playerId).serializeNBT());
        return bounties;
    }

    public <T extends Task<?>> List<T> getAllActiveTasksById(ServerPlayer player, ResourceLocation taskId) {
        return this.active.values().stream().flatMap(Collection::stream).filter(bounty -> bounty.getPlayerId().equals(player.m_142081_())).map(Bounty::getTask).filter(task -> task.getTaskType().equals((Object)taskId)).toList();
    }

    public void resetAvailableBountiesFor(UUID playerId) {
        this.available.remove(playerId);
        int totalBounties = 3;
        int amountToGenerate = totalBounties - this.getAllActiveFor(playerId).size() - this.getAllCompletedFor(playerId).size();
        this.available.put(playerId, this.generate(playerId, amountToGenerate));
        this.m_77762_();
    }

    private Bounty generateBounty(UUID playerId) {
        int vaultLevel = PlayerVaultStatsData.get(ServerLifecycleHooks.getCurrentServer()).getVaultStats(playerId).getVaultLevel();
        ResourceLocation taskId = ModConfigs.BOUNTY_CONFIG.getRandomTask();
        Object config = TaskConfig.getConfig(taskId);
        Object properties = ((TaskConfig)config).getGeneratedTaskProperties(vaultLevel);
        TaskReward reward = ModConfigs.REWARD_CONFIG.generateReward(vaultLevel);
        UUID bountyId = UUID.randomUUID();
        return new Bounty(bountyId, playerId, (Task<?>)TaskRegistry.createTask(taskId, bountyId, properties, reward));
    }

    private BountyList generate(UUID playerId, int amount) {
        BountyList list = new BountyList();
        for (int i = 0; i < amount; ++i) {
            list.add(this.generateBounty(playerId));
        }
        return list;
    }

    public void setActive(UUID playerId, UUID bountyId) {
        BountyList active = this.getAllActiveFor(playerId);
        if (active.size() > 0) {
            return;
        }
        BountyList available = this.getAllAvailableFor(playerId);
        Optional<Bounty> bountyOptional = available.findById(bountyId);
        if (bountyOptional.isEmpty()) {
            return;
        }
        if (available.removeById(bountyId)) {
            active.add(bountyOptional.get());
            this.m_77762_();
        }
    }

    public void abandon(UUID playerId, UUID bountyId) {
        Optional<Bounty> activeBounty = this.getActiveFor(playerId, bountyId);
        if (activeBounty.isEmpty()) {
            return;
        }
        Bounty active = activeBounty.get();
        active.setExpiration(Instant.now().plus((long)ModConfigs.BOUNTY_CONFIG.getAbandonedPenaltyInHours(), ChronoUnit.HOURS).toEpochMilli());
        this.getAllActiveFor(playerId).removeById(bountyId);
        this.getAllCompletedFor(playerId).add(active);
        this.m_77762_();
    }

    public void complete(ServerPlayer player, UUID bountyId) {
        UUID playerId = player.m_142081_();
        Optional<Bounty> activeBounty = this.getActiveFor(playerId, bountyId);
        if (activeBounty.isEmpty()) {
            return;
        }
        Bounty active = activeBounty.get();
        active.setExpiration(Instant.now().plus((long)ModConfigs.BOUNTY_CONFIG.getWaitingPeriodInHours(), ChronoUnit.HOURS).toEpochMilli());
        this.getAllActiveFor(playerId).removeById(bountyId);
        this.getAllCompletedFor(playerId).add(active);
        active.getTask().getTaskReward().apply(player);
        this.m_77762_();
    }

    public void reroll(ServerPlayer player, UUID bountyId) {
        UUID playerId = player.m_142081_();
        this.getAllActiveFor(playerId).removeById(bountyId);
        this.getAllAvailableFor(playerId).removeById(bountyId);
        this.getAllCompletedFor(playerId).removeById(bountyId);
        this.getAllAvailableFor(playerId).add(this.generateBounty(playerId));
        this.m_77762_();
    }

    private boolean playerExists(UUID uuid) {
        return this.active.containsKey(uuid) || this.available.containsKey(uuid) || this.complete.containsKey(uuid);
    }

    private void clearAll() {
        this.available.clear();
        this.active.clear();
        this.complete.clear();
    }

    public static BountyData create(CompoundTag nbt) {
        BountyData data = new BountyData();
        CommonEvents.ENTITY_DROPS.register((Object)data, ItemDiscoveryTask::onLootGeneration, -1);
        CommonEvents.CHEST_LOOT_GENERATION.post().register((Object)data, ItemDiscoveryTask::onLootGeneration, -1);
        CommonEvents.COIN_STACK_LOOT_GENERATION.post().register((Object)data, ItemDiscoveryTask::onLootGeneration, -1);
        CommonEvents.LOOTABLE_BLOCK_GENERATION_EVENT.post().register((Object)data, ItemDiscoveryTask::onLootGeneration, -1);
        data.load(nbt);
        return data;
    }

    private void load(CompoundTag tag) {
        this.clearAll();
        CompoundTag availableTag = tag.m_128469_("available");
        availableTag.m_128431_().forEach(idString -> {
            UUID playerId = UUID.fromString(idString);
            List<Bounty> list = NBTHelper.readList(availableTag, idString, CompoundTag.class, Bounty::new);
            this.available.put(playerId, new BountyList(list));
        });
        CompoundTag activeTag = tag.m_128469_("active");
        activeTag.m_128431_().forEach(idString -> {
            UUID playerId = UUID.fromString(idString);
            List<Bounty> list = NBTHelper.readList(activeTag, idString, CompoundTag.class, Bounty::new);
            this.active.put(playerId, new BountyList(list));
        });
        CompoundTag completeTag = tag.m_128469_("complete");
        completeTag.m_128431_().forEach(idString -> {
            UUID playerId = UUID.fromString(idString);
            List<Bounty> list = NBTHelper.readList(completeTag, idString, CompoundTag.class, Bounty::new);
            this.complete.put(playerId, new BountyList(list));
        });
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag availableTag = new CompoundTag();
        CompoundTag activeTag = new CompoundTag();
        CompoundTag completeTag = new CompoundTag();
        this.available.forEach((playerId, bountyList) -> NBTHelper.writeCollection(availableTag, playerId.toString(), bountyList, CompoundTag.class, Bounty::serializeNBT));
        this.active.forEach((playerId, bountyList) -> NBTHelper.writeCollection(activeTag, playerId.toString(), bountyList, CompoundTag.class, Bounty::serializeNBT));
        this.complete.forEach((playerId, bountyList) -> NBTHelper.writeCollection(completeTag, playerId.toString(), bountyList, CompoundTag.class, Bounty::serializeNBT));
        nbt.m_128365_("available", (Tag)availableTag);
        nbt.m_128365_("active", (Tag)activeTag);
        nbt.m_128365_("complete", (Tag)completeTag);
        return nbt;
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer().m_183503_().m_5776_()) {
            return;
        }
        if (BountyData.get().playerExists(event.getPlayer().m_142081_())) {
            return;
        }
        BountyData.get().resetAvailableBountiesFor(event.getPlayer().m_142081_());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        BountyData.get().tick();
    }

    public void tick() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_129783_().m_46467_() % 20L == 0L) {
            this.checkAbandonedExpiration();
        }
    }

    private void checkAbandonedExpiration() {
        if (this.complete.isEmpty()) {
            return;
        }
        List<Bounty> expired = this.complete.values().stream().flatMap(Collection::stream).filter(Bounty::isExpired).toList();
        for (Bounty bounty : expired) {
            UUID bountyId = bounty.getId();
            UUID playerId = bounty.getPlayerId();
            BountyList completedBounties = this.complete.get(playerId);
            if (!completedBounties.removeById(bountyId)) continue;
            this.getAllAvailableFor(playerId).add(this.generateBounty(playerId));
            this.m_77762_();
        }
    }

    public void resetAllBounties(UUID uuid) {
        this.active.computeIfAbsent(uuid, id -> new BountyList()).clear();
        this.available.computeIfAbsent(uuid, id -> new BountyList()).clear();
        this.complete.computeIfAbsent(uuid, id -> new BountyList()).clear();
        this.resetAvailableBountiesFor(uuid);
        this.m_77762_();
    }

    public static BountyData get() {
        return (BountyData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(BountyData::create, BountyData::new, DATA_NAME);
    }
}

