/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModFeatures;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.util.NetcodeUtils;
import iskallia.vault.world.gen.structure.ArenaStructure;
import iskallia.vault.world.legacy.raid.ArenaRaid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArenaRaidData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_ArenaRaid";
    private Map<UUID, Integer> raidsToStart = new HashMap<UUID, Integer>();
    private Map<UUID, ArenaRaid> activeRaids = new HashMap<UUID, ArenaRaid>();
    private Map<UUID, ItemStack> scheduledCrates = new HashMap<UUID, ItemStack>();
    private int xOffset = 0;

    public ArenaRaid getAt(BlockPos pos) {
        return this.activeRaids.values().stream().filter(raid -> raid.box.m_71051_((Vec3i)pos)).findFirst().orElse(null);
    }

    public void remove(ServerLevel server, UUID playerId) {
        ArenaRaid v = this.activeRaids.remove(playerId);
        if (v != null) {
            v.finish(server, server.m_142572_().m_6846_().m_11259_(playerId));
        }
    }

    public ArenaRaid getActiveFor(ServerPlayer player) {
        return this.activeRaids.get(player.m_142081_());
    }

    public ArenaRaid startNew(ServerPlayer player) {
        player.m_5661_((Component)new TextComponent("Generating arena, please wait...").m_130940_(ChatFormatting.GREEN), true);
        ArenaRaid raid = new ArenaRaid(player.m_142081_(), new BoundingBox(this.xOffset, 0, 0, this.xOffset += 2048, 256, 2048));
        if (this.activeRaids.containsKey(player.m_142081_())) {
            // empty if block
        }
        this.activeRaids.put(raid.getPlayerId(), raid);
        this.m_77762_();
        MinecraftServer server = player.m_20194_();
        this.raidsToStart.put(player.m_142081_(), server.m_129921_() + 100);
        return raid;
    }

    public void scheduleCrateToGive(ServerPlayer player, ItemStack crateStack) {
        this.scheduledCrates.put(player.m_142081_(), crateStack);
    }

    public boolean m_77764_() {
        return true;
    }

    public void tick(ServerLevel world) {
        this.activeRaids.values().forEach(vaultRaid -> vaultRaid.tick(world));
        boolean removed = false;
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        for (ArenaRaid raid : this.activeRaids.values()) {
            if (!raid.isComplete()) continue;
            tasks.add(() -> this.remove(world, raid.getPlayerId()));
            removed = true;
        }
        tasks.forEach(Runnable::run);
        if (removed || this.activeRaids.size() > 0) {
            this.m_77762_();
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            ArenaRaidData arenaRaidData = ArenaRaidData.get((ServerLevel)event.world);
            MinecraftServer server = event.world.m_142572_();
            int tickCounter = server.m_129921_();
            arenaRaidData.raidsToStart.forEach((uuid, scheduledTick) -> {
                if (tickCounter >= scheduledTick) {
                    NetcodeUtils.runIfPresent(server, uuid, player -> {
                        ArenaRaid raid = arenaRaidData.getActiveFor((ServerPlayer)player);
                        server.m_18707_(() -> {
                            try {
                                ServerLevel world = server.m_129880_(VaultMod.ARENA_KEY);
                                ChunkPos chunkPos = new ChunkPos(raid.box.m_162395_() + raid.box.m_71056_() / 2 >> 4, raid.box.m_162398_() + raid.box.m_71058_() / 2 >> 4);
                                StructureStart start = ((ArenaStructure.Feature)ModFeatures.ARENA_FEATURE.m_203334_()).m_204707_(world.m_5962_(), world.m_7726_().m_8481_(), world.m_7726_().m_8481_().m_62218_(), world.m_8875_(), world.m_7328_(), chunkPos, 0, (LevelHeightAccessor)world, biomeHolder -> true);
                                int chunkRadius = 64;
                                for (int x = -chunkRadius; x <= chunkRadius; x += 17) {
                                    for (int z = -chunkRadius; z <= chunkRadius; z += 17) {
                                        world.m_6522_(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z, ChunkStatus.f_62314_, true).m_207296_((ConfiguredStructureFeature)ModFeatures.ARENA_FEATURE.m_203334_(), start);
                                    }
                                }
                                raid.start(world, (ServerPlayer)player, chunkPos);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        });
                    });
                }
            });
            arenaRaidData.raidsToStart.values().removeIf(scheduledTick -> tickCounter >= scheduledTick);
            if (event.world.m_46472_() == VaultMod.ARENA_KEY) {
                arenaRaidData.tick((ServerLevel)event.world);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            ServerPlayer player = (ServerPlayer)event.player;
            ArenaRaidData arenaRaidData = ArenaRaidData.get(player.m_183503_());
            if (player.f_19853_.m_46472_() != VaultMod.ARENA_KEY && arenaRaidData.scheduledCrates.containsKey(player.m_142081_())) {
                ItemStack crateStack = arenaRaidData.scheduledCrates.remove(player.m_142081_());
                EntityHelper.giveItem((Player)player, crateStack);
            }
        }
    }

    @SubscribeEvent
    public static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
    }

    public static ArenaRaidData create(CompoundTag tag) {
        ArenaRaidData data = new ArenaRaidData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.activeRaids.clear();
        nbt.m_128437_("ActiveRaids", 10).forEach(raidNBT -> {
            ArenaRaid raid = ArenaRaid.fromNBT((CompoundTag)raidNBT);
            this.activeRaids.put(raid.getPlayerId(), raid);
        });
        this.xOffset = nbt.m_128451_("XOffset");
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag raidsList = new ListTag();
        this.activeRaids.values().forEach(raid -> raidsList.add((Object)raid.serializeNBT()));
        nbt.m_128365_("ActiveRaids", (Tag)raidsList);
        nbt.m_128405_("XOffset", this.xOffset);
        return nbt;
    }

    public static ArenaRaidData get(ServerLevel world) {
        return (ArenaRaidData)world.m_142572_().m_129783_().m_8895_().m_164861_(ArenaRaidData::create, ArenaRaidData::new, DATA_NAME);
    }
}

